
#include <stdio.h>
#include <string.h>
#include <translat.h>
#include "pamconf.h"
#include "pamconf.m"
#include "pamconf_tools.h"
#include "fviews.h"

#include "pc_securetty.cc"
#include "pc_access.cc"
#include "pc_limits.cc"
#include "pc_time.cc"
#include "pc_console_perms.cc"

/* returns !=0 if sucessfully moved */
int move_line_to(VIEWITEMS &given_vitems, int given_line_number)
{
    DIALOG_RECORDS my_dialog;
    MENU_STATUS my_button=MENU_NULL;
    int         my_selection=0;
    SSTRING     title_text;
    SSTRING     fullpath_filename;

    my_dialog.newf_head("", MSG_U(F_MTCLF, "module type\tcontrol\tlibrary file"));

    dump_viewitems_to_list(my_dialog, given_vitems, 3);

    /* opens dialog.. */
    my_selection=0;
    my_button=my_dialog.editmenu(MSG_U(T_MOVINGLINEPOSITION, "Moving line position"), "", help_nil, my_selection, MENUBUT_QUIT);

    switch(my_button){
    case MENU_QUIT:
    case MENU_ESCAPE:
        return(0);
    default:
        given_vitems.moveto(given_vitems.getitem(given_line_number), my_selection);
        return(1);
    }
}

/* edit a line of an entry */
void edit_line_of_entry(VIEWITEMS &given_vitems, int given_line_number, const char *given_entry_name, CONFIG_FILE &given_configfile)
{
    DIALOG my_dialog;
    MENU_STATUS my_button=MENU_NULL;
    int         my_selection=0;
    FIELD_LIST  *fl_module_type,
                *fl_control_type;
    SSTRING     title_text;
    SSTRING     module_type,
                control_type,
                module_lib,
                mod_parameters;
    SSTRING     *given_line;
    SSTRINGS    libs_list;
    const char  *short_libname;

    /* dependant on chosen library (they won't be used simultaneously or not used at all depending on library) */
    struct{
        char shadow, nullok, md5, use_authtok;
    }pam_pwdb;
    struct{
        SSTRING retry, difok, minlen;
        SSTRING dcredit, ucredit, tcredit, ocredit;
    }pam_cracklib;
    struct{
        char debug;
        SSTRING conf;
    }pam_limits;

    title_text.setfromf(MSG_U(T_ENTRYDFORS, "Entry #%d for \"%s\""), given_line_number+1, given_entry_name);
    given_line=&(given_vitems.getitem(given_line_number)->line);

    /* load vars to memory */
    gimme_word_from_string(given_line->get(), module_type, 0);
    gimme_word_from_string(given_line->get(), control_type, 1);
    gimme_word_from_string(given_line->get(), module_lib, 2);
    gimme_word_from_string(given_line->get(), mod_parameters, 3, 1);

    short_libname=pick_filename_from_fullpath(module_lib.get());

    /* builds gui */
    my_dialog.newf_info(MSG_U(F_MODULELIBRARY, "Module library:"), short_libname);
    fl_module_type=my_dialog.newf_list(MSG_U(F_MODULETYPE, "Module type:"), module_type);
    fl_module_type->addopt("auth", MSG_U(X_AUTHENTICATION, "authentication"), "");
    fl_module_type->addopt("account", MSG_U(X_ACCOUNTING, "accounting"), "");
    fl_module_type->addopt("password", MSG_U(X_PASSWORD, "password"), "");
    fl_module_type->addopt("session", MSG_U(X_SESSION, "session"), "");
    fl_control_type=my_dialog.newf_list(MSG_U(F_CONTROLTYPE, "Control type:"), control_type);
    fl_control_type->addopt("required", MSG_U(X_REQUIRED, "required"), "");
    fl_control_type->addopt("requisite", MSG_U(X_REQUISITE, "requisite"), "");
    fl_control_type->addopt("sufficient", MSG_U(X_SUFFICIENT, "sufficient"), "");
    fl_control_type->addopt("optional", MSG_U(X_OPTIONAL, "optional"), "");

    /* loads vars and builds part of gui, dependant on chosen library */
    {
        int already_built=0;

        if(!strcmp(short_libname, "pam_pwdb.so")){
            spbool(pam_pwdb.shadow,"shadow",MSG_U(F_PWDBSHADOWPASSWORDS, "Shadow passwords:"));
            spbool(pam_pwdb.nullok,"nullok",MSG_U(F_PWDBPERMITBLANKPASSOWORDS, "Permit blank passwords:"));
            spbool(pam_pwdb.md5,"md5",MSG_U(F_PWDBUSEMD5CRYPTOINSTEAD, "Use MD5 cryptography instead:"));
            spbool(pam_pwdb.use_authtok,"use_authtok",MSG_U(F_PWDBUSEPREVIOUSAUTH, "Use previous authentication:"));

            already_built=1;
        }
        if(!strcmp(short_libname, "pam_cracklib.so")){
            spstring(pam_cracklib.retry,"retry=",MSG_U(F_CLRETRY, "Retry:"));
            spstring(pam_cracklib.difok,"difok=",MSG_U(F_CLNEWDIFFCHARACTERS, "New different characters:"));
            spstring(pam_cracklib.minlen,"minlen=",MSG_U(F_CLMINLENGTH, "Minimum length:"));
            spstring(pam_cracklib.dcredit,"dcredit=",MSG_U(F_CLCREDITSFROMDIG, "Credits from digits:"));
            spstring(pam_cracklib.ucredit,"ucredit=",MSG_U(F_CLCREDITSFROMUPP, "Credits from uppercases:"));
            spstring(pam_cracklib.tcredit,"tcredit=",MSG_U(F_CLCREDITSFROMLWR, "Credits from lowercases:"));
            spstring(pam_cracklib.ocredit,"ocredit=",MSG_U(F_CLCREDITSFROMOTH, "Credits from other chars:"));

            already_built=1;
        }
        if(!strcmp(short_libname, "pam_limits.so")){
            spbool(pam_limits.debug,"debug",MSG_U(F_LIMDEBUG, "Debug:"));
            spstring(pam_limits.conf,"conf=",MSG_U(F_LIMALTCONFIGFILE, "Alt. config file:"));

            already_built=1;
        }
        if(!strcmp(short_libname, "")){


            already_built=1;
        }
        if(!already_built)
            my_dialog.newf_str(MSG_U(F_MODULEPARAMETERS, "Module parameters (opt.):"), mod_parameters);
    }

    while(1){
        /* opens dialog.. */
        my_dialog.setbutinfo(MENU_USR1, MSG_U(X_MOVEBUTTON, "Move..."), NULL);
        my_selection=0;
        my_button=my_dialog.edit(title_text.get(), MSG_U(I_FIELDBLANKUSEDEFAULT, "Some fields may be left blank\nso the internal defaults will be used instead."), hf_entry_prop, my_selection, MENUBUT_QUIT|MENUBUT_ACCEPT|MENUBUT_DEL|MENUBUT_USR1);

        switch(my_button){
        case MENU_QUIT:
        case MENU_ESCAPE:
            return;
        case MENU_DEL:
            if(confirm_yesno_window(MSG_U(T_LINEDELETION, "Line deletion"), MSG_U(I_LINEDELETION, "Do you really want to delete this line?"))){
                given_vitems.remove_del(given_vitems.getitem(given_line_number));
                given_vitems.write(given_configfile, NULL);
                return;
            }
            break;
        case MENU_ACCEPT:
            (*given_line).setfromf("%s %s %s", module_type.get(), control_type.get(), module_lib.get());
            {
                int already_built=0;

                if(!strcmp(short_libname, "pam_pwdb.so")){
                    spboolS(pam_pwdb.shadow,"shadow");
                    spboolS(pam_pwdb.nullok,"nullok");
                    spboolS(pam_pwdb.md5,"md5");
                    spboolS(pam_pwdb.use_authtok,"use_authtok");

                    already_built=1;
                }
                if(!strcmp(short_libname, "pam_cracklib.so")){
                    spstringS(pam_cracklib.retry,"retry=");
                    spstringS(pam_cracklib.difok,"difok=");
                    spstringS(pam_cracklib.minlen,"minlen=");
                    spstringS(pam_cracklib.dcredit,"dcredit=");
                    spstringS(pam_cracklib.ucredit,"ucredit=");
                    spstringS(pam_cracklib.tcredit,"tcredit=");
                    spstringS(pam_cracklib.ocredit,"ocredit=");

                    already_built=1;
                }
                if(!strcmp(short_libname, "pam_limits.so")){
                    spboolS(pam_limits.debug,"debug");
                    spstringS(pam_limits.conf,"conf=");

                    already_built=1;
                }

                if(!strcmp(short_libname, "")){


                    already_built=1;
                }

                if(!already_built)
                    (*given_line).appendf(" %s", mod_parameters.get());
            }




//            (*given_line).setfromf("%s %s %s %s", module_type.get(), control_type.get(), module_lib.get(), mod_parameters.get());
            given_vitems.write(given_configfile, NULL);
            return;
        case MENU_USR1:
            if(move_line_to(given_vitems, given_line_number))
                given_vitems.write(given_configfile, NULL);
            return;
        default:
        break;
        }
    }

}

/* edit entry properties */
void edit_entry_properties(const char *given_entry_name, const char *given_directory)
{
    DIALOG_RECORDS my_dialog;
    MENU_STATUS my_button=MENU_NULL;
    int         my_selection=0;
    SSTRING     title_text;
    SSTRING     fullpath_filename;

    fullpath_filename.setfromf("%s/%s", given_directory, given_entry_name);
    CONFIG_FILE cf_pamconf(fullpath_filename.get(), help_nil, CONFIGF_MANAGED);
    VIEWITEMS_PARSER pre_vitems_pamconf;

    while(1){
        VIEWITEMS vitems_pamconf(pre_vitems_pamconf);
        vitems_pamconf.read(cf_pamconf); // load file data

        my_dialog.remove_all(); // cleans window
        title_text.setfromf(MSG_U(T_TABLEFOR, "Table for \"%s\""), given_entry_name);
        my_dialog.newf_head("", MSG_U(F_MTCL, "module type\tcontrol\tlibrary"));

        dump_viewitems_to_list(my_dialog, vitems_pamconf, 3);

        /* opens dialog.. */
        my_selection=0;
        my_button=my_dialog.editmenu(title_text.get(), MSG_U(I_SENSITIVEPOSITION, "Note that this table is sensitive\nto items' positions."), hf_list_edit, my_selection, MENUBUT_QUIT|MENUBUT_ADD|MENUBUT_DEL);

        switch(my_button){
        case MENU_QUIT:
        case MENU_ESCAPE:
            return;
        case MENU_ADD:
            {
                int line_number;
                MENU_STATUS my_button=MENU_NULL;
                int         my_selection=0;
                SSTRING     module_lib;
                FIELD_LIST  *fl_module_lib;
                SSTRINGS    libs_list;
                SSTRING     new_added_line;
                {
                    DIALOG dia_modlib;

                    module_lib.setfrom(MSG_U(X_UNDEFINED, "not_defined"));
                    fl_module_lib=dia_modlib.newf_list(MSG_U(F_MODULELIB, "Module library:"), module_lib);
                    fill_sstrings_with_filenames(SECLIBS_DIR, libs_list);
                    libs_list.sort();
                    {
                        int my_loop=0;
                        int my_limit;
                        SSTRING fullpath_filename;

                        my_limit=libs_list.getnb();
                        while(my_loop<my_limit){
                            fullpath_filename.setfromf("%s/%s", SECLIBS_DIR, libs_list.getitem(my_loop)->get());
                            fl_module_lib->addopt(fullpath_filename.get(), libs_list.getitem(my_loop)->get(), "");
                            my_loop++;
                        }
                    }

                    my_selection=0;
                    my_button=dia_modlib.edit(MSG_U(X_NEWLINEBUTTON, "New line..."), "", help_nil, my_selection, MENUBUT_QUIT|MENUBUT_ACCEPT);
                }
                if(my_button==MENU_ACCEPT){
                    new_added_line.setfromf(MSG_U(X_UNDEFUNDEFS, "not_defined not_defined %s"), module_lib.get());
                    line_number=vitems_pamconf.getnb();
                    vitems_pamconf.add(new VIEWITEM(new_added_line.get()));
                    edit_line_of_entry(vitems_pamconf, line_number, given_entry_name, cf_pamconf);
                }
            }
            break;
        case MENU_DEL:
            {
                SSTRING my_title;
                SSTRING my_text;

                my_title.setfromf(MSG_U(T_DELREQUESTEDFOR, "Deletion requested for \"%s\""), given_entry_name);
                my_text.setfromf(MSG_U(I_DELREQUESTEDFOR, "You requested deletion for \"%s\".\nIT IS VERY DANGEROUS TO DELETE SUCH ENTRY.\nARE YOU *REALLY* SURE YOU TO DELETE THIS ONE?\n"), given_entry_name);
                if(confirm_yesno_window(my_title.get(), my_text.get())){
                    if(!confirm_yesno_window(MSG_U(T_SECONDCONFIRM, "Second confirmation"), MSG_U(I_SECONDCONFIRM, "Do you want to give up deleting?\nClicking \"Yes\" will do nothing.\nClick \"No\" if you want to DELETE it."))){
                        cf_pamconf.unlink(); /* adis muchacho.. */
                        return;
                    }
                }
            }
            break;
        default:
            edit_line_of_entry(vitems_pamconf, my_selection, given_entry_name, cf_pamconf);
            break;
        }
    }
}

/* select/create/delete the files inside the /etc/pam.d directory */
void edit_pam_entries(void)
{
    DIALOG_RECORDS my_dialog;
    MENU_STATUS my_button=MENU_NULL;
    int         my_selection=0;

    while(1){
        SSTRINGS    my_filenames; /* filenames from /etc/pam.d */

        my_dialog.remove_all(); // cleans window
        my_dialog.newf_head("", MSG_U(F_DEFINEDENTRIES, "defined entries"));

        fill_sstrings_with_filenames(PAM_ENTRIES_DIR, my_filenames);
        adjust_var(my_filenames);
        my_filenames.sort();
        dump_sstrings_to_list(my_dialog, my_filenames);

        /* opens dialog.. */
        my_selection=0;
        my_button=my_dialog.editmenu(MSG_U(T_DEFINEDENTRIES, "Defined PAM entries"), MSG_U(I_DEFINEDENTRIES, "Each entry here represents a program/service\nwhich uses PAM for authentication."), hf_list_edit, my_selection, MENUBUT_QUIT|MENUBUT_ADD);

        switch(my_button){
        case MENU_QUIT:
        case MENU_ESCAPE:
            return;
        case MENU_ADD:
            {
                SSTRING newentry_name;
                if(ask_a_name(MSG_U(T_NEWPAMENTRY, "New PAM entry"), "", MSG_U(F_NAMEFORNEWENTRY, "Name for new entry:"), newentry_name, 1)){
                    if(my_filenames.lookup(newentry_name.get())==-1){
                        SSTRING fullpath_filename;

                        fullpath_filename.setfromf("%s/%s", PAM_ENTRIES_DIR, newentry_name.get());
                        CONFIG_FILE cf_pamconf(fullpath_filename.get(), help_nil, CONFIGF_MANAGED);
                        if(!cf_pamconf.exist())
                            cf_pamconf.create();
                    }
                }
            }
            break;
        default:
            edit_entry_properties(my_filenames.getitem(my_selection)->get(), PAM_ENTRIES_DIR);

            break;
        }
    }
}

void pam_modules_settings(void)
{
    MENU_STATUS my_button=MENU_NULL;
    int         my_selection=0;
    DIALOG_MENU dia_mymenu;

    my_selection=0;
    dia_mymenu.new_menuitem(MSG_U(M_SECURETTY, "Secure TTY"), MSG_U(M_SECURETTYSO, "(pam_securetty.so)"));
    dia_mymenu.new_menuitem(MSG_U(M_ACCESS, "Access"), MSG_U(M_ACCESSSO, "(pam_access.so)"));
    dia_mymenu.new_menuitem(MSG_U(M_LIMITS, "Limits"), MSG_U(M_LIMITSSO, "(pam_limits.so)"));
    dia_mymenu.new_menuitem(MSG_U(M_TIME, "Time"), MSG_U(M_TIMESO, "(pam_time.so)"));
    dia_mymenu.new_menuitem(MSG_U(M_CONSOLEPERMS, "Console Perms"), MSG_U(M_CONSOLEPERMSSO, "(pam_console.so)"));

    while(1){
        my_button=dia_mymenu.editmenu(MSG_U(T_SETT4PAMMODULES, "Settings for PAM modules"), MSG_U(I_SETT4PAMMODULES, "The properties for each PAM module\nonly affects the programs/services\nwhich uses the respective library."), help_nil, my_selection, MENUBUT_QUIT);
        if((my_button==MENU_QUIT)||(my_button==MENU_ESCAPE))
            return;

        switch(my_selection){
        case 0:
            securetty_window();
            break;
        case 1:
            access_window();
            break;
        case 2:
            limits_window();
            break;
        case 3:
            time_window();
            break;
        case 4:
            consperms_window();
            break;
        }
    }
}

void heres_mainwindow(void)
{
    MENU_STATUS my_button=MENU_NULL;
    int         my_selection=0;
    DIALOG_MENU dia_mymenu;

    my_selection=0;
    dia_mymenu.new_menuitem("", "", MSG_U(M_EDITPAMENTRIES, "Edit PAM entries"));
    dia_mymenu.new_menuitem("", "", MSG_U(M_EDITPAMMODSETT, "Edit PAM modules' settings"));

    while(1){
        my_button=dia_mymenu.editmenu(MSG_U(T_PAMCONFIGURATOR, "Configurator for PAM services"), MSG_U(I_SMARTMUSTBETOCHANGE, "DON'T CHANGE THESE SETTINGS UNLESS\nYOU REALLY KNOW WHAT YOU'RE DOING!"), help_nil, my_selection, MENUBUT_QUIT);
        if((my_button==MENU_QUIT)||(my_button==MENU_ESCAPE))
            return;

        switch(my_selection){
        case 0:
            if(perm_rootaccess(""))
                edit_pam_entries();
            break;
        case 1:
            if(perm_rootaccess(""))
                pam_modules_settings();
            break;
        }
    }
}

