
#ifndef devicelist_h
#define devicelist_h

#include <parser.h>
#include <map>
#include <string>

class DEVICELIST;

class DEVICE: public ARRAY_OBJ
{
	private:
		map<string,string> options;
	public:
		DEVICE();
		~DEVICE();

		char *name;
		char *descr;
		
		const char *get_option(const char *name);
	
	friend class DEVICELIST;

};

class DEVICELIST: public ARRAY
{
	private:
		const char *arch;
		const char *lang;

		void parse_device(xmlNodePtr cur);
		void parse_devicelist(xmlNodePtr cur);

	public:
		DEVICELIST(const char *filename, const char *type);
		DEVICE *getitem(int no) const;
		DEVICE *getitem_by_name(const char *name);
		DEVICE *getitem_by_descr(const char *descr);
                DEVICE *getitem_by_opt(const char *opttype, const char *whichone);
};

#endif /* devicelist_h */
