#ifndef PACKAGE_APIDEF_H
#define PACKAGE_APIDEF_H

struct VERSION_ELM{
	int val;
	char suffix[20];
};

struct PACKAGE_VERSION{
	char str[100];
	VERSION_ELM tb[10];
	int nbelm;
};
	
struct PACKAGE_API{
	int (*getver) (PACKAGE_API *o, const char *package, PACKAGE_VERSION &res);
	int (*is_newer) (PACKAGE_API *o, const char *package, const char *version);
	int (*path2pkg) (PACKAGE_API *o, const char *path, SSTRING &name, PACKAGE_VERSION &res);
	int (*showinfo) (PACKAGE_API *o, const char *pkg);
	// Install a selected list of package out of a dir containing more
	int (*installpkgs) (PACKAGE_API *o, const SSTRINGS &names, const char *dir, const char *cdtitle);
	// Set the root where the package are installed
	void (*setroot) (PACKAGE_API *o, const char *rootdir);
	// Retrieve the list of installed packages
	int (*listinstalled) (PACKAGE_API *o, SSTRINGS &lst);
	// Retrieve the list of files owned by a package.
	int (*listfiles) (PACKAGE_API *o, const char *package, SSTRINGS &lst);
};

#endif

