
/* section_edit_fileserv_opts(void) still needs some improvement */
void section_edit_fileserv_opts(void)
{
    DIALOG         my_dialog;
    MENU_STATUS    my_button=MENU_NULL;
    int            my_selection=0;
    int illegal_entry_found=1;

    INIT_FILE_NWSERVCONF;

    /* these settings must be improved (add support for -1 and 0 values) */
    my_dialog.newf_title(MSG_U(X_DEFAULTMODES, "Default modes"), 1, "", MSG_R(X_DEFAULTMODES));
    CREATE_STR_FIELD_STANDALONE(my_stdcreatdir,9,0,MSG_U(F_STDCREATMODDIR, "Standard create mode for directories:"));
    CREATE_STR_FIELD_STANDALONE(my_stdcreatfiles,9,1,MSG_U(F_STDCREATMODFILES, "Standard create mode for files:"));
    my_dialog.newf_title(MSG_U(X_MISC, "Misc"), 1, "", MSG_R(X_MISC));
    CREATE_BIN_CHK_FIELD_STANDALONE(my_allaccotherdirs,8,0,0,MSG_U(F_ALLOWACC2OTHERTHAN, "Allow access to other dirs than login/*"));
    CREATE_BIN_CHK_FIELD_STANDALONE(my_openasro,8,0,1,MSG_U(F_OPENASREADONLY, "Open as read-only (compatibility flag)"));
    CREATE_BIN_CHK_FIELD_STANDALONE(my_allrename,8,0,2,MSG_U(F_ALLOWRENFILCALL, "Allow the rename file call"));
    CREATE_BIN_CHK_FIELD_STANDALONE(my_alldelwhenopened,8,0,4,MSG_U(F_ALLOWFILEDELUSEDOTHERPROC, "Allow file deletion while used by another process"));
    CREATE_BIN_CHK_FIELD_STANDALONE(my_stofilebase,8,0,5,MSG_U(F_STOFILBASENTRIES, "Store file base entries for later use"));
    CREATE_BIN_CHK_FIELD_STANDALONE(my_reportup2gbfree,8,0,6,MSG_U(F_FREESPACEMAX2GB, "Limits volume's free space reporting to 2 GB"));

    while(illegal_entry_found){
        illegal_entry_found=0;
        my_button=my_dialog.edit(MSG_U(T_FSERVOPTIONS, "File server options"), "", hf_fileserver_opts, my_selection, MENUBUT_ACCEPT|MENUBUT_QUIT);

        switch(my_button){
        case MENU_ACCEPT:

            illegal_entry_found|=has_illegal_chars(my_stdcreatdir.get(), ILLEGAL_SPACES|ILLEGAL_EMPTYNESS|DIGITS_ONLY);
            illegal_entry_found|=has_illegal_chars(my_stdcreatfiles.get(), ILLEGAL_SPACES|ILLEGAL_EMPTYNESS|DIGITS_ONLY);

            if(!illegal_entry_found){
                save_standalone_vardata(my_stdcreatdir.get(), my_vitems, 9, 0);
                save_standalone_vardata(my_stdcreatfiles.get(), my_vitems, 9, 1);
                save_standalone_bin_flag(my_allaccotherdirs, my_vitems, 8, 0, 0);
                save_standalone_bin_flag(my_openasro, my_vitems, 8, 0, 1);
                save_standalone_bin_flag(my_allrename, my_vitems, 8, 0, 2);
                save_standalone_bin_flag(my_alldelwhenopened, my_vitems, 8, 0, 4);
                save_standalone_bin_flag(my_stofilebase, my_vitems, 8, 0, 5);
                save_standalone_bin_flag(my_reportup2gbfree, my_vitems, 8, 0, 6);

                SAVE_FILE_NWSERVCONF;
            }else{
                warnuser_invalid_data_entered();
            }
            break;
        default:
            break;
        }
    }
}

/* this also needs some improvement */
void section_edit_accounting_opts(void)
{
    DIALOG         my_dialog;
    MENU_STATUS    my_button=MENU_NULL;
    int            my_selection=0;
    int illegal_entry_found=1;

    INIT_FILE_NWSERVCONF;

    my_dialog.newf_title(MSG_R(X_MISC), 1, "", MSG_R(X_MISC));
    CREATE_LIST_FIELD_STANDALONE(my_phdos,my_lphdos,7,0,MSG_U(F_PASSWDHANDLDOSCLIENTS, "Password handling of DOS clients:"));
    ADD_LIST_ITEM_2(my_lphdos,"0",MSG_U(F_ENFENCRYPTALLPASSWD, "Enforce encryption of all passwords"));
    ADD_LIST_ITEM_2(my_lphdos,"1",MSG_U(F_ENFENCRYPTALLBUTALLOW, "Enforce encryption but allow non-encrypted"));
    ADD_LIST_ITEM_2(my_lphdos,"7",MSG_U(F_ALLOWNONENCNOEMPTY, "Allow non-encrypted stuff but no empty passwords"));
    ADD_LIST_ITEM_2(my_lphdos,"8",MSG_U(F_ALLOWNONENCEMPTY, "Allow non-encrypted stuff and empty passwords"));
    ADD_LIST_ITEM_2(my_lphdos,"9",MSG_U(F_FORCCLIENTUSEOLDCRYPT, "Force client to use old encrypted calls"));
    CREATE_BIN_CHK_FIELD_STANDALONE(my_ignoresupvtime,8,0,3,MSG_U(F_HELLO_MR_TRANSLATOR, "Ignore station/time restrictions for supervisor"));
    CREATE_BIN_CHK_FIELD_STANDALONE(my_giveuseremptyscript,17,0,0,MSG_U(F_GIVEEMPTYLOGSCRIPT, "Give empty login script if user hasn't one"));
    /* TO DO: this should be improved */
    my_dialog.newf_title(MSG_U(X_MINIMALRIGHTS, "Minimal rights"), 1, "", MSG_R(X_MINIMALRIGHTS));
    CREATE_STR_FIELD_STANDALONE(my_mrgi,10,0,MSG_U(F_GROUPID, "Group ID:"));
    CREATE_STR_FIELD_STANDALONE(my_mrui,11,0,MSG_U(F_USERID, "User ID:"));
    my_dialog.newf_title(MSG_U(X_USERSAUTOMAP, "Users' automap"), 1, "", MSG_R(X_USERSAUTOMAP));
    CREATE_LIST_FIELD_STANDALONE(my_am,my_am_l,15,0,MSG_U(F_DOUSERSAUTOMAP, "Do users' automapping:"));
    ADD_LIST_ITEM_2(my_am_l,"0",MSG_U(X_NO, "No"));
    ADD_LIST_ITEM_2(my_am_l,"1",MSG_U(X_YES, "Yes"));
    ADD_LIST_ITEM_2(my_am_l,"99",MSG_U(X_YESANDOVERWRITE, "Yes and overwrite existing ones"));
    CREATE_STR_FIELD_STANDALONE(my_defautompasswd,15,1,MSG_U(F_DEFAULTPASSWD, "Default password:"));

    while(illegal_entry_found){
        illegal_entry_found=0;
        my_button=my_dialog.edit(MSG_U(T_ACCOUNTINGOPTS, "Accounting options"), "", hf_accounting_opts, my_selection, MENUBUT_ACCEPT|MENUBUT_QUIT);

        switch(my_button){
        case MENU_ACCEPT:

            illegal_entry_found|=has_illegal_chars(my_mrgi.get(), ILLEGAL_SPACES|ILLEGAL_EMPTYNESS|DIGITS_ONLY);
            illegal_entry_found|=has_illegal_chars(my_mrui.get(), ILLEGAL_SPACES|ILLEGAL_EMPTYNESS|DIGITS_ONLY);
            illegal_entry_found|=has_illegal_chars(my_defautompasswd.get(), ILLEGAL_SPACES|ILLEGAL_EMPTYNESS);

            if(!illegal_entry_found){
                save_standalone_bin_flag(my_ignoresupvtime, my_vitems, 8, 0, 3);
                save_standalone_bin_flag(my_giveuseremptyscript, my_vitems, 17, 0, 0);
                save_standalone_vardata(my_mrgi.get(), my_vitems, 10, 0);
                save_standalone_vardata(my_mrui.get(), my_vitems, 11, 0);
                save_standalone_vardata(my_am.get(), my_vitems, 15, 0);
                save_standalone_vardata(my_defautompasswd.get(), my_vitems, 15, 1);
                save_standalone_vardata(my_phdos.get(), my_vitems, 7, 0);

                SAVE_FILE_NWSERVCONF;
            }else{
                warnuser_invalid_data_entered();
            }
            break;
        default:
            break;
        }
    }
}

void section_edit_supervisor_opts(void)
{
    DIALOG         my_dialog;
    MENU_STATUS    my_button=MENU_NULL;
    int            my_selection=0;
    int illegal_entry_found=1;

    INIT_FILE_NWSERVCONF;

    CREATE_STR_FIELD_STANDALONE(my_supvname,12,0,MSG_U(F_SUPERVISORUSERNAME, "Supervisor username:"));
    CREATE_STR_FIELD_STANDALONE(my_sysname,12,1,MSG_U(F_SUPERVISORSYSTEMUSER, "System user:"));
    CREATE_STR_FIELD_STANDALONE(my_passwd,12,2,MSG_U(F_SUPERVISORPASSWD, "Password:"));

    while(illegal_entry_found){
        illegal_entry_found=0;
        my_button=my_dialog.edit(MSG_U(T_SUPERVISOROPTS, "Supervisor options"), "", hf_supervisor_opts, my_selection, MENUBUT_ACCEPT|MENUBUT_QUIT);

        switch(my_button){
        case MENU_ACCEPT:

            illegal_entry_found|=has_illegal_chars(my_supvname.get(), ILLEGAL_SPACES|ILLEGAL_EMPTYNESS|UPPERCASE_ONLY);
            illegal_entry_found|=has_illegal_chars(my_sysname.get(), ILLEGAL_SPACES|ILLEGAL_EMPTYNESS);
            illegal_entry_found|=has_illegal_chars(my_passwd.get(), ILLEGAL_SPACES);

            if(!illegal_entry_found){
                save_standalone_vardata(my_supvname.get(), my_vitems, 12, 0);
                save_standalone_vardata(my_sysname.get(), my_vitems, 12, 1);
                save_standalone_vardata(my_passwd.get(), my_vitems, 12, 2);

                SAVE_FILE_NWSERVCONF;
            }else{
                warnuser_invalid_data_entered();
            }
            break;
        default:
            break;
        }
    }
}


void section_edit_print_opts(void)
{
    DIALOG         my_dialog;
    MENU_STATUS    my_button=MENU_NULL;
    int            my_selection=0;
    int illegal_entry_found=1;

    INIT_FILE_NWSERVCONF;

    CREATE_STR_FIELD_STANDALONE(my_path42,42,0,MSG_U(F_PRTOPTSPOOLDIR, "Spool directory:"));
    CREATE_BIN_CHK_FIELD_STANDALONE(my_disprtbanner,18,0,0,MSG_U(F_ALWAYSDISBANNERFLAG, "Always disable the print banner flag"));

    while(illegal_entry_found){
        illegal_entry_found=0;
        my_button=my_dialog.edit(MSG_U(T_PRINTOPTIONSOPTS, "Print options"), "", hf_prtservices_opts, my_selection, MENUBUT_ACCEPT|MENUBUT_QUIT);

        illegal_entry_found|=has_illegal_chars(my_path42.get(), ILLEGAL_SPACES);

        switch(my_button){
        case MENU_ACCEPT:

            if(!illegal_entry_found){
                save_standalone_bin_flag(my_disprtbanner, my_vitems, 18, 0, 0);
                save_standalone_vardata(my_path42.get(), my_vitems, 42, 0);

                SAVE_FILE_NWSERVCONF;
            }else{
                warnuser_invalid_data_entered();
            }
            break;
        default:
            break;
        }
    }
}

void section_edit_network_opts(void)
{
    DIALOG         my_dialog;
    MENU_STATUS    my_button=MENU_NULL;
    int            my_selection=0;
    int illegal_entry_found=1;

    INIT_FILE_NWSERVCONF;

    /* this field is a hex number (0x12345678) */
    CREATE_STR_FIELD_STANDALONE_SUBS(my_intnet,3,0,MSG_U(F_INTERNALNETWORK, "Internal network:"),"auto");
    CREATE_LIST_FIELD_STANDALONE(my_autoc,my_lautoc,3,1,MSG_U(F_NWAUTOCONFIGURATION, "Automatic configuration:"));
    ADD_LIST_ITEM_2(my_lautoc,"1",MSG_R(X_YES));
    ADD_LIST_ITEM_2(my_lautoc,"",MSG_R(X_NO));
    CREATE_BIN_CHK_FIELD_STANDALONE(my_sdev0,5,0,0,MSG_U(F_DONTREMROUTSIPXLTIME, "Don't remove routes/ipx-devs beyond lifetime"));
    CREATE_BIN_CHK_FIELD_STANDALONE(my_sdev1,5,0,1,MSG_U(F_AUTOKRNLCREATIPXDEVS, "Automatic kernel creation of ipx devices"));
    CREATE_BIN_CHK_FIELD_STANDALONE(my_sdev2,5,0,2,MSG_U(F_REMOVEROUIPXDEVBLTIME, "Do remove routes/ipx-devs beyond lifetime"));

    while(illegal_entry_found){
        illegal_entry_found=0;
        my_button=my_dialog.edit(MSG_U(T_NETWORKOPTIONS, "Network options"), "", hf_network_opts, my_selection, MENUBUT_ACCEPT|MENUBUT_QUIT);

        switch(my_button){
        case MENU_ACCEPT:

            illegal_entry_found|=has_illegal_chars(my_intnet.get(), ILLEGAL_SPACES);

            if(!illegal_entry_found){
                if(!*(my_intnet.get()))
                    my_intnet.setfrom("auto");
                save_standalone_vardata(my_intnet.get(), my_vitems, 3, 0);
                save_standalone_vardata(my_autoc.get(), my_vitems, 3, 1);
                save_standalone_bin_flag(my_sdev0, my_vitems, 5, 0, 0);
                save_standalone_bin_flag(my_sdev1, my_vitems, 5, 0, 1);
                save_standalone_bin_flag(my_sdev2, my_vitems, 5, 0, 2);

                SAVE_FILE_NWSERVCONF;
            }else{
                warnuser_invalid_data_entered();
            }
            break;
        default:
            break;
        }
    }
}

void section_edit_misc_opts(void)
{
    DIALOG         my_dialog;
    MENU_STATUS    my_button=MENU_NULL;
    int            my_selection=0;
    int illegal_entry_found=1;

    INIT_FILE_NWSERVCONF;

    my_dialog.newf_title(MSG_R(X_MISC), 1, "", MSG_R(X_MISC));
    CREATE_LIST_FIELD_STANDALONE(my_reportvers,my_lreportvers,6,0,MSG_U(F_REPORTEDSERVVERSION, "Reported server version:"));
    ADD_LIST_ITEM_2(my_lreportvers,"0",MSG_U(X_215, "2.15"));
    ADD_LIST_ITEM_2(my_lreportvers,"1",MSG_U(X_311, "3.11"));
    ADD_LIST_ITEM_2(my_lreportvers,"2",MSG_U(X_312, "3.12"));
    CREATE_BIN_CHK_FIELD_STANDALONE(my_enaburst,6,1,0,MSG_U(F_ENABURSTMODECONN, "Enable burst mode connections"));
    CREATE_LIST_FIELD_STANDALONE(my_sutests,my_lsutests,16,0,MSG_U(F_TESTSONSTARTUP, "Tests on startup:"));
    ADD_LIST_ITEM_2(my_lsutests,"0",MSG_U(X_NOTESTS, "No tests"));
    ADD_LIST_ITEM_2(my_lsutests,"1",MSG_U(X_DOIMPORTANTTESTS, "Do important tests"));
    ADD_LIST_ITEM_2(my_lsutests,"2",MSG_U(X_DOIMPORTANTTESTSAND, "Do important tests and also check/compress bindery"));

    CREATE_STR_FIELD_STANDALONE(my_burstread,30,0,MSG_U(F_MAXBURSTREAD, "Max. burst read (opt.):"));
    CREATE_STR_FIELD_STANDALONE(my_burstwrite,31,1,MSG_U(F_MAXBURSTWRITE, "Max. burst write (opt.):"));
    CREATE_STR_FIELD_STANDALONE(my_convtablefile,50,0,MSG_U(F_TABLE4FILENCONV, "Table for filename's convertion (opt.):"));
    CREATE_STR_FIELD_STANDALONE(my_maxconn,60,0,MSG_U(F_MAXCONNECTIONS, "Max. connections (opt.):"));
    CREATE_STR_FIELD_STANDALONE(my_maxnetvols,61,0,MSG_U(F_MASNETWVOLUMES, "Max. netware volumes (opt.):"));
    CREATE_STR_FIELD_STANDALONE(my_maxdirbase,63,0,MSG_U(F_MAXDIRBASEENTRIES, "Max. dir base entries (opt.):"));
    CREATE_LIST_FIELD_STANDALONE(my_usenmap,my_lusenmap,68,0,MSG_U(F_USENMAP, "Use NMAP:"));
    ADD_LIST_ITEM_2(my_lusenmap,"1",MSG_R(X_YES));
    ADD_LIST_ITEM_2(my_lusenmap,"0",MSG_R(X_NO));
    ADD_LIST_ITEM_2(my_lusenmap,"",MSG_U(X_NOTDEFINEDUSEINTDEF, "Not defined (use internal default)"));
    CREATE_LIST_FIELD_STANDALONE(my_saptypes,my_lsaptypes,69,0,MSG_U(F_SAPTYPESHANDLING, "SAP types handling:"));
    ADD_LIST_ITEM_2(my_lsaptypes,"1",MSG_U(X_SAPHANDLEALLTYPES, "Handle all types"));
    ADD_LIST_ITEM_2(my_lsaptypes,"0",MSG_U(X_SAPHANDLETYPE4ONLY, "Handle type 4 only"));
    ADD_LIST_ITEM_2(my_lsaptypes,"",MSG_R(X_NOTDEFINEDUSEINTDEF));
    CREATE_STR_FIELD_STANDALONE(my_netserno,70,0,MSG_U(F_NETWORKSERNUMBER, "Network serial number (opt.):"));
    CREATE_STR_FIELD_STANDALONE(my_netappno,71,0,MSG_U(F_NETWORKAPPNUMBER, "Network application number (opt.):"));
    my_dialog.newf_title(MSG_U(X_PATHS, "Paths"), 1, "", MSG_R(X_PATHS));
    CREATE_STR_FIELD_STANDALONE(my_path40,40,0,MSG_U(F_VOLDEVINODEPATHCACHE, "vol/dev/inode->path cache:"));
    CREATE_STR_FIELD_STANDALONE(my_path41,41,0,MSG_U(F_SHARELOCKFILES, "Share/lock files:"));
    CREATE_STR_FIELD_STANDALONE(my_path45,45,0,MSG_U(F_BINDERYFILES, "Bindery files:"));
    CREATE_STR_FIELD_STANDALONE(my_path46,46,0,MSG_U(F_ATTRIBUTEHANDLING, "Attribute handling:"));
    CREATE_STR_FIELD_STANDALONE(my_path47,47,0,MSG_U(F_TRUSTEEHANDLING, "Trustee handling:"));

    while(illegal_entry_found){
        illegal_entry_found=0;
        my_button=my_dialog.edit(MSG_U(T_MISCOPTIONS, "Misc options"), "", hf_misc_opts, my_selection, MENUBUT_ACCEPT|MENUBUT_QUIT);

        switch(my_button){
        case MENU_ACCEPT:

            illegal_entry_found|=has_illegal_chars(my_burstread.get(), ILLEGAL_SPACES);
            illegal_entry_found|=has_illegal_chars(my_burstwrite.get(), ILLEGAL_SPACES);
            illegal_entry_found|=has_illegal_chars(my_convtablefile.get(), ILLEGAL_SPACES);
            illegal_entry_found|=has_illegal_chars(my_maxconn.get(), DIGITS_ONLY);
            illegal_entry_found|=has_illegal_chars(my_maxnetvols.get(), DIGITS_ONLY);
            illegal_entry_found|=has_illegal_chars(my_maxdirbase.get(), DIGITS_ONLY);
            illegal_entry_found|=has_illegal_chars(my_netserno.get(), ILLEGAL_SPACES);
            illegal_entry_found|=has_illegal_chars(my_netappno.get(), ILLEGAL_SPACES);
            illegal_entry_found|=has_illegal_chars(my_path40.get(), ILLEGAL_SPACES);
            illegal_entry_found|=has_illegal_chars(my_path41.get(), ILLEGAL_SPACES);
            illegal_entry_found|=has_illegal_chars(my_path45.get(), ILLEGAL_SPACES);
            illegal_entry_found|=has_illegal_chars(my_path46.get(), ILLEGAL_SPACES);
            illegal_entry_found|=has_illegal_chars(my_path47.get(), ILLEGAL_SPACES);

            if(!illegal_entry_found){
                save_standalone_vardata(my_reportvers.get(), my_vitems, 6, 0);
                save_standalone_bin_flag(my_enaburst, my_vitems, 6, 1, 0);
                save_standalone_vardata(my_sutests.get(), my_vitems, 16, 0);

                save_standalone_vardata(my_burstread.get(), my_vitems, 30, 0);
                save_standalone_vardata(my_burstwrite.get(), my_vitems, 31, 0);
                save_standalone_vardata(my_convtablefile.get(), my_vitems, 50, 0);
                save_standalone_vardata(my_maxconn.get(), my_vitems, 60, 0);
                save_standalone_vardata(my_maxnetvols.get(), my_vitems, 61, 0);
                save_standalone_vardata(my_maxdirbase.get(), my_vitems, 63, 0);
                save_standalone_vardata(my_usenmap.get(), my_vitems, 68, 0);
                save_standalone_vardata(my_saptypes.get(), my_vitems, 69, 0);
                save_standalone_vardata(my_netserno.get(), my_vitems, 70, 0);
                save_standalone_vardata(my_netappno.get(), my_vitems, 71, 0);
                save_standalone_vardata(my_path40.get(), my_vitems, 40, 0);
                save_standalone_vardata(my_path41.get(), my_vitems, 41, 0);
                save_standalone_vardata(my_path45.get(), my_vitems, 45, 0);
                save_standalone_vardata(my_path46.get(), my_vitems, 46, 0);
                save_standalone_vardata(my_path47.get(), my_vitems, 47, 0);

                SAVE_FILE_NWSERVCONF;
            }else{
                warnuser_invalid_data_entered();
            }
            break;
        default:
            break;
        }
    }
}


