#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <limits.h>
#include "internal.h"

PUBLIC TBFILE::TBFILE(
	const char *_defpath,	// Default path
	bool _extract)		// Should we extract the content from the configuration
						// archive ?
{
	defpath = strdup(_defpath);
	extract = _extract;
	nbopen = 0;
	cur = NULL;
}

PUBLIC TBFILE::~TBFILE()
{
	while (nbopen > 0) ::fclose (tb[--nbopen]);
	free (defpath);
}


/*
	Open a new file and remember the one currently open.
	(put in on a stack). fclose will get it back.

	Return the FILE handle or NULL if can't open.
*/
PUBLIC FILE_CFG *TBFILE::fopen (
	const char *fname,
	const char *mode)
{
	FILE_CFG *ret = NULL;
	char abspath[PATH_MAX];
	if (fname[0] != '/'){
		sprintf (abspath,"%s/%s",defpath,fname);
		fname = abspath;
	}else{
		sprintf (abspath,"%s%s",linuxconf_getval(K_DNSCONF,K_CHROOT,""),fname);
		fname = abspath;
	}
	CONFIG_FILE *conf = new CONFIG_FILE(fname,help_nil,CONFIGF_OPTIONAL,subsys_dnsserv);
	if (conf != NULL){
		if (extract){
			conf->extract();
		}
		ret = conf->fopen (mode);
		if (ret != NULL){
			tb[nbopen++] = ret;
			cur = ret;
		}
		tbconf.add (conf);
	}
	return ret;
}

PUBLIC void TBFILE::fclose ()
{
	if (nbopen > 0){
		::fclose (cur);
		cur = NULL;
		nbopen--;
		if (nbopen > 0) cur = tb[nbopen-1];
	}
}

