#pragma implementation
#include <stdio.h>
#include <string.h>
#include <translat.h>
#include "aptconf.h"
#include "aptconf.m"

MODULE_DEFINE_VERSION(aptconf);

PUBLIC MODULE_aptconf::MODULE_aptconf()
	: LINUXCONF_MODULE("aptconf")
{
	linuxconf_loadmsg ("aptconf",PACKAGE_REV);
}


static const char *keymenu=NULL;

PUBLIC void MODULE_aptconf::setmenu (
	DIALOG &dia,
	MENU_CONTEXT context)
{
	if (context == MENU_MISCSERV){
		keymenu = MSG_U(M_aptconf,"Apt");
		dia.new_menuitem ("aptconf","",keymenu);
	}
}

PUBLIC int MODULE_aptconf::domenu (
	MENU_CONTEXT context,
	const char *key)
{
	if (context == MENU_MISCSERV){
		if (key == keymenu){
			aptconf_edit();
		}
	}
	return 0;
}


PUBLIC int MODULE_aptconf::dohtml (const char *key)
{
	int ret = LNCF_NOT_APPLICABLE;
	if (strcmp(key,"aptconf")==0){
		ret = 0;
	}
	return ret;
}


static void usage()
{
	xconf_error (MSG_U(T_USAGE
		,"linuxconf --modulemain aptconf usage\n"
		 "\n"
		 "    aptconf --option ...\n")
		);
}

PUBLIC void MODULE_aptconf::usage (SSTRINGS &tb)
{
	tb.add (new SSTRING (MSG_R(T_USAGE)));
}

PUBLIC int MODULE_aptconf::message (
	const char *msg,
	int argc,
	const char *argv[])
{
        int ret = LNCF_NOT_APPLICABLE;
        if (strcmp(msg,"about")==0){
                ret = 0;
                SSTRINGS *tb = (SSTRINGS*)argv[0];
                tb->add (new SSTRING(MSG_U(A_ABOUT1,"Module aptconf was written by Gustavo Niemeyer (niemeyer@conectiva.com)")));
	}
        return ret;
}


PUBLIC int MODULE_aptconf::execmain (int argc , char *argv[], bool standalone)
{
	int ret = LNCF_NOT_APPLICABLE;
	const char *pt = strrchr(argv[0],'/');
	if (pt != NULL){
		pt++;
	}else{
		pt = argv[0];
	}
	if (strcmp(pt,"aptconf")==0){
		ret = -1;
		if (argc == 1){
			aptconf_edit();
		}else{
			// ### Add some option parsing for the module
			::usage();
		}
	}
	return ret;
}


static MODULE_aptconf aptconf;

