#include "internal.h"
#include "apache.m"
#include "keyword.h"

static APACHE_HELP_FILE help_dir ("dir");
static APACHE_HELP_FILE help_file ("file");

extern CONFIG_FILE httpd_conf;

PUBLIC void HTTPD_OVERRIDE::setallopt(int val)
{
	char cval = (val != 0) ? 1 : 0;
	authconfig = cval;
	fileinfo = cval;
	indexes = cval;
	limit = cval;
	options = cval;
}

PUBLIC HTTPD_OVERRIDE::HTTPD_OVERRIDE(VIEWITEMS_SUB &sub)
{
	setallopt (0);
	it = sub.locate (K_ALLOWOVERRIDE);
	if (it != NULL){
		setallopt (0);
		const char *arg = viewsub_getval (it);
		while (1){
			char word[200];
			arg=str_copyword(word,arg,sizeof(word));
			if (word[0] == '\0'){
				break;
			}else if (stricmp(word,K_NONE)==0){
				setallopt(0);
			}else if (stricmp(word,K_ALL)==0){
				setallopt(1);
			}else if (stricmp(word,K_AUTHCONFIG)==0){
				authconfig = 1;
			}else if (stricmp(word,K_FILEINFO)==0){
				fileinfo = 1;
			}else if (stricmp(word,K_INDEXES)==0){
				indexes = 1;
			}else if (stricmp(word,K_LIMIT)==0){
				limit = 1;
			}else if (stricmp(word,K_OPTIONS)==0){
				options = 1;
			}
		}
	}
}

PUBLIC void HTTPD_OVERRIDE::setdia (DIALOG &dia)
{
	dia.newf_title (MSG_U(T_OVERRIDE,"Override policies"),1,"",MSG_R(T_OVERRIDE));
	dia.newf_chk ("",authconfig,MSG_U(I_AUTHCONFIG,"Authentification configs"));
	dia.newf_chk ("",fileinfo,MSG_U(I_FILEINFO,"File info"));
	dia.newf_chk ("",indexes,MSG_R(I_INDEXES));
	dia.newf_chk ("",limit,MSG_U(I_LIMIT,"Limits"));
	dia.newf_chk ("",options,MSG_U(I_OPTIONS,"Options"));
}

/*
	Edit one <directory ...> section
*/
static int diredit_editdir (VIEW_SECTION &sec, const char *_path)
{
	int ret = -1;
	HTTPD_OVERRIDE over (sec);
	HTTPD_FEATURES features (sec);

	DIALOG dia;
	VIEWEDIT vedit (sec,dia);
	FIELD_COMBO *combo;

	dia.setbutinfo (MENU_USR1,MSG_U(B_USERSCONF,"Users Configuration"),"");
	SSTRING path (_path);
	dia.newf_str (MSG_U(F_PATH,"Directory path"),path);

	features.setdia (dia);
	over.setdia (dia);

	dia.newf_title (MSG_U(T_DIRSSL,"SSL Options"),1,"",MSG_R(T_DIRSSL));
	vedit.newf_str (MSG_R(F_SSLCIPHERSUITE),K_SSLCIPHERSUITE);
	vedit.newf_str (MSG_U(F_SSLREQUIRE,"Require"),K_SSLREQUIRE);
	vedit.newf_str (MSG_R(F_SSLOPTIONS),K_SSLOPTIONS);
	vedit.newf_num (MSG_U(F_SSLVERIFYDEPTH,"Verify Depth"),K_SSLVERIFYDEPTH,1);
    vedit.newf_chk ("",K_SSLREQUIRESSL,MSG_U(I_SSLREQUIRESSL,"SSL require SSL"),0);


    combo = vedit.newf_combo (MSG_R(F_SSLVERIFYCLIENT),K_SSLVERIFYCLIENT);

	verifyclientcomb(*combo);


	int nof = 0;
	while (1){
		MENU_STATUS code = dia.edit (MSG_U(T_DIRRULES,"Directory rules")
			,MSG_U(I_DIRRULES,"You are allowed to enter configurations\n"
				"which apply to this directory and its sub-directories\n")
			,help_dir
			,nof,MENUBUT_ACCEPT|MENUBUT_CANCEL|MENUBUT_DEL|MENUBUT_USR1);
		if (code == MENU_ESCAPE || code == MENU_CANCEL){
			break;
		}else if (code == MENU_DEL){
			if (xconf_delok()){
				ret = 1;
				break;
			}
		}else if (code == MENU_USR1) {
			//auths.edit();
			xconf_notice ("Not done");
		}else{
			sec.updatehead (path.get());
			features.update("\t",sec);
			over.update ("\t",sec);
			vedit.update("\t");
			ret = 0;
			break;
		}
	}
	return ret;
}

/*
	Edit the file and filematch directives
*/
static int diredit_fileedit(VIEW_SECTION &sec, const char *_path)
{
	int ret = -1;
	HTTPD_OVERRIDE over (sec);
	HTTPD_FEATURES features (sec);
	DIALOG dia;
	SSTRING path (_path);
	dia.newf_str (MSG_U(F_FPATH,"File(s) path"),path);
	features.setdia (dia);
	over.setdia (dia);
	int nof = 0;
	while (1){
		MENU_STATUS code = dia.edit (MSG_U(T_FILERULES,"Files rules")
			,MSG_U(I_FILERULES,"You are allowed to enter configurations\n"
				"which apply to this file(s)\n")
			,help_file
			,nof,MENUBUT_ACCEPT|MENUBUT_CANCEL|MENUBUT_DEL);
		if (code == MENU_ESCAPE || code == MENU_CANCEL){
			break;
		}else if (code == MENU_DEL){
			if (xconf_delok()){
				ret = 1;
				break;
			}
		}else{
			sec.updatehead (path.get());
			features.update("\t",sec);
			over.update ("\t",sec);
			// vedit.update();
			ret = 0;
			break;
		}
	}
	return ret;
}

PUBLIC int HTTPD_CONFIG::editdirs()
{
	int ret = -1, nof = 0;
	DIALOG_RECORDS dia;
	dia.newf_head ("",MSG_U(H_DIR,"Directories"));
	dia.addwhat (MSG_U(I_NEWDIR,"Select [Add] to add a new directory rule"));
	while (1){
		SSTRING_IDXS tbs;
		itemss.locatesection (K_DIRECTORY,tbs);
		tbs.sort();
		for (int i=0; i<tbs.getnb(); i++){
			const char *v = tbs.getitem(i)->get();
			dia.set_menuitem(i,v,"");
		}
		dia.remove_last (tbs.getnb()+1);

		MENU_STATUS code = dia.editmenu (MSG_U(T_DIRS,"Directories")
			,MSG_U(I_DIRS,"You can override various rules directory\n"
				"per directory")
			,help_dir
			,nof,0);
		if (code == MENU_ESCAPE || code == MENU_QUIT){
			break;
		}else if (code == MENU_ADD){
			VIEW_SECTION sec(K_DIRECTORY,itemss);
			ret = diredit_editdir (sec,NULL);
			if (ret == 0) write();
		}else if (nof < tbs.getnb() && nof >= 0){
			const char *v = tbs.getitem(nof)->get();
			VIEW_SECTION sec (K_DIRECTORY,itemss);
			sec.setview (v);
			ret = diredit_editdir (sec,v);
			if (ret == 0){
				write();
			}else if (ret == 1){
				sec.delall();
				write();
			}
		}
	}
	return ret;
}

/*
	Edit the Files or Filematch directives
*/
PUBLIC int HTTPD_CONFIG::editfiles(bool filematch)
{
	const char *keyword = filematch ? K_FILESMATCH : K_FILES;
	int ret = -1, nof = 0;
	DIALOG_RECORDS dia;
	dia.newf_head ("",MSG_U(T_FILES,"Files"));
	dia.addwhat (MSG_U(I_NEWFILE
		,"Select [Add] to add a new file(s) rule(s)"));

	while (1){
		SSTRING_IDXS tmp;
		itemss.locatesection (keyword,tmp);
		tmp.sort();
		
		for(int i=0;i<tmp.getnb();i++){
			dia.set_menuitem(i,tmp.getitem(i)->get(),"");
		}
		dia.remove_last (tmp.getnb()+1);

		MENU_STATUS code = dia.editmenu (MSG_R(T_FILES)
			,MSG_U(I_FILES,"You can override various rules files\n"
				"per files")
			,help_file
			,nof,0);
		if (code == MENU_ESCAPE || code == MENU_QUIT){
			break;
		}else if (code == MENU_ADD){
			VIEW_SECTION sec (keyword,itemss);
			ret = diredit_fileedit (sec,NULL);
			if (ret == 0) write();
		}else if (nof < tmp.getnb() && nof >= 0){
			SSTRING_IDX *s = tmp.getitem(nof);
			const char *v = s->get();
			int idx = s->getidx();
			VIEW_SECTION sec (keyword,itemss);
			sec.setview (idx);
			ret = diredit_fileedit (sec,v);
			if (ret == 0){
				write();
			}else if (ret == 1){
				sec.delall();
				write();
			}
		}
	}
	return ret;
}

