#include "misc.h"

// To force the link
void arraykey_required(){}

/* #Specification: ARRAY_KEYS / principles
	An ARRAY_KEYS object is a table holding pairs of values. One value
	is the key, a string and the other is an object derived from the
	ARRAY_OBJ class.

	While the ARRAY_KEYS may be managed somewhat like the parent class
	ARRAY, adding items, getting items using a numeric index (using
	the getitem() member function), the real purpose is to request the
	value of the stored object using the string key. We call this an
	associative array, where the index is a string, not an integer.

	The main usage of ARRAT_KEYS is the class STRING_KEYS, where the
	value is another string. Note that such a functionality can by
	implemented using two SSTRINGS table. One store the key and the
	other store the value. You use the lookup function to retrive
	the position of the key and use that value to retrieve the string
	value in the other table.

	The goal here is to avoid redundancies in the code.
*/
#

PUBLIC ARRAY_KEY::ARRAY_KEY (
	const char *_key,
	ARRAY_OBJ *_obj,
	bool is_owner)
	: SSTRING(_key)
{
	obj = _obj;
	owner = is_owner;
}

PUBLIC ARRAY_KEY::~ARRAY_KEY()
{
	if (owner) delete obj;
}

PUBLIC void ARRAY_KEYS::add (const char *key, ARRAY_OBJ *obj)
{
	ARRAY::add (new ARRAY_KEY(key,obj,true));
}

PUBLIC void ARRAY_KEYS::add (const char *key, ARRAY_OBJ *obj, bool owner)
{
	ARRAY::add (new ARRAY_KEY(key,obj,owner));
}

PUBLIC ARRAY_KEY *ARRAY_KEYS::getitem(int no) const
{
	return (ARRAY_KEY*)ARRAY::getitem(no);
}

/*
	Return the key+object pair holding that key
*/
PUBLIC ARRAY_KEY *ARRAY_KEYS::getobj(const char *key) const
{
	ARRAY_KEY *ret = NULL;
	int n = getnb();
	for (int i=0; i<n; i++){
		ARRAY_KEY *ar = getitem(i);
		if (ar->cmp(key)==0){
			ret = ar;
			break;
		}
	}
	return ret;
}

/*
	Return the object associated with the key
*/
PUBLIC ARRAY_OBJ *ARRAY_KEYS::getval(const char *key) const
{
	ARRAY_OBJ *ret = NULL;
	ARRAY_KEY *obj = getobj (key);
	if (obj != NULL) ret = obj->obj;
	return ret;
}

static int cmp (const ARRAY_OBJ *o1, const ARRAY_OBJ *o2)
{
	SSTRING *s1 = (SSTRING *)o1;
	SSTRING *s2 = (SSTRING *)o2;
	return s1->cmp(*s2);
}

/*
	Sort the array of SSTRING
*/
PUBLIC void ARRAY_KEYS::sort ()
{
	ARRAY::sort (cmp);
}


PUBLIC SSTRING_KEY::SSTRING_KEY (const char *_key, const char *_val)
	: ARRAY_KEY (_key,new SSTRING(_val),true)
{
}

PUBLIC SSTRING *SSTRING_KEY::getobj ()
{
	return (SSTRING *)obj;
}
PUBLIC const char *SSTRING_KEY::getobjval ()
{
	SSTRING *s = (SSTRING *)obj;
	return s->get();
}

PUBLIC void SSTRING_KEYS::add (const char *key, const char *val)
{
	ARRAY::add (new SSTRING_KEY(key,val));
}

PUBLIC SSTRING_KEY *SSTRING_KEYS::getitem (int no) const
{
	return (SSTRING_KEY*)ARRAY_KEYS::getitem(no);
}

/*
	Return the STRING_KEY or NULL associated with the key
*/
PUBLIC SSTRING_KEY *SSTRING_KEYS::getobj (const char *key) const
{
	SSTRING_KEY *ret = NULL;
	ARRAY_KEY *obj = ARRAY_KEYS::getobj(key);
	if (obj != NULL){
		ret = (SSTRING_KEY *)obj;
	}
	return ret;
}

/*
	Return the string or NULL associated with the key
*/
PUBLIC const char *SSTRING_KEYS::getval (const char *key) const
{
	const char *ret = NULL;
	ARRAY_OBJ *obj = ARRAY_KEYS::getval(key);
	if (obj != NULL){
		SSTRING *s = (SSTRING *)obj;
		ret = s->get();
	}
	return ret;
}


