#pragma interface
#ifndef DIAWXXT
#define DIAWXXT

#define STRETCH_NONE 0
#define STRETCH_LOOK 1		// Accept to stretch itself
#define STRETCH_INFO 2		// Has stretchable information

#include <wx.h>

class MFORM;
class BOOK;
class MAINFORM;
class DCNAME;

class HLINE: public wxPanel{
	const char *s;
	int pref_width,pref_height;
	/*~PROTOBEG~ HLINE */
public:
	HLINE (MFORM *_parent, const char *_s);
	void OnPaint (void);
private:
	void draw3dline (wxDC *dc, int x, int y, int end);
public:
	~HLINE (void);
	/*~PROTOEND~ HLINE */
};

#define MFORM_OPTFLAT	1
#define MFORM_OPT3D		2

class MFORM_C{
public:
	bool is_hcontrib;	// Contribue  la disposition horizontale
	bool homemade;		// This is not a real widget but manage
						// by hand using the wxDC drawing context
	char h_align;		// Alignement  l'intrieur de la cellule
						// l=left, c=center, r=right
	char v_align;		// Alignement  l'intrieur de la cellule
						// t=top, c=center, b=bottom
	int h_cells;		// Number of cells used horizontally (colspan)
	int v_cells;		// Number of cells used vertically (rowspan)
	char *s;			// Input buffer is needed or label
	char *id;			// Widget identifier
	wxWindow *c;
	int weightx;			// relative weight of the component for
	int weighty;			// dialog resizing. 0 for fixed elements
	int x;					// Position for T_LABEL
	int y;
	int type;
	int pref_width;		// Initial (preferred) size of the item
	int pref_height;
	int width;			// Current width (for some homemade widget such
						// as buttonfill)
	int height;
	class CHECKBOX_RADIO *radio;
	DCNAME *dcn;			// Optional DC settings to use (maybe NULL)
	int options;
	wxBitmap *bitmap;
	/*~PROTOBEG~ MFORM_C */
public:
	MFORM_C (const char *_id);
	void sets (const char *str);
	~MFORM_C (void);
	/*~PROTOEND~ MFORM_C */
};

class SETVAL_INFO{
public:
	wxMultiText *tarea;
	// Buffer to collect the new value of a text area
	char *tarea_buf;
	int tarea_size;
	int tarea_pos;
	class COMBO *combo;
	/*~PROTOBEG~ SETVAL_INFO */
public:
	SETVAL_INFO (void);
	void append (const char *s);
	void freebuf (void);
	void initbuf (void);
	/*~PROTOEND~ SETVAL_INFO */
};


struct INPUTGRID{
	char *id;		// Button ID
	int x,y;
	int cellwidth,cellheight;
	int nbcellh,nbcellv;
	bool track;		// Send report to the application when the user
					// move from one cell to the other
	int lastcellx,lastcelly;
};

class FORMBASE: public wxPanel{
public:
	MFORM_C **tbc;
	int nbc;
	int maxtbc;		// Current allocation size for tbc
	char *id;
	FORMBASE *f_parent;		// wxxt has already a parent field
	bool modified;
	int stretch_mode;
	int pref_width;
	int pref_height;
	bool logicaltop;	// This form is a logical mainform
						// used in dump() and getabspath()
	struct {
		int x,y;
		int w,h;
	} fixed;		// Requested position and dimensions or -1
	int max_height;			// Maximum height before enabling vertical scroll
	int max_width;			// Maximum width before enabling horizontal scroll
	int doc_width; 		// Document size, used when drawing stuff
	int doc_height;		// the layout engine can't compute the document size.
	int voffset;
	int hoffset;
	bool layout_once;	// dolayout() was called once for this form
	wxScrollBar *vscroll;
	wxScrollBar *hscroll;
	struct {				// Drawing context used to clear the form
		wxPen   *pen;
		wxBrush *brush;
	} background;
	/*~PROTOBEG~ FORMBASE */
public:
	FORMBASE (FORMBASE *_parent, const char *_id);
	FORMBASE (const char *_id);
	void SetSize (int new_width, int new_height);
	void SetSize (int x,
		 int y,
		 int new_width,
		 int new_height);
	MFORM_C *alloc_mf (const char *_id);
	MFORM_C *alloc_mf (void);
	void delall (void);
	void delchild (void);
	virtual void delform (MFORM *fl);
	virtual bool doalllayout (void);
	virtual void dolayout (int , int , bool);
protected:
	void drawbutfill (int nobut,
		 wxPen *pentop,
		 wxPen *penbot,
		 bool clear,
		 bool anim);
public:
	void drawitems (int start, int end, bool clear);
	void drawradio_but (MFORM_C *c);
	virtual void dump (void);
	wxFrame *getframe (void);
	FORMBASE *getlogicaltop (void);
	FORMBASE *getparent (void);
	MAINFORM *gettop (void);
	virtual void getweight (int &w, int &h);
private:
	void init (FORMBASE *_parent, const char *_id);
public:
	bool istop (void);
	int locate (const char *id,
		 MFORM *&form,
		 BOOK *&book);
	virtual bool may_stretch (void);
	void processradio (MFORM_C *csel);
	void report_button (const char *button_id,
		 bool dodump,
		 wxMouseEvent *event,
		 const char *extra);
	void resetlayout (void);
	virtual void resizeitems (int , int);
	void richtext_draw (const char *s, int x, int y);
private:
	void richtext_draweval (const char *s);
public:
	void richtext_extent (const char *s,
		 int &sw,
		 int &sh);
	virtual void set_modified (void);
	virtual int setcurfield (const char *,
		 wxWindow *[],
		 int &);
	void sethscroll (void);
	virtual void setval (const char *id,
		 const char *vals[],
		 SETVAL_INFO&info);
	void setvscroll (void);
	virtual void stretch (int , int);
	bool was_modified (void);
	~FORMBASE (void);
	/*~PROTOEND~ FORMBASE */
};

#define T_UNKNOWN	0
#define T_STRING	1
#define T_BUTTON	2
#define T_FORM		3
#define T_CHECKBOX	4
#define T_RADIO		5
#define T_CHOICE	6
#define T_HLINE		7
#define T_VLINE		8
#define T_SKIP		9
#define T_NEWLINE	10
#define T_COMBO		11
#define T_LIST		12
#define T_ICON		13
#define T_FILL		14
#define T_TEXT		15
#define T_LABEL		16
#define T_RICHTEXT	17
#define T_BUTTONFILL 18
#define T_CLIST		19
#define T_SHEET		20
#define T_SLIDER	21
#define T_GAUGE		22
#define T_BOOK		23
#define T_BUTTONXPM	24

class COMBO;
class BOOK;
class FORMBUTTON;
class CLIST;
class SHEET;

class CHECKBOX_RADIO{
public:
	int instance;
	bool state;
	/*~PROTOBEG~ CHECKBOX_RADIO */
public:
	CHECKBOX_RADIO (int _instance, bool _state);
	/*~PROTOEND~ CHECKBOX_RADIO */
};

class MFORM_TIMER;
class MFORM_DRAW;

#define MAX_COL		20

class MFORM: public FORMBASE{
public:
	char *dispstr;
	int marge_haut;
	int marge_bas;
	int marge_gauche;
	int marge_droite;
	int min_width;
	char *sidetitle;
	int mincols[MAX_COL];	// Required minimal width of each columns
	int colwidth[MAX_COL];	// Current width of each columns of the dialog
	MFORM_TIMER *timer;
	MFORM_DRAW *draw;		// Primitive to draw
	INPUTGRID *grids;
	int nbgrid;
	/*~PROTOBEG~ MFORM */
public:
	void Dispolast (char h_align,
		 int h_cells,
		 char v_align,
		 int v_cells);
	virtual void Fill (void);
protected:
	void FitStrategie_marge (int gauche,
		 int droit,
		 int haut,
		 int bas,
		 bool use_cur_size,
		 int maxw,
		 int maxh,
		 bool force);
public:
	void Inputgrid (const char *id,
		 int x,
		 int y,
		 int cellwidth,
		 int cellheight,
		 int nbcellh,
		 int nbcellv);
	MFORM (FORMBASE *_parent, const char *_id);
protected:
	MFORM (const char *_id);
public:
	virtual void New_book (FORMBASE *sub);
	virtual wxButton *New_button (const char *_id,
		 bool dodump,
		 const char *str);
	virtual wxButton *New_button (const char *_id,
		 wxBitmap *bitmap);
	virtual wxButton *New_button (const char *str);
	virtual void New_buttonfill (const char *_id,
		 const char *str,
		 int options,
		 DCNAME *dc);
	virtual wxCheckBox *New_checkbox (const char *_id,
		 bool state,
		 const char *str);
	virtual COMBO *New_choice (const char *_id,
		 const char *val);
	virtual void New_choice_item (const char *_id,
		 int no,
		 const char *val1,
		 const char *val2);
	virtual CLIST *New_clist (const char *_listid,
		 int nbcol,
		 const char *cols[]);
	virtual void New_clist_item (const char *_listid,
		 const char *_itemid,
		 const char *vals[]);
	virtual COMBO *New_combo (const char *_id,
		 int len,
		 const char *val);
	virtual void New_combo_item (const char *_id,
		 int no,
		 const char *val1,
		 const char *val2);
	void New_component (wxWindow *comp);
	virtual void New_form (FORMBASE *sub);
	virtual MFORM *New_form (const char *_id);
	virtual FORMBUTTON *New_formbutton (const char *_id);
	virtual FORMBUTTON *New_formbutton (void);
	virtual wxGauge *New_gauge (const char *_id,
		 int width,
		 int range,
		 int val);
	virtual void New_hline (const char *s);
	virtual void New_hline (void);
	virtual void New_icon_xpm (wxBitmap *bitmap);
	virtual void New_label (const char *str);
	virtual wxListBox *New_list (const char *_id,
		 int ,
		 const char *val);
	virtual void New_list_item (const char *_id,
		 const char *val);
	virtual wxText *New_password (const char *_id, int);
	void New_radio (const char *_id,
		 int instance,
		 bool state,
		 const char *str);
	virtual void New_richtext (const char *str);
	virtual SHEET *New_sheet (const char *_sheetid,
		 int nbcol,
		 const char *cols[]);
	virtual void New_sheet_item (const char *_sheetid,
		 int row,
		 int column,
		 const char *val);
	virtual wxSlider *New_slider (const char *_id,
		 int width,
		 int minval,
		 int maxval,
		 int val);
	virtual wxText *New_string (const char *_id,
		 int len,
		 const char *initval);
	virtual wxText *New_string (int len,
		 const char *initval);
	virtual wxMultiText *New_text (const char *_id,
		 int cols,
		 int rows);
	virtual void New_vline (void);
	virtual void Newline (void);
	void OnChar (wxKeyEvent&);
protected:
	Bool OnCharHook (wxKeyEvent&event);
public:
	void OnEvent (wxMouseEvent&event);
	virtual void OnPaint (void);
	virtual void Real_OnPaint (void);
	void Setweightlast (int wx, int wy);
	virtual void Skip (int n);
	void animatebut (int it, bool down);
	void blit (int from_x0,
		 int from_y0,
		 int from_x1,
		 int from_y1,
		 int to_x,
		 int to_y);
private:
	void distribute (int start,
		 int end,
		 int nbfill,
		 int diffx);
public:
	virtual void do_drawing (void);
	virtual void dolayout (int maxw, int maxh, bool force);
	void drawclip (int x0, int y0, int x1, int y1);
	MFORM_C *getitem (int n)const;
private:
	MFORM_C *getlastc (void);
public:
	void getweight (int &w, int &h);
	virtual void hmoveitems (int newpos);
private:
	void init (void);
public:
	int locate_butfill (wxMouseEvent&event);
	int locate_click (wxMouseEvent&event, int type);
	void record_draw (int command,
		 int arg0,
		 int arg1,
		 const char *s);
	void record_draw (int command,
		 int arg0,
		 int arg1,
		 int arg2,
		 int arg3);
	void record_draw (int command,
		 int arg0,
		 int arg1,
		 int arg2,
		 int arg3,
		 int arg4,
		 int arg5);
	void record_draw (int command,
		 int arg0,
		 int arg1,
		 int arg2,
		 int arg3,
		 int arg4,
		 int arg5,
		 int arg6,
		 int arg7);
	void record_draw (int command, int tb[], int nbarg);
	void reset (void);
	void resizeitems (int diffx, int diffy);
	int setcurfield (const char *id_suffix,
		 wxWindow *tbfocus[],
		 int &nbfocus);
	void setsidetitle (const char *s);
	void stretch (int new_width, int);
	void vmoveitems (int newpos);
	~MFORM (void);
	/*~PROTOEND~ MFORM */
};

class MAINFORM: public MFORM{
public:
	char *enteraction;
	class mywxFrame *fram;
	bool nopopup;	// Delay the popup until an explicit show
	/*~PROTOBEG~ MAINFORM */
public:
	MAINFORM (const char *_id);
	MAINFORM (const char *_id,
		 const char *_titre,
		 const char *type);
	MAINFORM (wxFrame *_parent,
		 const char *_id,
		 int x,
		 int y,
		 long style);
	void Popup (void);
	virtual void dispose (void);
	void escape (void);
	const char *getenteraction (void);
	wxFrame *getframe (void);
	void hide (void);
private:
	void init (const char *type);
	void init (wxFrame *_parent,
		 int x,
		 int y,
		 long style);
public:
	void mainlayout (void);
	void record_onpaint (MFORM *f);
	void reset (void);
	void setTitle (const char *title);
	void setcursor (wxCursor *cur);
	void setenteraction (const char *str);
	void show (void);
	void waitpopup (void);
	bool was_resized (void);
	~MAINFORM (void);
	/*~PROTOEND~ MAINFORM */
};

class FORMBUTTON: public MFORM{
	wxBrush *brush;
	wxPen *pen;
	bool docolor;
	/*~PROTOBEG~ FORMBUTTON */
public:
	FORMBUTTON (FORMBASE *_parent,
		 const char *_id,
		 int _back);
	FORMBUTTON (FORMBASE *_parent, const char *_id);
	wxButton *New_button (const char *_id,
		 bool dodump,
		 const char *str);
	void OnPaint (void);
	~FORMBUTTON (void);
	/*~PROTOEND~ FORMBUTTON */
};

class GROUP: public MFORM{
	const char *title;
	/*~PROTOBEG~ GROUP */
public:
	GROUP (MFORM *_parent,
		 const char *_id,
		 const char *_title);
	GROUP (MFORM *_parent, const char *_id);
	void OnPaint (void);
	void drawgroup (void);
	~GROUP (void);
	/*~PROTOEND~ GROUP */
};
class GROUP_FIT: public GROUP{
	/*~PROTOBEG~ GROUP_FIT */
public:
	GROUP_FIT (MFORM *_parent,
		 const char *_id,
		 const char *_title);
	GROUP_FIT (MFORM *_parent, const char *_id);
	void stretch (int new_width, int new_height);
	/*~PROTOEND~ GROUP_FIT */
};

class CLIST: public MFORM{
	MFORM *sub;
	int nbcol;
	char **cols;
	char *hdispo;	// Horizontal disposition, LaTeX like (lrllrrcll)
	char *hsign;	// One letter per heading button to specify
					// the little sign/icon to put at end.
					// Generally used to present the sort order.
	DCNAME **dcs;	// Drawing context to use for each column
	char *hid;		// Id used to send event when the user click
					// in the header area
	int heady;		// Height the heading section
	/*~PROTOBEG~ CLIST */
public:
	CLIST (FORMBASE *_parent,
		 const char *_id,
		 int _nbcol,
		 const char *_cols[]);
	void New_item (const char *id, const char *items[]);
	void OnEvent (wxMouseEvent&event);
	void OnPaint (void);
	void Set_item (const char *id, const char *items[]);
	void drawhead (void);
private:
	void freecols (void);
public:
	void redolayout (void);
	void resizeitems (int diffx, int diffy);
	int setcurfield (const char *id_suffix,
		 wxWindow *tbfocus[],
		 int &nbfocus);
	void sethead (int _nbcol, const char *_cols[]);
	void setval (const char *id,
		 const char *vals[],
		 SETVAL_INFO&info);
	void stretch (int new_width, int);
	~CLIST (void);
	/*~PROTOEND~ CLIST */
};

class SHEET: public MFORM{
	MFORM *sub;
	int nbcol;
	char **cols;
	/*~PROTOBEG~ SHEET */
public:
	void New_item (int row, int column, const char *val);
	void OnPaint (void);
	SHEET (FORMBASE *_parent,
		 const char *_id,
		 int _nbcol,
		 const char *_cols[]);
	void drawhead (void);
	void dump (void);
	~SHEET (void);
	/*~PROTOEND~ SHEET */
};


class PAGEPAD{
public:
	const char *title;
	int start;	// Horizontal coordinate of the pad
	int stop;	// End of the pad
	/*~PROTOBEG~ PAGEPAD */
public:
	PAGEPAD (const char *_title);
	~PAGEPAD (void);
	/*~PROTOEND~ PAGEPAD */
};

class BOOK: public FORMBASE{
	int nbpage;
	int nopage;
	int offsetx,offsety,b_offsety;
	class PAGEPAD *pads[30];
	bool scrollpad;		// Is there a button to scroll the pads horizontally
	int offpad;			// First visible pad to the left
	char *focusid;		// ID use to report page visibility change
	/*~PROTOBEG~ BOOK */
public:
	BOOK (FORMBASE *_parent, const char *_id);
	MFORM *New_form (const char *s);
	void New_page (FORMBASE *sub, const char *s);
	void OnEvent (wxMouseEvent&event);
	void OnPaint (void);
	void delform (MFORM *fl);
	bool doalllayout (void);
	void dolayout (int , int , bool);
private:
	void drawsel (wxDC *dc,
		 int no,
		 bool select,
		 int offsetx,
		 int maxx);
public:
	void fitstrategie (int left, int top, bool use_cur_dim);
private:
	int getpadwidth (int no);
public:
	void getweight (int &w, int &h);
private:
	bool locatepad (int x, wxMouseEvent *ev);
public:
	bool may_stretch (void);
	void resizeitems (int diffx, int diffy);
	void selpage (FORMBASE *f);
	void selpage (int no, wxMouseEvent *ev);
private:
	void sendfocus (wxMouseEvent *ev);
public:
	int setcurfield (const char *id_suffix,
		 wxWindow *tbfocus[],
		 int &nbfocus);
private:
	void setpadvisible (int no);
public:
	void stretch (int new_width, int new_height);
	~BOOK (void);
	/*~PROTOEND~ BOOK */
};

class COMBO_ITEM{
public:
	const char *val1;
	const char *val2;
	COMBO_ITEM *next;
	/*~PROTOBEG~ COMBO_ITEM */
public:
	COMBO_ITEM (const char *_val1, const char *_val2);
	void set (const char *_val1, const char *_val2);
	~COMBO_ITEM (void);
	/*~PROTOEND~ COMBO_ITEM */
};

class COMBO_LIST: public MAINFORM{
	COMBO *cm;
	/*~PROTOBEG~ COMBO_LIST */
public:
	COMBO_LIST (COMBO *_cm, int x, int y);
	void OnEvent (wxMouseEvent&event);
	/*~PROTOEND~ COMBO_LIST */
};

class COMBO: public MFORM {
public:
	wxText *text;
	wxButton *but;
	COMBO_LIST *mf;
	COMBO_ITEM *first;
	COMBO_ITEM *last;
	int nbitem;
	bool pickverbose;
	/*~PROTOBEG~ COMBO */
public:
	COMBO (MFORM *_parent,
		 const char *initval,
		 int cols,
		 bool listonly);
	void OnEvent (wxMouseEvent&event);
	void addItem (const char *val1, const char *val2);
private:
	void fixsize (const char *val1);
public:
	const char *getText (void);
	void select (int no);
	void setItem (int no,
		 const char *val1,
		 const char *val2);
	void setText (const char *val);
	void showlist (void);
	~COMBO (void);
	/*~PROTOEND~ COMBO */
};

class TREEMENU: public MFORM {
	struct TREEELM *tb;
	int maxtb;
	int nbtb;
	bool *statopen,*terminal;
	int *level;
	int curlevel;
	bool full;		// Operation mode. The application need full control
					// over the tree operation
	/*~PROTOBEG~ TREEMENU */
protected:
	Bool OnCharHook (wxKeyEvent&event);
public:
	void OnEvent (wxMouseEvent&event);
	void OnPaint (void);
	TREEMENU (FORMBASE *_parent, const char *_id);
	void addelm (wxBitmap *icon, const char *title);
	void addsub (bool isopen,
		 wxBitmap *icon,
		 const char *title);
private:
	void alloc (void);
	void dispose (int total_width, int total_height);
public:
	void dolayout (int , int , bool);
private:
	void draw (int no, bool highlit);
	void drawone (int no, int y, bool highlit);
public:
	void dump (void);
	void endsub (void);
private:
	int getskipy (void);
	int getviewlength (void);
public:
	void getweight (int &w, int &h);
private:
	void refresh (void);
public:
	void resizeitems (int diffx, int diffy);
	void setscroll (int newpos);
private:
	int setup (void);
public:
	void stretch (int new_width, int new_height);
	~TREEMENU (void);
	/*~PROTOEND~ TREEMENU */
};

class TEXTAREA: public wxMultiText{
	/*~PROTOBEG~ TEXTAREA */
protected:
	void OnChar (wxKeyEvent&event);
public:
	TEXTAREA (FORMBASE *_parent, int cols, int rows);
	/*~PROTOEND~ TEXTAREA */
};


extern wxPen *pen_white;
extern wxPen *pen_black;
extern wxPen *pen_light;
extern wxPen *pen_dark;
extern wxPen *pen_back;
extern wxBrush *brush_lightgray;
extern wxBrush *brush_white;
extern wxBrush *brush_black;
extern wxBrush *brush_back;
extern wxFont *font_normal;
extern wxFont *font_prop;
extern wxCursor *cursor_normal;
extern wxCursor *cursor_wait;
extern wxCursor *cursor_locked;

extern FILE *mform_fout;

#include "diawxxt.p"

#endif

