#include <string.h>
#include <stdlib.h>
#include <ctype.h>
#include <proto.h>
#include "dialog.h"

void guiid_required(){}	// To ease the link

class GUI_RESOURCE: public ARRAY_OBJ{
public:
	char id[10];
	/*~PROTOBEG~ GUI_RESOURCE */
public:
	GUI_RESOURCE (char idletter, int &alloc);
	/*~PROTOEND~ GUI_RESOURCE */
};


PUBLIC GUI_RESOURCE::GUI_RESOURCE(char idletter, int &alloc)
{
	sprintf (id,"%c%d",idletter,alloc++);
}

static int font_alloc,pen_alloc,brush_alloc,dc_alloc;

class FONT: public GUI_RESOURCE{
public:
	int pointsize;
	GFONT_ID fontid;
	GFONT_STYLE style;
	GFONT_WEIGHT weight;
	bool underlined;
	/*~PROTOBEG~ FONT */
public:
	FONT (int _pointsize,
		 GFONT_ID _fontid,
		 GFONT_STYLE _style,
		 GFONT_WEIGHT _weight,
		 bool _underlined);
	/*~PROTOEND~ FONT */
};

PUBLIC FONT::FONT(
	int _pointsize,
	GFONT_ID _fontid,
	GFONT_STYLE _style,
	GFONT_WEIGHT _weight,
	bool _underlined)
	: GUI_RESOURCE ('F',font_alloc)
{
	pointsize = _pointsize;
	fontid = _fontid;
	style = _style;
	weight = _weight;
	underlined = _underlined;
	diagui_sendcmd (P_Deffont,"%s %d %d %d %d %d\n",id,_pointsize,_fontid
		,_style,_weight,_underlined);
}

class FONTS: public ARRAY{
	/*~PROTOBEG~ FONTS */
public:
	FONT *getitem (int no)const;
	/*~PROTOEND~ FONTS */
};
PUBLIC FONT *FONTS::getitem (int no) const
{
	return (FONT*)ARRAY::getitem(no);
}

static FONTS fonts;
/*
	Return the ID describing a specific font
*/
EXPORT const char *guiid_setfont (
	int pointsize,
	GFONT_ID fontid,
	GFONT_STYLE style,
	GFONT_WEIGHT weight,
	bool underlined)
{
	const char *ret = NULL;
	// Locate an equivalent font, so we avoid transmitting a font spec
	// for nothing.
	for (int i=0; i<fonts.getnb(); i++){
		FONT *f = fonts.getitem(i);
		if (f->pointsize == pointsize
			&& f->fontid == fontid
			&& f->style == style
			&& f->weight == weight
			&& f->underlined == underlined){
			ret = f->id;
			break;
		}
	}
	if (ret == NULL){
		FONT *f = new FONT (pointsize,fontid,style,weight,underlined);
		fonts.add (f);
		ret = f->id;
	}
	return ret;
}

class PEN: public GUI_RESOURCE{
public:
	char color[20];
	int thick;
	GPEN_STYLE style;
	/*~PROTOBEG~ PEN */
public:
	PEN (const char *_color, int _thick, GPEN_STYLE _style);
	/*~PROTOEND~ PEN */
};

PUBLIC PEN::PEN(const char *_color, int _thick, GPEN_STYLE _style)
	: GUI_RESOURCE ('P',pen_alloc)
{
	strcpy_cut (color,_color,sizeof(color)-1);
	thick = _thick;
	style = _style;
	diagui_sendcmd (P_Defpen,"%s %s %d %d\n",id,_color,_thick,_style);
}

class PENS: public ARRAY{
	/*~PROTOBEG~ PENS */
public:
	PEN *getitem (int no)const;
	/*~PROTOEND~ PENS */
};
PUBLIC PEN *PENS::getitem (int no) const
{
	return (PEN*)ARRAY::getitem(no);
}
static PENS pens;
/*
	Return the ID describing a specific pen
*/
EXPORT const char *guiid_setpen (
	const char *color,
	int thick,
	GPEN_STYLE style)
{
	const char *ret = NULL;
	for (int i=0; i<pens.getnb(); i++){
		PEN *p = pens.getitem(i);
		if (strcmp(p->color,color)==0
			&& p->thick == thick
			&& p->style == style){
			ret = p->id;
			break;
		}
	}
	if (ret == NULL){
		PEN *p = new PEN (color,thick,style);
		pens.add (p);
		ret = p->id;
	}
	return ret;
}
/*
	Return the ID describing a specific pen with default settings
*/
EXPORT const char *guiid_setpen (const char *color)
{
	return guiid_setpen (color,1,GPEN_STYLE_SOLID);
}

class BRUSH: public GUI_RESOURCE{
public:
	char color[20];
	GBRUSH_STYLE style;
	/*~PROTOBEG~ BRUSH */
public:
	BRUSH (const char *_color, GBRUSH_STYLE _style);
	/*~PROTOEND~ BRUSH */
};

PUBLIC BRUSH::BRUSH(const char *_color, GBRUSH_STYLE _style)
	: GUI_RESOURCE ('B',brush_alloc)
{
	strcpy_cut (color,_color,sizeof(color)-1);
	style = _style;
	diagui_sendcmd (P_Defbrush,"%s %s %d\n",id,_color,_style);
}

class BRUSHES: public ARRAY{
	/*~PROTOBEG~ BRUSHES */
public:
	BRUSH *getitem (int no)const;
	/*~PROTOEND~ BRUSHES */
};
PUBLIC BRUSH *BRUSHES::getitem (int no) const
{
	return (BRUSH*)ARRAY::getitem(no);
}

static BRUSHES brushes;

/*
	Return the ID describing a specific brush
*/
EXPORT const char *guiid_setbrush (
	const char *color,
	GBRUSH_STYLE style)
{
	const char *ret = NULL;
	for (int i=0; i<brushes.getnb(); i++){
		BRUSH *p = brushes.getitem(i);
		if (strcmp(p->color,color)==0
			&& p->style == style){
			ret = p->id;
			break;
		}
	}
	if (ret == NULL){
		BRUSH *p = new BRUSH (color,style);
		brushes.add (p);
		ret = p->id;
	}
	return ret;
}

/*
	Return the ID describing a specific solid brush
*/
EXPORT const char *guiid_setbrush (const char *color)
{
	return guiid_setbrush (color,GBRUSH_STYLE_SOLID);
}


class GUI_DC: public GUI_RESOURCE{
public:
	char fontid[10];
	char penid[10];
	char brushid[10];
	/*~PROTOBEG~ GUI_DC */
public:
	GUI_DC (const char *_font,
		 const char *_pen,
		 const char *_brush);
	/*~PROTOEND~ GUI_DC */
};

PUBLIC GUI_DC::GUI_DC(
	const char *_font,
	const char *_pen,
	const char *_brush)
	: GUI_RESOURCE ('D',dc_alloc)
{
	strcpy_cut (fontid,_font,sizeof(fontid)-1);
	strcpy_cut (penid,_pen,sizeof(penid)-1);
	strcpy_cut (brushid,_brush,sizeof(brushid)-1);
	diagui_sendcmd (P_Defdc,"%s $font=%s pen=%s brush=%s\n"
		,id,_font,_pen,_brush);
}



class GUI_DCS: public ARRAY{
	/*~PROTOBEG~ GUI_DCS */
public:
	GUI_DC *getitem (int no)const;
	/*~PROTOEND~ GUI_DCS */
};

PUBLIC GUI_DC *GUI_DCS::getitem (int no) const
{
	return (GUI_DC*)ARRAY::getitem(no);
}

static GUI_DCS dcs;

/*
	Check if an ID is valid.
	Return NULL if not, the id if ok.
	res is scanned to locate the ID
*/
static const char *guiid_valid (
	const char *id,
	char idletter,
	ARRAY &res,
	const char *name)
{
	if (id != NULL){
		if (id[0] != idletter
			|| !isdigit(id[1])
			|| atoi(id+1) >= res.getnb()){
			fprintf (stderr,"Invalid %s ID: %s, using default\n",name,id);
			id = NULL;
		}
	}
	return id;
}

/*
	Allocate a new drawing context for the font,pen,brush combination.
	This function may be called repeatedly with the same argument
	and will return the same drawing context ID (It won't allocate a new
	one each time)
*/
EXPORT const char *guiid_setdc (
	const char *font,		// Font ID returned by guiid_setfont or NULL
	const char *pen,		// Pen ID returned by guiid_setpen or NULL
	const char *brush)		// Brush ID returned by guiid_setbrush or NULL
{
	font = guiid_valid (font,'F',fonts,"font");
	pen = guiid_valid (pen,'P',pens,"pen");
	brush = guiid_valid (brush,'B',brushes,"brush");
	if (font == NULL) font = guiid_setfont (12,GFONT_ID_DEFAULT,GFONT_STYLE_DEFAULT,GFONT_WEIGHT_DEFAULT,false);
	if (pen == NULL) pen = guiid_setpen ("black",0,GPEN_STYLE_SOLID);
	if (brush == NULL) brush = guiid_setbrush ("black",GBRUSH_STYLE_SOLID);
	const char *ret = NULL;
	for (int i=0; i<dcs.getnb(); i++){
		GUI_DC *p = dcs.getitem(i);
		if (strcmp(p->fontid,font)==0
			&& strcmp(p->penid,pen)==0
			&& strcmp(p->brushid,brush)==0){
			ret = p->id;
			break;
		}
	}
	if (ret == NULL){
		GUI_DC *p = new GUI_DC (font,pen,brush);
		dcs.add (p);
		ret = p->id;
	}
	return ret;
}

