/*
 *  checklist.c -- implements the checklist box
 *
 */


#include "dialog.h"

/*
	Display a dialog box with a list of options that can be turned on or off
*/
int dialog_checklist(
	const char *title,
	const char *prompt,
	HELP_FILE &helpfile,
	int ,		//list_height,
	int item_no,
	char **items,
	char *status)		/* Array of flags indicating if items[x] is */
						/* selected */
{
	int i;
	int maxlen = 1;
	for (i=0; i<item_no; i++){
		int len = strlen(items[i*2]);
		if (len > maxlen) maxlen = len;
	}
	DIALOG d;
	for (i=0; i<item_no; i++){
		char buf[100];
		sprintf (buf,"%-*s %s",maxlen,items[i*2],items[i*2+1]);
		d.newf_chk ("",status[i],buf);
	}
	return d.edit (title,prompt,helpfile);
}
	
#ifdef TEST
#include <string.h>

int main (int argc, char *argv[])
{
	static char *tb[]={
		"a",	"message",
		"allo",	"alal",
		"b",	"bbbbbb",
		"bozo",	"bzbzbzbz",
		"c",	"coco",
		"coco",	"cocococococ",
		"d",	"dddd",
		"dozo",	"dozozododo",
	};
	char status[8];
	memset (status,0,8);
	init_dialog();
	int ret  = dialog_checklist(
		"This is a test"
		,"Are you\nsure you want to exit\n"
		,"/tmp/dialog.bak"
		,5
		,8,tb,status);


	endwin();
	printf ("ret = %d\n",ret);
	for (int i=0; i<8; i++){
		printf ("%s %s %s\n",tb[i*2],tb[i*2+1],status[i] ? "On" : " ");
	}
	return 0;
}

#endif
