#include <gtk/gtk.h>

#include "interface.h"
#include "support.h"
#include "global.h"
#include "misc.h"
#include "main.h"
#include "import.h"

#define max_line_len	250

GtkTextView	*imp_text = NULL;
GtkTextBuffer	*imp_bff = NULL;
GtkTreeView	*imp_view = NULL;
GtkListStore	*imp_list = NULL;

enum {	S2P_DATA_FREQ,
	S2P_DATA_11r,
	S2P_DATA_11i,
	S2P_DATA_12r,
	S2P_DATA_12i,
	S2P_DATA_21r,
	S2P_DATA_21i,
	S2P_DATA_22r,
	S2P_DATA_22i,
	S2P_DATA_COLS
};


//
//	Touchstone files
//

void
Imports2pWindow_realize(GtkWidget *widget)
{
  GtkCellRenderer *renderer;
  GtkTreeViewColumn *col;
  int colnr;

  ImportWindow = widget;

  imp_text = GTK_TEXT_VIEW(lookup_widget(ImportWindow, "import_s2p_textview"));
  imp_bff = gtk_text_buffer_new(NULL);
  gtk_text_view_set_buffer(imp_text, imp_bff);

  imp_view = GTK_TREE_VIEW(lookup_widget(ImportWindow, "import_s2p_treeview"));
  imp_list = gtk_list_store_new(S2P_DATA_COLS,
		G_TYPE_STRING,		// Frequency
		G_TYPE_STRING,		// par 1
		G_TYPE_STRING,		// 
		G_TYPE_STRING,		// par 2
		G_TYPE_STRING,		// 
		G_TYPE_STRING,		// par 3
		G_TYPE_STRING,		// 
		G_TYPE_STRING,		// par 4
		G_TYPE_STRING);		// 
  gtk_tree_view_set_model(GTK_TREE_VIEW(imp_view), GTK_TREE_MODEL(imp_list));
  g_object_unref(G_OBJECT(imp_list));

  renderer = gtk_cell_renderer_text_new();
  col = gtk_tree_view_column_new_with_attributes(
		_("Freq"),
		renderer, "text", 0,
		NULL);
  gtk_tree_view_append_column(GTK_TREE_VIEW(imp_view), col);

  for (colnr = 1; colnr < 9; colnr++) {
    renderer = gtk_cell_renderer_text_new();
    gtk_object_set(GTK_OBJECT(renderer),
		"height", 14, "ypad", 0,
		"xalign", 1.0, NULL);
    col = gtk_tree_view_column_new_with_attributes(
		"",
		renderer, "text", colnr,
		NULL);
    gtk_tree_view_append_column(GTK_TREE_VIEW(imp_view), col);
  }		
}

//---------------------------------------------------------------------
//	Touchstone format
//---------------------------------------------------------------------

enum {	TS_FMT_DB,
	TS_FMT_MA,
	TS_FMT_RI
};

char *s2p_col_headers[][8] = {
  {"dB|$11|", "<$11", "dB|$21|", "<$21", 
   "dB|$12|", "<$12", "dB|$22|", "<$22"},
  {"|$11|", "<$11", "|$21|", "<$21", 
   "|$12|", "<$12", "|$22|", "<$22"},
  {"Re[$11]", "Im[$11]", "Re[$21]", "Im[$21]", 
   "Re[$12]", "Im[$12]", "Re[$22]", "Im[$22]"}
};

void
s2p_set_col_headers(int format, char param)
{
  GtkTreeViewColumn *col;
  int colnr, pos;
  char p[20];

  for (colnr = 1; colnr < 9; colnr++) {
    strcpy(p, s2p_col_headers[format][colnr-1]);
    pos = strchr(p, '$') - p;
    p[pos] = param;
    col = gtk_tree_view_get_column(imp_view, colnr);
    gtk_tree_view_column_set_title(col, p);
  }
}

//	#
//	freq	GHZ MHZ KHZ HZ
//	param	S Y Z G H
//	format	DB MA RI
//	R
//	n	(real ohms)

gboolean
s2p_options_decoded(char *line, char *format, char *param)
{
  GtkWidget *w;
  char *fmt, *par, *freq, *imp;
  int c;

  for (c = 0; c < strlen(line); c++)
    line[c] = toupper(line[c]);

  if (sscanf(line, "# %as %as %as S %as", &freq, &par, &fmt, &imp) != 4)
    return FALSE;

  if (strlen(par) != 1 ||			// Some syntax checking
      strchr("SZYHG", par[0]) == NULL ||
      strlen(fmt) != 2 ||
      strstr("DB MA RI", fmt) == NULL ||
      strstr("GHZ MHZ KHZ HZ", freq) == NULL)
    return FALSE;

  *param = par[0];
  *format = TS_FMT_DB;
  if (strcmp(fmt, "MA") == 0)
    *format = TS_FMT_MA;
  else
    if (strcmp(fmt, "RI") == 0)
      *format = TS_FMT_RI;

  w = lookup_widget(ImportWindow, "import_s2p_freq_entry");
  gtk_entry_set_text(GTK_ENTRY(w), freq);

  w = lookup_widget(ImportWindow, "import_s2p_param_entry");
  gtk_entry_set_text(GTK_ENTRY(w), par);

  w = lookup_widget(ImportWindow, "import_s2p_format_entry");
  gtk_entry_set_text(GTK_ENTRY(w), fmt);

  w = lookup_widget(ImportWindow, "import_s2p_imped_entry");
  gtk_entry_set_text(GTK_ENTRY(w), imp);

  g_free(fmt); g_free(par); g_free(freq); g_free(imp);
  return TRUE;
}

//	freq
//	TS_FMT_DB	4 pairs of   db(amp)	ang
//	TS_FMT_RI	4 pairs of   real	imag
//	TS_FMT_MA	4 pairs of   magnitude	ang

void
s2p_decode_data(char *line, char format)
{
  format = TS_FMT_DB;
}


void
import_s2p_append_comment(char *line)
{
  GtkTextIter iter;

  gtk_text_buffer_get_end_iter(imp_bff, &iter);
  gtk_text_buffer_insert(imp_bff, &iter, line, -1);
}

gboolean
s2p_file_loaded(char *filename)
{
  FILE *inf = fopen(filename, "r");
  char line[max_line_len], format, param, *p;

  if (!inf) {
    return FALSE;
  }
  while (!feof(inf)) {
    fgets(line, max_line_len, inf);
    p = strchr(line, '\n');
    if (p) *p = 0;
    p = strchr(line, '\r');
    if (p) *p = 0;
    if (strlen(line) == 0)
      continue;
    switch (line[0]) {
      case '!': 			// Comment line
	import_s2p_append_comment(line);
	break;
      case '#': 			// Config line
	import_s2p_append_comment("<option line>");
	s2p_options_decoded(line, &format, &param);
	s2p_set_col_headers(format, param);
	break;
      default: 				// Data lines
	s2p_decode_data(line, format);
    }
  }

  return TRUE;
}


void
import1_activate(void)
{
  char filename[200];

  if (run_filedialog("Import files", filename, TRUE,
		"Touchstone files", "*.s2p",
		"All filtes", "*",
		NULL)) {
    ImportWindow = create_Imports2pWindow();
    gtk_widget_show(ImportWindow);
    if (!s2p_file_loaded(filename)) {
      ok_dialog("Error", "Cannot import the parameter file");
      gtk_widget_destroy(ImportWindow);
    }
  }
}


void
import_s2p_cancel_btn_clicked(void)
{
  gtk_widget_destroy(ImportWindow);
}


void
import_s2p_exec_btn_clicked(void)
{
  gtk_widget_destroy(ImportWindow);
}


//
//	CSV file import
//

void
import_csv_activate(void)
{
  FILE *csvf = NULL;
  char line[max_line_len], *p, delim[5];
  load_definition load;

  if (number_loads() != 0) {
    switch (list_not_empty_dialog(
	_("The load list is not empty. Selecting Append will append\n"
	  "the new values."))) {
      case LSTDLG_APPEND: break;
      case LSTDLG_CLEAR : loadlist_clear(); break;
      case LSTDLG_CANCEL: return;
    }
  }

  if (strlen(pref.csv_sep) != 1) {
    ok_dialog(_("Error"),
              _("The field separator for CSV files is not defined yet."
	        "Please go\nto Edit|Preferences (Files tab) and define "
		"it first."));
    return;
  }

  if (!run_filedialog(_("Import CSV load file"), 
		pref.last_csv_file, TRUE,
		_("CSV files"), "*.csv",
                _("All files"), "*",                                            
                NULL)) 
    return;

  csvf = fopen(pref.last_csv_file, "r");
  if (!csvf) {
    ok_dialog(_("Error"),
	      _("Can't open this file (maybe read-protected?)"));
    return;
  }

  strcpy(delim, " \n");
  delim[0] = pref.csv_sep[0];
  while (!feof(csvf)) {
    fgets(line, max_line_len, csvf);
    p = line;
    p = strtok(p, delim);
    if (!p) break;		// No frequency token
    load.f = strtod(p, NULL);

    p = strtok(NULL, delim);
    if (!p) break;		// No real part available
    load.r = strtod(p, NULL);

    p = strtok(NULL, delim);
    if (!p) break;		// No imaginary part available
    load.x = strtod(p, NULL);

    load_append(&load);
    printf("%f %f %f\n", load.f, load.r, load.x);
  }
  fclose(csvf);
}
