/*
 *  aux.c - auxiliary routines, mainly gp screen management
 *
 *  Copyright (C) 1997-2005 John Coppens (john@jcoppens.com)
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  as published by the Free Software Foundation; either version 2 of
 *  the License, or (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include <gtk/gtk.h>
#include <math.h>
#include <libxml/tree.h>

enum   {SEP_IND_VAL, SEP_CAP_VAL,
	SEP_STUB_VAL, SEP_STUB_Z0, 
	SEP_LINE_VAL, SEP_LINE_Z0,
	SEP_XFORM_VAL};

int             ok_cancel_dialog(char *ttl, char *msg);
int             ok_dialog(char *ttl, char *msg);
void            show_about(void);
void            create_filedialog(char *title, char *fn, void (*selfunc)(),
			char *filter);
int		run_filedialog(char *title, char *fn, char *filter);

void		load_cable_table(GtkWidget *cmb);
void		show_cable_data(int which, int c);

void		initialize_MainWindow(void);
int		xml_file_open(xmlDocPtr *doc, const char *fname, char *title);

void		set_element_conn(int val);
void		set_element_type(int val);
GdkPixbuf 	*connection_glyph(int conn, int type);
GdkPixbuf       *type_glyph(int conn, int type);

void		scale_entry_pair_set(int eltyp, double val);
void		scale_entry_pair_set_entry(int which, double val);
double		scale_entry_pair_get(int which);
