// fft.h: interface for the Cfft class.
//
//  This is a slightly modified version of Takuya OOURA's
//     original radix 4 FFT package.
//Copyright(C) 1996-1998 Takuya OOURA
//    (email: ooura@mmm.t.u-tokyo.ac.jp).
//////////////////////////////////////////////////////////////////////

#ifndef FFT_H
#define FFT_H

#include <stddef.h>
#include "constants.h"

class Cfft  
{
public:
	bool CalcFFT(double * InPut, int start, int stop,double gain, int Ave, int* OutBuf);
	Cfft();
	virtual ~Cfft();
private:
	bool m_AverageOn;
	int m_AveSize;
	double *SinCosTbl;
	double *WindowTbl;
	double *pFFTAveBuf;
	double *InBuf;
	int *WorkArea;
	void makewt(int nw, int *ip, double *w);
	void makect(int nc, int *ip, double *c);
	void bitrv2(int n, int *ip, double *a);
	void cftfsub(int n, double *a, double *w);
	void rftfsub(int n, double *a, int nc, double *c);
    void cft1st(int n, double *a, double *w);
    void cftmdl(int n, int l, double *a, double *w);
};

#endif
