/***************************************************************************
                          csound.h  -  description
                             -------------------
    begin                : Wed Apr 5 2000
    copyright            : (C) 2000 by Volker Schroer
    email                : DL1KSV@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *   based on the work of Moe Wheatley, AE4JY                              *
 ***************************************************************************/

#ifndef CSOUND_H
#define CSOUND_H
#include <sys/soundcard.h>
#include <sys/ioctl.h>
#include <unistd.h>
#include <fcntl.h>
#include <sys/types.h>
#include <sys/stat.h>


#include <qobject.h>

#include "input.h"
#include "constants.h"
/**Class for operating on SoundCard
  *@author Volker Schroer
  */

class CSound :public Input
{
public: 
	CSound(int ptt);
	~CSound();
	bool open_Device_write(QString Device);
	bool close_Device();
	bool setParams(QString *errorstring);
  int getSamples(double *,int);				// Reading Samples from Soundcard
	int putSamples(double *,int);
	void PTT(bool);


private: // Private attributes
  /** Type of Operation Mono/Stereo */
  int mode;
  /** Audio Format **/
	int audioformat;
  /** Sampling rate */
   int speed;
	/** Fragmentsize for Soundcard IO */
	int fragsize;
	bool started;
//	int debug;
  audio_buf_info info;
};

#endif
