/***************************************************************************
                          parameter.cpp  -  description
                             -------------------
    begin                : Sat Apr 1 2000
    copyright            : (C) 2000 by Volker Schroer
    email                : DL1KSV@gmx.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *    based on the work of  Moe Wheatly, AE4JY                             *  
 ***************************************************************************/

#include "parameter.h"

Parameter::Parameter()
{
QFile ConfigFile("LinPsk.config");
QString s;
int index;

int r,g,b;
long int rgbvalue;
bool ok;

// Defaultfont

RxLabelFont=qApp->font();
RxLabelFont.setPointSize(10);
RxWindowTextFont=qApp->font();
TxLabelFont=qApp->font();
TxLabelFont.setPointSize(10);
TxWindowTextFont=qApp->font();
PanelLabelFont=qApp->font();
PanelLabelFont.setPointSize(12);


// Colours
colours[0].setRgb(255,0,0);
colours[1].setRgb(128,128,0);
colours[2].setRgb(0,0,255);
colours[3].setRgb(255,0,255);
// Defaultsettings

MinimumWindowWidth=640;
MinimumWindowHeight=540;
StatusBarHeight=20;

net=true;

status= TX_POSTAMBLE_STATE;

callsign="";
theircall="";
StationFile="";
Name="";

ButtonName="undefined";
ButtonFile="";

ptt=0;
timeoffset=-2;
clockerror=0;
serial=-1; // Serial none


DemoMode=true;
DemoModeFileType[0]="*";
DemoModeFileType[1]="*.wav";
DemoModeFileType[2]="*.out";
DemoTypeNumber=0;

InputSource=SOUND_MIXER_MIC;
InputVolume=50;
OutputVolume=50;
slashed0=false;
RxChannels=1;
actChannel=0; //0 <=actChannel < 4

CWIdString="";
NeedCWid= false;
// Try to read settings from Configfile
// ConfigFile has Format
// Variable=value
s=QDir::homeDirPath();
QDir d=QDir::home();
d.setCurrent(s.data());
if ( ConfigFile.open(IO_ReadOnly) )	// File exists and is readable
	{
		QTextStream line(&ConfigFile);
		
		QString VariableName;
		QString Value;
		while (!line.eof())
			{
				s= line.readLine();
				if (s.contains('=',false) == 1) // Exactly one =
					{
						index=s.find('=',0,false);
            if (index > 1)							// Variablename is given
							{

							VariableName = s.left(index);
							Value = s.right(s.length()-index-1);

							if (VariableName == "MinimumWindowWidth") 				// Minimum window width
								{
									if ( Value.toInt() > 0)
										MinimumWindowWidth = Value.toInt();	
								}

							if (VariableName == "MinimumWindowHeight") 				// Minimum window height
								{
									if ( Value.toInt() > 0)
										MinimumWindowHeight = Value.toInt();	
								}

							if (VariableName == "StatusBarHeight") 				// Statusbar height
								{
									if ( Value.toInt() > 0)
										StatusBarHeight = Value.toInt();	
								}

              if ( VariableName == "callsign")                // Callsign
										{
											callsign=Value;
											CWIdString="de " + callsign + " kn";
										}
							if ( VariableName == "DemoMode" )
									if ( Value == "true" )
										DemoMode = true;
									else
										{
										DemoMode = false;
                    inputFilename="/dev/audio";
										}
							if ( VariableName == "DemoTypeNumber")
								DemoTypeNumber = Value.toInt();			
							if (strcmp(VariableName.data(),"ptt") == 0)
								{
									ptt =Value.toInt();
									switch (ptt)
										{
											case 1:
												serial=open("/dev/ttyS0",O_EXCL);
												break;
											case 2:
												serial=open("/dev/ttyS1",O_EXCL);
												break;
											case 3:
												serial=open("/dev/ttyS2",O_EXCL);
												break;
											case 4:
												serial=open("/dev/ttyS3",O_EXCL);
												break;
											default:
												break;
				 						}
									int flags;
                  flags=TIOCM_RTS|TIOCM_DTR;
									if (serial >0)
					 					ioctl(serial,TIOCMBIC,&flags);
					 				else
					 					ptt=0; //Their seems to be a wrong Value in the ConfigFile	
									}
						    if ( VariableName == "SlashedZero")
									if ( Value == "true")
										slashed0 = true;
									else
										slashed0 = false;
                // Macros
								if ( VariableName == "Macro0")
									Macro0 = Value;
								if ( VariableName == "Macro1")
									Macro1 = Value;
								if ( VariableName == "Macro2")
									Macro2 = Value;
								if ( VariableName == "Macro3")
									Macro3 = Value;
								// Station File
								if ( VariableName == "StationFile")
									StationFile = Value;
								if ( VariableName == "ButtonName")
									ButtonName = Value;
								if ( VariableName == "ButtonFile")
									ButtonFile = Value;
								
				        if( VariableName == "TimeOffset")   // Timeoffset to UTC
									timeoffset =Value.toInt();
								
								if( VariableName == "InputSource")  // Input Source
									InputSource= Value.toInt();
									setInputSource(InputSource);
			
								if( VariableName == "InputVolume")  // InputVolume
									InputVolume= Value.toInt();
									setVolume(InputSource,InputVolume);

								if( VariableName == "OutputVolume") // OutputVolume
									OutputVolume= Value.toInt();
									setOutputVolume(OutputVolume);

								if( VariableName == "Net")	// Net
									if ( Value == "false" )
										net = false;
									else
										net = true;

							if(VariableName == "RxChannels")	// Number of RxChannels
									RxChannels=Value.toInt();		
									
							if(VariableName == 	"RxLabelFont")	//FontInfos
								RxLabelFont.setFamily(Value);
							if(VariableName == 	"RxLabelPointSize")	
								RxLabelFont.setPointSize(Value.toInt());
								
							if(VariableName == 	"RxWindowTextFont")	
								RxWindowTextFont.setFamily(Value);
							if(VariableName == 	"RxWindowTextPointSize")	
								RxWindowTextFont.setPointSize(Value.toInt());

							if(VariableName == 	"TxLabelFont")	
								TxLabelFont.setFamily(Value);
							if(VariableName == 	"TxLabelPointSize")	
								TxLabelFont.setPointSize(Value.toInt());

							if(VariableName == 	"TxWindowTextFont")	
								TxWindowTextFont.setFamily(Value);
							if(VariableName == 	"TxWindowTextPointSize")	
								TxWindowTextFont.setPointSize(Value.toInt());

							if(VariableName == 	"PanelLabelFont")	
								PanelLabelFont.setFamily(Value);
							if(VariableName == 	"PanelLabelPointSize")	
								PanelLabelFont.setPointSize(Value.toInt());
																															//Setting ColorComponets
							if(VariableName == "Color0" || VariableName == "Color1"
									|| VariableName == "Color2" || VariableName == "Color3")
									{
									rgbvalue=Value.toLong(&ok);
									if (ok)
										{
										r=rgbvalue/(256*256);
										g=(rgbvalue-r*256*256)/256;
										b=rgbvalue-(r*256+g)*256;
										if (VariableName == "Color0"	)
												colours[0].setRgb(r,g,b);																															
										if (VariableName == "Color1"	)
												colours[1].setRgb(r,g,b);																															
										if (VariableName == "Color2"	)
												colours[2].setRgb(r,g,b);																															
										if (VariableName == "Color3"	)
												colours[3].setRgb(r,g,b);																															
										}
									}								
						}
					}
				}
			
		ConfigFile.close();
	}
}
Parameter::~Parameter(){
}


void Parameter::usenet(bool type)
{
net=type;
}

void Parameter::setTheirCall(const QString &call)
{
theircall.operator=(call);
}

void Parameter::setName(const QString &name)
{
Name.operator=(name);
}
