/*==========================================================================
   LinPac: Packet Radio Terminal for Linux
   (c) Radek Burget OK2JBG (xburge01@stud.fee.vutbr.cz) 1998

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either version
   2 of the license, or (at your option) any later version.

   status.cc

   Connection status classes

   Last update 29.10.1999
  =========================================================================*/
#include <stdio.h>
#include <string.h>
#include "data.h"
#include "status.h"

StatusServer::StatusServer()
{
  strcpy(class_name, "Status");
  procform = check_proc_format();
}

StatusServer::~StatusServer()
{
}

void StatusServer::handle_event(const Event &ev)
{
  if (ev.type == EV_STAT_REQ)
  {
    if (get_axstat(sconfig(ev.chn, "call"), sconfig(ev.chn, "cphy"), procform))
    {
       emit(ev.chn, EV_STATUS, sizeof(chstat), &chstat);
    }
  }
}

int StatusServer::check_proc_format()
{
  //return: 0 = 2.2.x format
  //        1 = 2.0.x format
  int res = 0;
  char s[256];
  FILE *f;

  f = fopen(PROCFILE, "r");
  if (f != NULL)
  {
    fgets(s, 255, f);
    fgets(s, 255, f);
    if (strchr(s, '/') == NULL) res = 1; //older format contains '/'
    fclose(f);
  }
  return res;
}

