#include "external.h"

#include <string.h>
#include <syslog.h>
#include "global_vars.h"
#include "../lcp3.h"

#ifdef LPT_MONITOR

	#include <asm/io.h>

void update_lpt_status()
{
    static int previous = -1;
    struct line_t *line = (struct line_t*)lstlines.first;
    int current;
    if ( !server->lpt_status ) return;
    while ( line )
    {
	if ( !strncmp(line->linename, server->lpt_linename, LCP3_LINENAME_LEN) )
	    break;
	line = (struct line_t*)line->next;
    }
    if ( !line )
    {
	server->lpt_status = 0;
	syslog(LOG_WARNING, "No line called '%s' to monitor on lpt!", server->lpt_linename);
	return;
    }
    switch ( server->lpt_status )
    {
	case 0: return;
	case 1: // lines
	    if ( (line->con_stat == CST_UP_USER)
		|| (line->con_stat == CST_UP_SERVER) )
		current = 1;
	    else
		current = 0;
	    break;
	case 2: // clients in 2-digit HEX mode
	    current = (line->online % 16) | ((line->online / 16) << 4);
	    break;
	default: server->lpt_status = 0; return;
    }
    if ( current != previous )
    {
	previous = current;
	outb(current, server->lpt_addr);
    }
}

#endif // LPT_MONITOR

#ifdef LCD_MONITOR
/*
 Martin Berentsen < berentsen at sent5 dot uni-duisburg dot de >
 version : 3
 date:     01.11.2001
*/
void update_lcd_status()
{
  static int previous = -1;
  struct line_t *line = (struct line_t*)lstlines.first;
  int cnt = 0;
  long int current = 0;
  time_t ut = 0;	      
  char tbuf[9];
  FILE *fd;
  int cli_on = 0;
  int lines_on = 0;
  
  struct client_t *cur = (struct client_t*)cltlist.first;
  struct line_t *someline = (struct line_t*)lstlines.first;

  while( cur ) { cnt++; cur = (struct client_t*)cur->next; }

  while( someline ) { 
    cli_on+= someline->online;
	// instead of the following line one should do a
	// 'switch(someline->con_stat)' possible values are
	// listed in lcp3.h as CST_*. It might happen that
	// some function doesn't update the online member.
	// So tracking con_stat is more accurate & secure.
	// (until now no mistakes regarding the value in
	// someline->online are known, so this should work anyway.)
    if(someline->online) lines_on++;
    someline = (struct line_t*)someline->next; }

  if (cli_on > 0) 
    {
      ut = time(NULL) - line->con_up_time; /* time in secs here */
      sprintf(tbuf,"%.4ld:%.2ld",ut/60,ut%60);
    }
  else sprintf(tbuf,"  off   ");
  
  current = cnt+cli_on+line->online+ut;
  if ( current != previous ) 
    {
      previous = current; 
      if((fd = fopen("/dev/lcd","w")) != NULL)
        {
          fprintf(fd,"\33cC:%.2d O:%.2d L:%.2d\nT:%s",cnt,cli_on,
                  lines_on,tbuf);
          fclose(fd);
        }
    }
}
#endif
