/*!!***************************************************************************
 *!! FILE NAME
 *!!	$Source: /var/cvs/pub/repository/LinCVS/src/loglist.cpp,v $
 *!!
 *!! AUTHOR
 *!!	$Author: joseh $
 *!!
 *!! DATE, REVISION AND STATE
 *!!	$Date: 2001/11/04 13:01:54 $
 *!!	$Revision: 1.9 $
 *!!	$State: Exp $
 *!!
 *!! DESCRIPTION
 *!!
 *!!	Copyright (C) 2001 Jose Hernandez.
 *!!
 *!!    Originally based on cervisia's code by Bernd Gehrmann and others.
 *!!    Copyright (C) 1999 Bernd Gehrmann.  bernd@physik.hu-berlin.de
 *!!
 *!!	This program is free software; you can redistribute it and/or modify
 *!!	it under the terms of the GNU General Public License as published by
 *!!	the Free Software Foundation; either version 2, or (at your option)
 *!!	any later version.
 *!!
 *!!	This program is distributed in the hope that it will be useful,
 *!!	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *!!	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *!!	GNU General Public License for more details.
 *!!
 *!!**************************************************************************/


#include "config.h"
#include "ac_system_defs.h"

#include <qstrlist.h>
#include <qapplication.h>
#include "loglist.h"


QColor LogListView::SelColor[2];


class QColorGroup;
class QPainter;

class LogListViewItem : public QListViewItem
{
public:
	unsigned char selection;
    
	LogListViewItem (QListView *list, QString rev, QString author,
			 QString date, QString comment );

	void paintCell (QPainter * p, const QColorGroup & cg, 
			int column, int width, int alignment );

	virtual QString key (int column, bool) const;

private:
	static QString truncateLine(QString s);
};


static QStrList splitLine(QString line, char delim = ' ')
{
    int pos;
    QStrList list(true);

    line = line.simplifyWhiteSpace();
    while ((pos = line.find(delim)) != -1)
	{
	    list.append(line.left(pos));
	    line = line.mid(pos+1, line.length()-pos-1);
	}
    if (!line.isEmpty())
	list.append(line);
    return list;
}


LogListViewItem::LogListViewItem( QListView *list, QString rev, QString author,
				  QString date, QString comment )
	: QListViewItem(list, rev, author, date+" ", truncateLine(comment)), selection(0)
{
}


QString LogListViewItem::truncateLine(QString s)
{
    int pos;

    if ( (pos = s.find('\n')) != -1 )
        s = s.left(pos) + "...";
    return s;
}

void LogListViewItem::paintCell (QPainter * p, const QColorGroup &cg, 
				 int column, int width, int alignment )
{
	QColorGroup _cg(cg);

        if (isSelected())
	{
		int h, s, v;
		QColor C;
		C = ((LogListView *)listView())->getSelectionColor (selection);
		_cg.setColor (QColorGroup::Highlight, C);
		C.hsv( &h, &s, &v );
		_cg.setColor (QColorGroup::HighlightedText, 
			      (v > 128) ? QColor("black") : QColor("white"));
	}

	QListViewItem::paintCell( p, _cg, column, width, alignment );
}


QString LogListViewItem::key(int column, bool) const
{
    static QString tmp, res;

    if (column != 0)
	return text(column);

    QStrList strlist = splitLine(text(column), '.');

    res = "";
    QStrListIterator it(strlist);
    for (; it.current(); ++it)
	{
	    tmp.sprintf("%5d", QString(it.current()).toInt());
	    res += tmp;
	    res += ".";
	}
    res.truncate(res.length()-1);
    return res;
}


LogListView::LogListView(QWidget *parent, const char *name)
    : QListView(parent, name)
{
	setAllColumnsShowFocus(true);
	setMultiSelection(true);
	setFrameShape (StyledPanel);
	addColumn(tr("Revision"));
	addColumn(tr("Author"));
	addColumn(tr("Date"));
	addColumn(tr("Log Message"));

	// Set default selection color to black
	for (int i=0; i<2; i++)
		setSelectionColor (i, QColor("black"));

	setSorting (0, false);
}


void LogListView::addRevision(QString rev, QString author,
			      QString comment, QString date)
{
    (void) new LogListViewItem(this, rev, author, date, comment);
}


void LogListView::setSelectedPair (QString selectionA, QString selectionB)
{
	bool selected, refresh = false;
	unsigned char selection;

	for (QListViewItemIterator it(this); it.current(); ++it)
	{
		if (selectionA == it.current()->text(0))
		{
			selected = true;
			selection = 0;
		}
		else if (selectionB == it.current()->text(0))
		{
			selected = true;
			selection = 1;
		}
		else
		{
			selected = false;
			selection = 0;
		}

		if ((selected != it.current()->isSelected()) ||
		    (selection != static_cast<LogListViewItem *>(it.current())->selection))
		{
			setSelected (it.current(), selected);
			static_cast<LogListViewItem *>(it.current())->selection = selection;

			// mark for refresh if there are any changes
			refresh = true;
		}
	}

	repaint (refresh);
}


void LogListView::contentsMousePressEvent(QMouseEvent *e)
{
    if ( e->button() == LeftButton )
	{
	    LogListViewItem *selItem
                = static_cast<LogListViewItem*>( itemAt(e->pos()) );
	    if (selItem)
                emit revisionClicked(selItem->text(0), false);
	}
    else if ( (e->button() == MidButton) ||
	      (e->button() == RightButton) )
	{
	    LogListViewItem *selItem
                = static_cast<LogListViewItem*>( itemAt(e->pos()) );
	    if (selItem)
                emit revisionClicked(selItem->text(0), true);
	}
}


void LogListView::setSelectionColor (const unsigned char selection, const QColor &color)
{
	SelColor [selection] = color;
}

	
QColor LogListView::getSelectionColor (const unsigned char selection) const
{
	return SelColor [selection];
}
