/****************************************************************************
**
** $Id: colortab.h,v 1.3 2001/06/28 23:03:33 joseh Exp $
**
** Copyright (C) 2001 The LinCVS development team.
**    Tilo Riemer <riemer@lincvs.org>
**    Falk Brettschneider <gigafalk@yahoo.com>
**    Wim Delvaux <wim.delvaux@chello.be>
**    Jose Hernandez <joseh@tesco.net>
**    Helmut Koll <HelmutKoll@web.de>
**    Sven Trogisch <trogisch@iapp.de>
**
**
**----------------------------------------------------------------------------
**
**----------------------------------------------------------------------------
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as
** published by the Free Software Foundation; either version 2 of the
** License, or (at your option) any later version.
**
*****************************************************************************/


#ifndef COLORTAB_H_20010626
#define COLORTAB_H_20010626


#include "config.h"
#include "ac_system_defs.h"


#include <qtabbar.h>
#include <qtabwidget.h>

class ColorTab : public QTab {
public :
        ColorTab( const QString & S );

        void setColor( const QColor & C );
        QColor & getColor() { return  _color; }
        char hasColor() { return  _hasColor; }
        void resetColor() { _hasColor = 0; }
private :

        char _hasColor;
        QColor _color;
};

class ColorTabBar : public QTabBar {

public :

        ColorTabBar( QWidget * Parent );

        virtual void paintLabel( QPainter *, const QRect &,QTab *, bool ) const;

        ColorTab * colorTab( int i ) 
                { return (ColorTab *)QTabBar::tab( i ); }

};

class ColorTabWidget : public QTabWidget {

public :
        ColorTabWidget( QWidget * Parent );
        ColorTabBar * getColorTabBar( void ) 
                { return (ColorTabBar *)tabBar(); }
};


#endif 	//COLORTAB_H_20010626
