/****************************************************************************
**
** $Id: cfg.h,v 1.4 2001/06/28 23:03:33 joseh Exp $
**
** Copyright (C) 2001 The LinCVS development team.
**    Tilo Riemer <riemer@lincvs.org>
**    Falk Brettschneider <gigafalk@yahoo.com>
**    Wim Delvaux <wim.delvaux@chello.be>
**    Jose Hernandez <joseh@tesco.net>
**    Helmut Koll <HelmutKoll@web.de>
**    Sven Trogisch <trogisch@iapp.de>
**
**
**----------------------------------------------------------------------------
**
**----------------------------------------------------------------------------
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as
** published by the Free Software Foundation; either version 2 of the
** License, or (at your option) any later version.
**
*****************************************************************************/


#ifndef CFG_H_20010626		// prevent multiple includes
#define CFG_H_20010626

/*---------------------------------------------------------------------------*
 *  Include Files                                                            *
 *---------------------------------------------------------------------------*/

#include "config.h"
#include "ac_system_defs.h"


#include "globals.h"
#include "appconf.h"
#include "profile.h"
#include <qlist.h>
#include <qwidget.h>

/*---------------------------------------------------------------------------*
 *  Definitions, Macros                                                      *
 *---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*
 *  typedefs                                                                 *
 *---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*
 *  global Variables                                                         *
 *---------------------------------------------------------------------------*/

/*---------------------------------------------------------------------------*
 *  Prototypes / classes                                                     *
 *---------------------------------------------------------------------------*/



class Config: public QWidget, AppConfig
{
  Q_OBJECT

public :

  Config(const char* cfgFileName,
         QStringList *userList,
         QStringList *serverList,
         QStringList *repositoryList,
         QStringList *profileList );
  ~Config();


  int  getCfgFile(void);
  int  putCfgFile(void);
  void rmItem(char* path, const char* item, QStringList& list);
  void reArrangeSection(char* path, QStringList& list);
  void addItem(char* section, const char* item);
  void insertEntry(QStringList *list, const QString item);
  

  bool fileFound;
  QString actProfile;
  
  QList<lincvsProfile> list;     // list of pointers to lincvsProfile
  

private slots :

   QString itemDesig(QString section);
 
   bool checkForOldFileVersion();
   void readList(const char *szPath, QStringList & strList );
   void getDfltEntry();
   

   
   
private:
  
  BaseConfig::Enumerator *pEnum;
  size_t nEntries;
  QString fname;
  QStringList     tmpList;
  QStringList     *p_userList;
  QStringList     *p_serverList;
  QStringList     *p_repositoryList;
  QStringList     *p_profileList;
  
  
};


#endif	// CFG_H_20010626

/*--------- END OF FILE -----------------------------------------------------*/
