/****************************************************************************
**
** $Id: AnnotateDialogImpl.cpp,v 1.8 2001/07/18 23:10:26 joseh Exp $
**
** Copyright (C) 2001 The LinCVS development team.
**    Tilo Riemer <riemer@lincvs.org>
**    Falk Brettschneider <gigafalk@yahoo.com>
**    Wim Delvaux <wim.delvaux@chello.be>
**    Jose Hernandez <joseh@tesco.net>
**    Helmut Koll <HelmutKoll@web.de>
**    Sven Trogisch <trogisch@iapp.de>
**
**
**----------------------------------------------------------------------------
**
**----------------------------------------------------------------------------
**
** This program is free software; you can redistribute it and/or modify
** it under the terms of the GNU General Public License as
** published by the Free Software Foundation; either version 2 of the
** License, or (at your option) any later version.
**
*****************************************************************************/


#include "config.h"
#include "ac_system_defs.h"


#include <qfileinfo.h>
#include <qlistview.h>
#include "CmdThread.h"
#include "CvsFileViewer.h"
#include "AnnotateDialogImpl.h"


/*!!***************************************************************************
 *!! FUNCTION NAME
 *!!    AnnotateDialogImpl
 *!!
 *!! PARAMETERS
 *!!
 *!!
 *!! RETURN VALUE
 *!!    none
 *!!
 *!! GLOBALS ACCESSED
 *!!    none
 *!!
 *!! DESCRIPTION
 *!!    Constructs a AnnotateDialogImpl which is a child of 'parent', with the 
 *!!    name 'name' and widget flags set to 'f' 
 *!!    The dialog will by default be modeless, unless you set 'modal' to
 *!!    TRUE to construct a modal dialog.
 *!!**************************************************************************/

AnnotateDialogImpl::AnnotateDialogImpl (QWidget* parent, const char* name,
					bool modal, WFlags fl )
	: AnnotateDialog( parent, name, modal, fl )
{
}


/*!!***************************************************************************
 *!! FUNCTION NAME
 *!!    ~AnnotateDialogImpl
 *!!
 *!! PARAMETERS
 *!!    none
 *!!
 *!! RETURN VALUE
 *!!    none
 *!!
 *!! GLOBALS ACCESSED
 *!!    none
 *!!
 *!! DESCRIPTION
 *!!    Destroys the object and frees any allocated resources
 *!!
 *!!**************************************************************************/

AnnotateDialogImpl::~AnnotateDialogImpl()
{
}


/*!!***************************************************************************
 *!! FUNCTION NAME
 *!!    parseCvsAnnotate
 *!!
 *!! PARAMETERS
 *!!
 *!!
 *!! RETURN VALUE
 *!!
 *!!
 *!! GLOBALS ACCESSED
 *!!
 *!!
 *!! DESCRIPTION
 *!!
 *!!
 *!!**************************************************************************/

bool AnnotateDialogImpl::parseCvsAnnotate (QString BaseDir, QString name, QString rev)
{
	QString caption;
	QString command;

	caption = tr ("CVS Annotate - ") + name;
	command = "cd " + BaseDir + " && cvs annotate ";

	if (!rev.isEmpty())
	{
		command += "-r " + rev + " ";
		caption += tr (" (") + rev + tr (")");
	}

	setCaption (caption);
	command += name + " 2>/dev/null";

	CmdThread * Thread = new CmdThread (command);
	Thread->start();
	Thread->wait();

	long len = Thread->m_outputQueue.count();

	for (unsigned long i = 0; i < len; i++)
		FileViewer->append (Thread->m_outputQueue[i].mid(35),
				    Thread->m_outputQueue[i].left(13).stripWhiteSpace(),
				    Thread->m_outputQueue[i].mid(14, 8).stripWhiteSpace(),
				    Thread->m_outputQueue[i].mid(23, 9));

	delete Thread;
	return (true);
}


/*!!***************************************************************************
 *!! FUNCTION NAME
 *!!    parseCvsRevision
 *!!
 *!! PARAMETERS
 *!!
 *!!
 *!! RETURN VALUE
 *!!
 *!!
 *!! GLOBALS ACCESSED
 *!!
 *!!
 *!! DESCRIPTION
 *!!
 *!!
 *!!**************************************************************************/

bool AnnotateDialogImpl::parseCvsRevision (QString BaseDir, QString name, QString rev)
{
	QString caption;
	QString command;

	caption = tr ("CVS Revision - ") + name;
	command = "cd " + BaseDir + " && cvs update -p ";

	if (!rev.isEmpty())
	{
		command += "-r " + rev + " ";
		caption += tr (" (") + rev + tr (")");
	}

	setCaption (caption);
	command += name + " 2>/dev/null";

	CmdThread * Thread = new CmdThread (command);
	Thread->start();
	Thread->wait();

	long len = Thread->m_outputQueue.count();

	for (unsigned long i = 0; i < len; i++)
		FileViewer->append (Thread->m_outputQueue[i]);

	delete Thread;
	return (true);
}
