/***************************************************************************
                          config.c  -  description
                             -------------------
    begin                : Tue Feb 13 2001
    copyright            : (C) 2001 by Michael Speck
    email                : kulkanie@gmx.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <SDL.h>
#include <stdlib.h>
#include <stdio.h>
#include <dirent.h>
#include <sys/types.h>
#include <sys/stat.h>
#include "sdl.h"
#include "config.h"

Config config;

/* check if config directory exists; if not create it and set config_dir */
void check_config_dir_name()
{
    sprintf( config.dir_name, "%s/.lgeneral", getenv( "HOME" ) );
    if ( opendir( config.dir_name ) == 0 ) {

        fprintf( stderr, "couldn't find/open config directory '%s'\n", config.dir_name );
        fprintf( stderr, "attempting to create it... " );
        mkdir( config.dir_name, S_IRWXU );
        if ( opendir( config.dir_name ) == 0 )
            fprintf( stderr, "failed\n" );
        else
            fprintf( stderr, "ok\n" );

    }

}

/* set config to default */
void reset_config()
{
    /* gfx options */
    config.tran = 1;
    config.grid = 0;
    config.show_bar = 1;
    config.video_mode = def_video_mode();

    /* game options */
    config.supply = 1;
    config.weather = 1;
    config.show_cpu_turn = 1;

    /* audio stuff */
    config.sound_on = 1;
    config.sound_volume = 96;
    config.music_on = 1;
    config.music_volume = 96;
}

/* load config */
void load_config( )
{
    FILE *file = 0;
    char file_name[512];
    struct stat dir_stat;
    char dir_name[512];

    sprintf( file_name, "%s/%s", config.dir_name, "lg.conf" );
    if ( ( file = fopen( file_name, "r" ) ) == 0 ) {
        /* not found? use defaults! */
        fprintf( stderr, "config file '%s' not found... using defaults\n", file_name );
        reset_config();
    }
    else {
        /* check if file size fits struct size; if not use defaults */
        stat( file_name, &dir_stat );
        if ( dir_stat.st_size != sizeof( Config ) ) {
            fprintf( stderr, "config file '%s' corrupted... using defaults\n", file_name );
            reset_config();
        }
        else {
            /* must backup dir_name! */
            strcpy( dir_name, config.dir_name );
            /* read it from file */
            fread( &config, sizeof( Config ), 1, file );
            strcpy( config.dir_name, dir_name );
        }
        fclose( file );
    }
}

/* save config */
void save_config( )
{
    FILE *file = 0;
    char file_name[512];

    sprintf( file_name, "%s/%s", config.dir_name, "lg.conf" );
    if ( ( file = fopen( file_name, "w" ) ) == 0 )
        fprintf( stderr, "cannot access config file '%s' to save settings\n", file_name );
    else {
        fwrite( &config, sizeof( Config ), 1, file );
        fclose( file );
    }
}

