/***************************************************************************
                          player.c  -  description
                             -------------------
    begin                : Fri Jan 19 2001
    copyright            : (C) 2001 by Michael Speck
    email                : kulkanie@gmx.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#include <SDL.h>
#include <stdlib.h>
#include <string.h>

#ifdef WITH_SOUND
#include <SDL_mixer.h>
#include "audio.h"
#endif

#include "sdl.h"
#include "dynlist.h"
#include "nation.h"
#include "unit.h"
#include "player.h"
#include "tools.h"

/* create player */
Player *create_player( char *entry_name, char *name, int cont )
{
    Player *player;

    player = calloc( 1, sizeof( Player ) );
    player->entry_name = strdup( entry_name );
    player->name = strdup( name );
    player->cont = cont;

    /* available reinforcements: taken from scen::reinf */
    dl_init( &player->avail_reinf, AUTO_DELETE, delete_unit );

    /* diplomacy struct is initiated in scenario.c after calling create_player() */

    return player;
}

/* deletes player struct */
void delete_player( Player *player )
{

    if ( player == 0 ) return;

    /* delete within */
    if ( player->entry_name ) FREE( player->entry_name );
    if ( player->name ) FREE( player->name );
    if ( player->dipl ) FREE( player->dipl );

    dl_clear( &player->avail_reinf );

    /* delete struct */
    FREE( player ); player = 0;

}

