/***************************************************************************
                          ai_action.h  -  description
                             -------------------
    begin                : Tue Jul 24 2001
    copyright            : (C) 2001 by Michael Speck
    email                : kulkanie@gmx.net
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef AI_ACTION_H
#define AI_ACTION_H

/*
====================================================================
This header contains the AI_Action structure and functions to
create such an action.
====================================================================
*/

/*
====================================================================
This is the AI_Action struct.
====================================================================
*/
enum {
    AI_NO_ACTION = 0,
    AI_MOVE,
    AI_ATTACK,
    AI_MOVE_ATTACK, // first move; then attack! //
    AI_SUPPLY,
    AI_END_TURN
};
typedef struct {
    int type; // action as seen above //
    Unit *unit; // unit performing //
    Unit *target; // target for attack //
    int x, y; // destination for moving //
} AI_Action;

/*
====================================================================
In case a double-action (e.g. MOVE_ATTACK) is returned the first
action is processed and the second action is stored and then
processed before ai_get_action() is called again.
====================================================================
*/
void ai_store_action( AI_Action action );
int ai_get_stored_action( AI_Action *action );

/*
====================================================================
These functions 'create' an AI action from the passed arguments. For
functions that require a unit the cur_unit pointer defined in
ai.c is used.
====================================================================
*/
AI_Action ai_no_action();
AI_Action ai_end_turn_action();
AI_Action ai_move_action( int x, int y );
AI_Action ai_attack_action( Unit *target );
AI_Action ai_move_attack_action(  int x, int y, Unit *target );
AI_Action ai_supply_action( );

#endif
