//
//
// Copyright 2002 Rob Tougher <robt@robtougher.com>
//
// This file is part of xmlrpc.
//
// xmlrpc is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// xmlrpc is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with xmlrpc; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
//
//


// Definition of the server_socket class

#ifndef _sockets_server_socket_class
#define _sockets_server_socket_class

#include "socket.hpp"

namespace sockets
{

  //
  // server_socket: a user-friendly wrapper for
  // authors of socket servers. Simply constructing
  // the object creates a server socket, binds it to
  // a port, and listens for incoming requests on that
  // port
  //
  class server_socket : private socket
  {
  public:

    server_socket ( int port );
    server_socket (){};
    virtual ~server_socket();

    //
    // overloaded operators for reading and writing data
    //
    const server_socket& operator << ( const std::string& ) const;
    const server_socket& operator >> ( std::string& ) const;

    void accept ( server_socket& ) const;

  };

};


#endif
