Browser subclass: #ScopedBrowser
	instanceVariableNames: 'includedCategories excludedClasses '
	classVariableNames: ''
	poolDictionaries: ''
	category: 'MakingSmalltalk-Article3'!

!ScopedBrowser methodsFor: 'class list' stamp: 'JRS 11/14/2000 09:49'!
classList
	"Override this method to:
		* look up the category index from the system category list, as the browser category index is expected to be different than the system category lists index.
		* reject any excluded classes
	Answer an array of the class names of the selected category. Answer an empty array if no selection exists."

	systemCategoryListIndex = 0
		ifTrue: [^Array new]
		ifFalse: [^(systemOrganizer listAtCategoryNumber: (systemOrganizer categories 
					indexOf: self selectedSystemCategoryName asSymbol)) 
					reject: [:e | self excludedClasses includes: e name]].! !


!ScopedBrowser methodsFor: 'system category list' stamp: 'JRS 11/19/2000 09:16'!
systemCategoryList
	"Override this method to answer the scoped class categories modeled by the receiver."

	^self includedCategories select: [:e | systemOrganizer categories includes: e]! !


!ScopedBrowser methodsFor: 'accessing' stamp: 'JRS 11/14/2000 09:05'!
excludedClasses 

	^excludedClasses ! !

!ScopedBrowser methodsFor: 'accessing' stamp: 'JRS 11/14/2000 09:06'!
excludedClasses: aCollectionOfClasses 

	^excludedClasses := aCollectionOfClasses.! !

!ScopedBrowser methodsFor: 'accessing' stamp: 'JRS 11/14/2000 09:05'!
includedCategories

	^includedCategories! !

!ScopedBrowser methodsFor: 'accessing' stamp: 'JRS 11/14/2000 09:06'!
includedCategories: aCollectionOfCategories

	^includedCategories := aCollectionOfCategories! !

"-- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- -- "!

ScopedBrowser class
	instanceVariableNames: ''!

!ScopedBrowser class methodsFor: 'instance creation' stamp: 'JRS 11/19/2000 09:09'!
openBrowserWithCategories: aCollectionOfCategorySymbols 

	self openBrowserWithCategories: aCollectionOfCategorySymbols 
		withoutClasses: OrderedCollection new
		withLabelSuffix: 'Unknown scope'! !

!ScopedBrowser class methodsFor: 'instance creation' stamp: 'JRS 11/19/2000 09:10'!
openBrowserWithCategories: aCollectionOfCategorySymbols withoutClasses: aCollectionOfClassSymbols

	self openBrowserWithCategories: aCollectionOfCategorySymbols 
		withoutClasses: aCollectionOfClassSymbols
		withLabelSuffix: 'Unknown scope'! !

!ScopedBrowser class methodsFor: 'instance creation' stamp: 'JRS 11/19/2000 09:10'!
openBrowserWithCategories: aCollectionOfCategorySymbols withoutClasses: aCollectionOfClassSymbols withLabelSuffix: aLabelSuffix

	| aScopedBrowser |

	aScopedBrowser := self new.
	aScopedBrowser includedCategories: aCollectionOfCategorySymbols.
	aScopedBrowser excludedClasses: aCollectionOfClassSymbols.
	self openBrowserView: (aScopedBrowser openEditString: nil)
			label: 'Scoped Browser: ', aLabelSuffix		! !


!ScopedBrowser class methodsFor: 'instance creation - Making Smalltalk' stamp: 'JRS 11/19/2000 09:17'!
openBrowserForArticle3

	self openBrowserWithCategories: (OrderedCollection new 
			add: 'Collections-Abstract' asSymbol; 
			add: 'Collections-Sequenceable' asSymbol;
			add: 'Collections-Unordered' asSymbol;
			yourself)
		withoutClasses: (OrderedCollection new
			add: #ArrayedCollection;
			add: #SharedQueue;
			add: #MappedCollection;
			add: #Interval;
			add: #IdentityDictionary;
			add: #IdentitySet;
			add: #PluggableDictionary;
			add: #PluggableSet;
			yourself)
		withLabelSuffix: 'Making Smalltalk - Article 3 scope'! !


!ScopedBrowser class methodsFor: 'qa testing' stamp: 'JRS 11/19/2000 09:19'!
openBrowserTest
	"Test creation method"

	self openBrowserWithCategories: (OrderedCollection new 
			add: 'Jason-Testing' asSymbol; 
			add: 'Collections-Abstract' asSymbol;
			yourself)! !

!ScopedBrowser class methodsFor: 'qa testing' stamp: 'JRS 11/19/2000 09:19'!
openBrowserTest2
	"Test creation method"

	self openBrowserWithCategories: (OrderedCollection new 
			add: 'Jason-Testing' asSymbol; 
			add: 'Collections-Abstract' asSymbol;
			yourself)
		withoutClasses: (OrderedCollection new
			add: #Collection;
			yourself)! !

!ScopedBrowser class methodsFor: 'qa testing' stamp: 'JRS 11/19/2000 09:18'!
openBrowserTest3
	"Test creation method"

	self openBrowserWithCategories: (OrderedCollection new 
			add: 'Collections-Abstract' asSymbol;
			yourself)
		withoutClasses: (OrderedCollection new
			add: #Collection;
			yourself)
		withLabelSuffix: 'Testing Scope'! !

!ScopedBrowser class methodsFor: 'qa testing' stamp: 'JRS 11/19/2000 09:21'!
openBrowserTest4
	"Test instantiating with a non-existant category"

	self openBrowserWithCategories: (OrderedCollection new 
			add: 'asdfasdfd-ereeff' asSymbol; 
			add: 'Collections-Abstract' asSymbol;
			yourself)
		withoutClasses: (OrderedCollection new
			add: #Collection;
			yourself)
		withLabelSuffix: 'Testing nonexistant category'! !

!ScopedBrowser class methodsFor: 'qa testing' stamp: 'JRS 11/19/2000 09:21'!
openBrowserTest5
	"Test instantiating with a non-existant class to exclude"

	self openBrowserWithCategories: (OrderedCollection new 
			add: 'asdfasdfd-ereeff' asSymbol; 
			add: 'Collections-Abstract' asSymbol;
			yourself)
		withoutClasses: (OrderedCollection new
			add: #Aadfdfefff;
			yourself)
		withLabelSuffix: 'Testing nonexistant class'! !


!ScopedBrowser class methodsFor: 'testing' stamp: 'JRS 11/19/2000 09:20'!
version

	^1.0! !
