/* LekhoneeMain.c generated by valac, the Vala compiler
 * generated from LekhoneeMain.vala, do not modify */

/* LekhoneeMain.vala
 *
 * Copyright (C) 2010  Kushal Das <kushal@fedoraproject.org>
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.

 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software Foundation, 
 * Inc., 51 Franklin St, Fifth Floor, Boston, MA 02110-1301, USA.
 *
 *
 */

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include <gtksourceview/gtksourceview.h>
#include <webkit/webkit.h>
#include <gtkspell/gtkspell.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <config.h>
#include <gtksourceview/gtksourcelanguagemanager.h>
#include <glib/gi18n-lib.h>
#include <gdk/gdk.h>
#include <stdio.h>
#include <libsoup/soup.h>
#include <glib/gstdio.h>


#define TYPE_LEKHONEE_MAIN (lekhonee_main_get_type ())
#define LEKHONEE_MAIN(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_LEKHONEE_MAIN, LekhoneeMain))
#define LEKHONEE_MAIN_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_LEKHONEE_MAIN, LekhoneeMainClass))
#define IS_LEKHONEE_MAIN(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_LEKHONEE_MAIN))
#define IS_LEKHONEE_MAIN_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_LEKHONEE_MAIN))
#define LEKHONEE_MAIN_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_LEKHONEE_MAIN, LekhoneeMainClass))

typedef struct _LekhoneeMain LekhoneeMain;
typedef struct _LekhoneeMainClass LekhoneeMainClass;
typedef struct _LekhoneeMainPrivate LekhoneeMainPrivate;

#define TYPE_WORDPRESS (wordpress_get_type ())
#define WORDPRESS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_WORDPRESS, Wordpress))
#define WORDPRESS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_WORDPRESS, WordpressClass))
#define IS_WORDPRESS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_WORDPRESS))
#define IS_WORDPRESS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_WORDPRESS))
#define WORDPRESS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_WORDPRESS, WordpressClass))

typedef struct _Wordpress Wordpress;
typedef struct _WordpressClass WordpressClass;

#define AUTH_TYPE_ACCOUNTS (auth_accounts_get_type ())
#define AUTH_ACCOUNTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), AUTH_TYPE_ACCOUNTS, AuthAccounts))
#define AUTH_ACCOUNTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), AUTH_TYPE_ACCOUNTS, AuthAccountsClass))
#define AUTH_IS_ACCOUNTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), AUTH_TYPE_ACCOUNTS))
#define AUTH_IS_ACCOUNTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), AUTH_TYPE_ACCOUNTS))
#define AUTH_ACCOUNTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), AUTH_TYPE_ACCOUNTS, AuthAccountsClass))

typedef struct _AuthAccounts AuthAccounts;
typedef struct _AuthAccountsClass AuthAccountsClass;

#define TYPE_ACCOUNT_ACTION (account_action_get_type ())
#define ACCOUNT_ACTION(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ACCOUNT_ACTION, AccountAction))
#define ACCOUNT_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ACCOUNT_ACTION, AccountActionClass))
#define IS_ACCOUNT_ACTION(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ACCOUNT_ACTION))
#define IS_ACCOUNT_ACTION_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ACCOUNT_ACTION))
#define ACCOUNT_ACTION_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ACCOUNT_ACTION, AccountActionClass))

typedef struct _AccountAction AccountAction;
typedef struct _AccountActionClass AccountActionClass;

#define TYPE_PREF_DIALOG (pref_dialog_get_type ())
#define PREF_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PREF_DIALOG, PrefDialog))
#define PREF_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PREF_DIALOG, PrefDialogClass))
#define IS_PREF_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PREF_DIALOG))
#define IS_PREF_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PREF_DIALOG))
#define PREF_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PREF_DIALOG, PrefDialogClass))

typedef struct _PrefDialog PrefDialog;
typedef struct _PrefDialogClass PrefDialogClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _0(var) ((var == NULL) ? NULL : (var = ( (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _PrefDialogPrivate PrefDialogPrivate;

#define TYPE_ACCOUNT_WIDGET (account_widget_get_type ())
#define ACCOUNT_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ACCOUNT_WIDGET, AccountWidget))
#define ACCOUNT_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ACCOUNT_WIDGET, AccountWidgetClass))
#define IS_ACCOUNT_WIDGET(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ACCOUNT_WIDGET))
#define IS_ACCOUNT_WIDGET_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ACCOUNT_WIDGET))
#define ACCOUNT_WIDGET_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ACCOUNT_WIDGET, AccountWidgetClass))

typedef struct _AccountWidget AccountWidget;
typedef struct _AccountWidgetClass AccountWidgetClass;
#define _g_free0(var) (var = (g_free (var), NULL))
typedef struct _WordpressPrivate WordpressPrivate;
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))
#define _g_regex_unref0(var) ((var == NULL) ? NULL : (var = (g_regex_unref (var), NULL)))

#define TYPE_GENERIC_DIALOG (generic_dialog_get_type ())
#define GENERIC_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_GENERIC_DIALOG, GenericDialog))
#define GENERIC_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_GENERIC_DIALOG, GenericDialogClass))
#define IS_GENERIC_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_GENERIC_DIALOG))
#define IS_GENERIC_DIALOG_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_GENERIC_DIALOG))
#define GENERIC_DIALOG_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_GENERIC_DIALOG, GenericDialogClass))

typedef struct _GenericDialog GenericDialog;
typedef struct _GenericDialogClass GenericDialogClass;
#define _gtk_tree_path_free0(var) ((var == NULL) ? NULL : (var = (gtk_tree_path_free (var), NULL)))
#define _g_value_array_free0(var) ((var == NULL) ? NULL : (var = (g_value_array_free (var), NULL)))
#define __g_list_free_gtk_tree_path_free0(var) ((var == NULL) ? NULL : (var = (_g_list_free_gtk_tree_path_free (var), NULL)))

struct _LekhoneeMain {
	GObject parent_instance;
	LekhoneeMainPrivate * priv;
	Wordpress* wp;
	GtkBuilder* builder;
	GtkWindow* window;
	GtkTreeView* category_list;
	GtkTreeView* entries_list;
	GtkListStore* liststore;
	GtkListStore* liststore2;
	GtkScrolledWindow* scw;
	GtkScrolledWindow* scw2;
	GtkScrolledWindow* scw3;
	GtkScrolledWindow* scw5;
	GtkVBox* vbox3;
	GtkButton* refresh_bttn;
	gboolean source_flag;
	gboolean edit_flag;
	GtkMenuItem* htmltags;
	GtkProgressBar* progressbar;
	GtkEntry* file_txt;
	guint vid;
	gboolean advert;
	AuthAccounts* accounts;
	AccountAction* account_act;
	PrefDialog* pref_dialog;
	GtkSourceBuffer* blog_txt;
	GtkSourceView* sourceview;
	GtkNotebook* notebook;
	WebKitWebView* editor;
	WebKitWebSettings* wsettings;
	WebKitWebView* previewer;
	gint last_seen;
	GtkEntry* title_entry;
	GtkEntry* category_entry;
	GtkEntry* tags_entry;
	GtkButton* draft_bttn;
	GtkButton* publish_bttn;
	GtkToolButton* style_bttn;
	GtkCheckButton* spell_box;
	GValue entry;
	GtkSpell* spell;
};

struct _LekhoneeMainClass {
	GObjectClass parent_class;
	void (*change_view) (LekhoneeMain* self, GtkNotebookPage* page, guint offset);
};

struct _PrefDialog {
	GtkDialog parent_instance;
	PrefDialogPrivate * priv;
	AccountWidget* accountWidget;
};

struct _PrefDialogClass {
	GtkDialogClass parent_class;
};

struct _Wordpress {
	GObject parent_instance;
	WordpressPrivate * priv;
	char* password;
	char* server;
};

struct _WordpressClass {
	GObjectClass parent_class;
};


static gpointer lekhonee_main_parent_class = NULL;

GType lekhonee_main_get_type (void);
GType wordpress_get_type (void);
GType auth_accounts_get_type (void);
GType account_action_get_type (void);
GType pref_dialog_get_type (void);
enum  {
	LEKHONEE_MAIN_DUMMY_PROPERTY
};
Wordpress* wordpress_new (void);
Wordpress* wordpress_construct (GType object_type);
void lekhonee_main_show_error (LekhoneeMain* self, const char* message);
static void _lekhonee_main_show_error_wordpress_password_error (Wordpress* _sender, const char* mesaage, gpointer self);
gboolean lekhonee_main_navigation_requested (LekhoneeMain* self, WebKitWebFrame* p0, WebKitNetworkRequest* p1, WebKitWebNavigationAction* p2, WebKitWebPolicyDecision* p3);
static gboolean _lekhonee_main_navigation_requested_webkit_web_view_navigation_policy_decision_requested (WebKitWebView* _sender, WebKitWebFrame* p0, WebKitNetworkRequest* p1, WebKitWebNavigationAction* p2, WebKitWebPolicyDecision* p3, gpointer self);
void lekhonee_main_style_bttn_cb (LekhoneeMain* self, GtkToolButton* b);
static void _lekhonee_main_style_bttn_cb_gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self);
AuthAccounts* auth_accounts_new (void);
AuthAccounts* auth_accounts_construct (GType object_type);
gboolean lekhonee_main_on_delete_event (LekhoneeMain* self, GtkWidget* w, GdkEvent* e);
static gboolean _lekhonee_main_on_delete_event_gtk_widget_delete_event (GtkWidget* _sender, GdkEvent* event, gpointer self);
void lekhonee_main_create_connections (LekhoneeMain* self);
LekhoneeMain* lekhonee_main_new (void);
LekhoneeMain* lekhonee_main_construct (GType object_type);
PrefDialog* pref_dialog_new (GtkWindow* parent, AuthAccounts* accounts);
PrefDialog* pref_dialog_construct (GType object_type, GtkWindow* parent, AuthAccounts* accounts);
GType account_widget_get_type (void);
void lekhonee_main_redraw_accountmenu (LekhoneeMain* self);
static void _lekhonee_main_redraw_accountmenu_account_widget_setup_menuui (AccountWidget* _sender, gpointer self);
void lekhonee_main_show_config_dialog (LekhoneeMain* self, GtkMenuItem* i);
void account_action_set_ui (AccountAction* self, AuthAccounts* _ac);
gboolean wordpress_set_details (Wordpress* self, const char* name, const char* pass, const char* serv);
void lekhonee_main_get_categories (LekhoneeMain* self, GtkButton* b);
void lekhonee_main_store_config (LekhoneeMain* self, const char* server, const char* user, const char* password, gboolean ad);
void lekhonee_main_show_dialog (LekhoneeMain* self, GtkMenuItem* w);
static void _lekhonee_main_show_dialog_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
void lekhonee_main_on_action (LekhoneeMain* self, GtkToolButton* button);
static void _lekhonee_main_on_action_gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self);
static void _lekhonee_main_show_config_dialog_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
void lekhonee_main_save_file_cb (LekhoneeMain* self, GtkMenuItem* i);
static void _lekhonee_main_save_file_cb_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
void lekhonee_main_open_file_cb (LekhoneeMain* self, GtkMenuItem* i);
static void _lekhonee_main_open_file_cb_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
void lekhonee_main_on_new_cb (LekhoneeMain* self, GtkMenuItem* i);
static void _lekhonee_main_on_new_cb_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
void lekhonee_main_quit (LekhoneeMain* self, GtkObject* o);
static void _lekhonee_main_quit_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
void lekhonee_main_on_blockquote_cb (LekhoneeMain* self, GtkMenuItem* i);
static void _lekhonee_main_on_blockquote_cb_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
void lekhonee_main_on_code_cb (LekhoneeMain* self, GtkMenuItem* i);
static void _lekhonee_main_on_code_cb_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
void lekhonee_main_on_pre_cb (LekhoneeMain* self, GtkMenuItem* i);
static void _lekhonee_main_on_pre_cb_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
void lekhonee_main_on_last_entry_cb (LekhoneeMain* self, GtkMenuItem* i);
static void _lekhonee_main_on_last_entry_cb_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
void lekhonee_main_on_upload_cb (LekhoneeMain* self, GtkMenuItem* i);
static void _lekhonee_main_on_upload_cb_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
void lekhonee_main_on_cancel_cb (LekhoneeMain* self, GtkButton* b);
static void _lekhonee_main_on_cancel_cb_gtk_button_clicked (GtkButton* _sender, gpointer self);
void lekhonee_main_on_select_cb (LekhoneeMain* self, GtkButton* b);
static void _lekhonee_main_on_select_cb_gtk_button_clicked (GtkButton* _sender, gpointer self);
void lekhonee_main_on_uploadfile_cb (LekhoneeMain* self, GtkButton* b);
static void _lekhonee_main_on_uploadfile_cb_gtk_button_clicked (GtkButton* _sender, gpointer self);
void lekhonee_main_on_publish_cb (LekhoneeMain* self, GtkButton* b);
static void _lekhonee_main_on_publish_cb_gtk_button_clicked (GtkButton* _sender, gpointer self);
void lekhonee_main_on_draft_cb (LekhoneeMain* self, GtkButton* b);
static void _lekhonee_main_on_draft_cb_gtk_button_clicked (GtkButton* _sender, gpointer self);
void lekhonee_main_on_add_category_cb (LekhoneeMain* self, GtkButton* b);
static void _lekhonee_main_on_add_category_cb_gtk_button_clicked (GtkButton* _sender, gpointer self);
void lekhonee_main_on_old_posts_menuitem_cb (LekhoneeMain* self, GtkMenuItem* i);
static void _lekhonee_main_on_old_posts_menuitem_cb_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
gboolean lekhonee_main_on_oldposts_key_cb (LekhoneeMain* self, GdkEventKey* event);
static gboolean _lekhonee_main_on_oldposts_key_cb_gtk_widget_key_press_event (GtkWidget* _sender, GdkEventKey* event, gpointer self);
gboolean lekhonee_main_on_oldposts_button_cb (LekhoneeMain* self, GdkEventButton* event);
static gboolean _lekhonee_main_on_oldposts_button_cb_gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self);
AccountAction* account_action_new (GtkMenuItem* m);
AccountAction* account_action_construct (GType object_type, GtkMenuItem* m);
void lekhonee_main_set_wp_details (LekhoneeMain* self, const char* login, const char* pass, const char* service, const char* proxy);
static void _lekhonee_main_set_wp_details_account_action_current_account (AccountAction* _sender, const char* login, const char* pass, const char* service, const char* proxy, gpointer self);
void lekhonee_main_change_view (LekhoneeMain* self, GtkNotebookPage* page, guint offset);
static void _lekhonee_main_change_view_gtk_notebook_switch_page (GtkNotebook* _sender, GtkNotebookPage* page, guint page_num, gpointer self);
void lekhonee_main_link_bttn_cb (LekhoneeMain* self, GtkToolButton* b);
static void _lekhonee_main_link_bttn_cb_gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self);
void lekhonee_main_image_bttn_cb (LekhoneeMain* self, GtkToolButton* b);
static void _lekhonee_main_image_bttn_cb_gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self);
void lekhonee_main_on_spell_cb (LekhoneeMain* self, GtkToggleButton* b);
static void _lekhonee_main_on_spell_cb_gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self);
static void _lekhonee_main_get_categories_gtk_button_clicked (GtkButton* _sender, gpointer self);
void lekhonee_main_populate_posts (LekhoneeMain* self, GValueArray* values);
static void _lekhonee_main_populate_posts_wordpress_get_old_posts (Wordpress* _sender, GValueArray* v, gpointer self);
void wordpress_add_category (Wordpress* self, const char* category);
void lekhonee_main_bold_bttn_cb (LekhoneeMain* self);
void lekhonee_main_italic_bttn_cb (LekhoneeMain* self);
void lekhonee_main_underline_bttn_cb (LekhoneeMain* self);
void lekhonee_main_unorderedlist_cb (LekhoneeMain* self);
void lekhonee_main_insertpara_cb (LekhoneeMain* self);
char* lekhonee_main_get_source (LekhoneeMain* self);
const char* wordpress_get_username (Wordpress* self);
char* wordpress_post (Wordpress* self, GHashTable* content, gboolean publish);
GHashTable* wordpress_get_post (Wordpress* self, const char* id);
static GValue* _g_value_dup (GValue* self);
char* get_lekhonee_template (const char* url, const char* ntitle, const char* ncontent);
void wordpress_delete_post (Wordpress* self, gint id);
void lekhonee_main_load_preview (LekhoneeMain* self, const char* content);
static void lekhonee_main_real_change_view (LekhoneeMain* self, GtkNotebookPage* page, guint offset);
gboolean lekhonee_main_update_bar (LekhoneeMain* self);
static gboolean _lekhonee_main_update_bar_gsource_func (gpointer self);
char** wordpress_get_categories (Wordpress* self, int* result_length1);
GenericDialog* generic_dialog_new (const char* text);
GenericDialog* generic_dialog_construct (GType object_type, const char* text);
GType generic_dialog_get_type (void);
void lekhonee_main_insert_image (LekhoneeMain* self, const char* mes);
static void _lekhonee_main_insert_image_generic_dialog_send_link (GenericDialog* _sender, const char* mesaage, gpointer self);
void lekhonee_main_insert_link (LekhoneeMain* self, const char* mes);
static void _lekhonee_main_insert_link_generic_dialog_send_link (GenericDialog* _sender, const char* mesaage, gpointer self);
GHashTable* wordpress_get_last_post (Wordpress* self);
void lekhonee_main_load_post_details (LekhoneeMain* self);
gboolean wordpress_get_posts (Wordpress* self);
gboolean lekhonee_main_check_exit (LekhoneeMain* self);
void lekhonee_main_on_newcb_response (LekhoneeMain* self, GtkDialog* source, gint response_id);
static void _lekhonee_main_on_newcb_response_gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self);
void lekhonee_main_clear_it (LekhoneeMain* self);
char* wordpress_upload_file (Wordpress* self, GHashTable* data);
void lekhonee_main_message_post (LekhoneeMain* self, gboolean publish);
char* wordpress_update (Wordpress* self, const char* pid, GHashTable* content, gboolean publish);
static void _g_list_free_gtk_tree_path_free (GList* self);
void xml_open_file (const char* path, char** title, char** desc, char** tags);
void xml_save_file (const char* filename, const char* title, const char* desc, const char* tags);
void lekhonee_main_on_quit_response (LekhoneeMain* self, GtkDialog* source, gint response_id);
static void _lekhonee_main_on_quit_response_gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self);
gint lekhonee_main_main (char** args, int args_length1);
static void lekhonee_main_finalize (GObject* obj);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);
static int _vala_strcmp0 (const char * str1, const char * str2);



static void _lekhonee_main_show_error_wordpress_password_error (Wordpress* _sender, const char* mesaage, gpointer self) {
	lekhonee_main_show_error (self, mesaage);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static gboolean _lekhonee_main_navigation_requested_webkit_web_view_navigation_policy_decision_requested (WebKitWebView* _sender, WebKitWebFrame* p0, WebKitNetworkRequest* p1, WebKitWebNavigationAction* p2, WebKitWebPolicyDecision* p3, gpointer self) {
	return lekhonee_main_navigation_requested (self, p0, p1, p2, p3);
}


static void _lekhonee_main_style_bttn_cb_gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self) {
	lekhonee_main_style_bttn_cb (self, _sender);
}


static gboolean _lekhonee_main_on_delete_event_gtk_widget_delete_event (GtkWidget* _sender, GdkEvent* event, gpointer self) {
	return lekhonee_main_on_delete_event (self, _sender, event);
}


LekhoneeMain* lekhonee_main_construct (GType object_type) {
	GError * _inner_error_;
	LekhoneeMain * self;
	_inner_error_ = NULL;
	self = (LekhoneeMain*) g_object_new (object_type, NULL);
	{
		Wordpress* _tmp0_;
		PrefDialog* _tmp1_;
		GtkBuilder* _tmp2_;
		GFile* acc_file;
		GtkWindow* _tmp4_;
		GObject* _tmp3_;
		GtkTreeView* _tmp6_;
		GObject* _tmp5_;
		GtkProgressBar* _tmp8_;
		GObject* _tmp7_;
		GtkEntry* _tmp10_;
		GObject* _tmp9_;
		GtkEntry* _tmp12_;
		GObject* _tmp11_;
		GtkEntry* _tmp14_;
		GObject* _tmp13_;
		GtkButton* _tmp16_;
		GObject* _tmp15_;
		GtkButton* _tmp18_;
		GObject* _tmp17_;
		GtkNotebook* _tmp20_;
		GObject* _tmp19_;
		GtkSourceLanguageManager* langm;
		GtkSourceLanguage* lang;
		GtkScrolledWindow* _tmp22_;
		GObject* _tmp21_;
		GtkSourceBuffer* _tmp23_;
		GtkSourceView* _tmp24_;
		WebKitWebView* _tmp25_;
		WebKitWebSettings* _tmp26_;
		GtkScrolledWindow* _tmp28_;
		GObject* _tmp27_;
		WebKitWebView* _tmp29_;
		GtkScrolledWindow* _tmp31_;
		GObject* _tmp30_;
		GtkMenuItem* _tmp33_;
		GObject* _tmp32_;
		GtkListStore* _tmp34_;
		GtkTreeView* _tmp36_;
		GObject* _tmp35_;
		GtkCellRendererText* _tmp37_;
		GtkTreeSelection* selection;
		GtkListStore* _tmp38_;
		GtkTreeView* _tmp40_;
		GObject* _tmp39_;
		GtkCellRendererText* _tmp41_;
		GtkTreeSelection* selection2;
		GValue _tmp43_;
		GValue _tmp42_ = {0};
		GtkToolButton* _tmp45_;
		GObject* _tmp44_;
		GtkVBox* _tmp47_;
		GObject* _tmp46_;
		GtkEntry* _tmp49_;
		GObject* _tmp48_;
		GtkScrolledWindow* _tmp51_;
		GObject* _tmp50_;
		AuthAccounts* _tmp52_;
		GtkButton* _tmp54_;
		GObject* _tmp53_;
		self->wp = (_tmp0_ = wordpress_new (), _g_object_unref0 (self->wp), _tmp0_);
		g_signal_connect_object (self->wp, "password-error", (GCallback) _lekhonee_main_show_error_wordpress_password_error, self, 0);
		self->pref_dialog = (_tmp1_ = NULL, _g_object_unref0 (self->pref_dialog), _tmp1_);
		self->builder = (_tmp2_ = gtk_builder_new (), _g_object_unref0 (self->builder), _tmp2_);
		acc_file = g_file_new_for_path ("ui/new.ui");
		if (g_file_query_exists (acc_file, NULL)) {
			gtk_builder_add_from_file (self->builder, "ui/new.ui", &_inner_error_);
			if (_inner_error_ != NULL) {
				_g_object_unref0 (acc_file);
				goto __catch9_g_error;
			}
		} else {
			gtk_builder_add_from_file (self->builder, PKGDATADIR "/new.ui", &_inner_error_);
			if (_inner_error_ != NULL) {
				_g_object_unref0 (acc_file);
				goto __catch9_g_error;
			}
		}
		self->window = (_tmp4_ = _g_object_ref0 ((_tmp3_ = gtk_builder_get_object (self->builder, "MainWindow"), GTK_IS_WINDOW (_tmp3_) ? ((GtkWindow*) _tmp3_) : NULL)), _g_object_unref0 (self->window), _tmp4_);
		self->category_list = (_tmp6_ = _g_object_ref0 ((_tmp5_ = gtk_builder_get_object (self->builder, "category_list"), GTK_IS_TREE_VIEW (_tmp5_) ? ((GtkTreeView*) _tmp5_) : NULL)), _g_object_unref0 (self->category_list), _tmp6_);
		self->progressbar = (_tmp8_ = _g_object_ref0 ((_tmp7_ = gtk_builder_get_object (self->builder, "progressbar"), GTK_IS_PROGRESS_BAR (_tmp7_) ? ((GtkProgressBar*) _tmp7_) : NULL)), _g_object_unref0 (self->progressbar), _tmp8_);
		self->title_entry = (_tmp10_ = _g_object_ref0 ((_tmp9_ = gtk_builder_get_object (self->builder, "titleTxt"), GTK_IS_ENTRY (_tmp9_) ? ((GtkEntry*) _tmp9_) : NULL)), _g_object_unref0 (self->title_entry), _tmp10_);
		self->tags_entry = (_tmp12_ = _g_object_ref0 ((_tmp11_ = gtk_builder_get_object (self->builder, "tags_entry"), GTK_IS_ENTRY (_tmp11_) ? ((GtkEntry*) _tmp11_) : NULL)), _g_object_unref0 (self->tags_entry), _tmp12_);
		self->category_entry = (_tmp14_ = _g_object_ref0 ((_tmp13_ = gtk_builder_get_object (self->builder, "add_category_txt"), GTK_IS_ENTRY (_tmp13_) ? ((GtkEntry*) _tmp13_) : NULL)), _g_object_unref0 (self->category_entry), _tmp14_);
		self->draft_bttn = (_tmp16_ = _g_object_ref0 ((_tmp15_ = gtk_builder_get_object (self->builder, "draft_bttn"), GTK_IS_BUTTON (_tmp15_) ? ((GtkButton*) _tmp15_) : NULL)), _g_object_unref0 (self->draft_bttn), _tmp16_);
		self->publish_bttn = (_tmp18_ = _g_object_ref0 ((_tmp17_ = gtk_builder_get_object (self->builder, "publish_bttn"), GTK_IS_BUTTON (_tmp17_) ? ((GtkButton*) _tmp17_) : NULL)), _g_object_unref0 (self->publish_bttn), _tmp18_);
		self->edit_flag = FALSE;
		self->notebook = (_tmp20_ = _g_object_ref0 ((_tmp19_ = gtk_builder_get_object (self->builder, "notebook"), GTK_IS_NOTEBOOK (_tmp19_) ? ((GtkNotebook*) _tmp19_) : NULL)), _g_object_unref0 (self->notebook), _tmp20_);
		langm = gtk_source_language_manager_new ();
		lang = _g_object_ref0 (gtk_source_language_manager_get_language (langm, "html"));
		self->scw = (_tmp22_ = _g_object_ref0 ((_tmp21_ = gtk_builder_get_object (self->builder, "scw"), GTK_IS_SCROLLED_WINDOW (_tmp21_) ? ((GtkScrolledWindow*) _tmp21_) : NULL)), _g_object_unref0 (self->scw), _tmp22_);
		self->blog_txt = (_tmp23_ = gtk_source_buffer_new_with_language (lang), _g_object_unref0 (self->blog_txt), _tmp23_);
		self->sourceview = (_tmp24_ = g_object_ref_sink ((GtkSourceView*) gtk_source_view_new_with_buffer (self->blog_txt)), _g_object_unref0 (self->sourceview), _tmp24_);
		gtk_text_view_set_wrap_mode ((GtkTextView*) self->sourceview, GTK_WRAP_WORD);
		gtk_container_add ((GtkContainer*) self->scw, (GtkWidget*) self->sourceview);
		self->editor = (_tmp25_ = g_object_ref_sink ((WebKitWebView*) webkit_web_view_new ()), _g_object_unref0 (self->editor), _tmp25_);
		webkit_web_view_set_editable (self->editor, TRUE);
		webkit_web_view_load_string (self->editor, "", "text/html", "utf-8", "preview");
		g_signal_connect_object (self->editor, "navigation-policy-decision-requested", (GCallback) _lekhonee_main_navigation_requested_webkit_web_view_navigation_policy_decision_requested, self, 0);
		self->wsettings = (_tmp26_ = webkit_web_settings_new (), _g_object_unref0 (self->wsettings), _tmp26_);
		webkit_web_view_set_settings (self->editor, self->wsettings);
		self->scw2 = (_tmp28_ = _g_object_ref0 ((_tmp27_ = gtk_builder_get_object (self->builder, "scw2"), GTK_IS_SCROLLED_WINDOW (_tmp27_) ? ((GtkScrolledWindow*) _tmp27_) : NULL)), _g_object_unref0 (self->scw2), _tmp28_);
		gtk_container_add ((GtkContainer*) self->scw2, (GtkWidget*) self->editor);
		gtk_widget_set_visible (self->scw2->vscrollbar, TRUE);
		self->last_seen = 0;
		self->previewer = (_tmp29_ = g_object_ref_sink ((WebKitWebView*) webkit_web_view_new ()), _g_object_unref0 (self->previewer), _tmp29_);
		self->scw5 = (_tmp31_ = _g_object_ref0 ((_tmp30_ = gtk_builder_get_object (self->builder, "scw5"), GTK_IS_SCROLLED_WINDOW (_tmp30_) ? ((GtkScrolledWindow*) _tmp30_) : NULL)), _g_object_unref0 (self->scw5), _tmp31_);
		gtk_container_add ((GtkContainer*) self->scw5, (GtkWidget*) self->previewer);
		self->htmltags = (_tmp33_ = _g_object_ref0 ((_tmp32_ = gtk_builder_get_object (self->builder, "menuitem3"), GTK_IS_MENU_ITEM (_tmp32_) ? ((GtkMenuItem*) _tmp32_) : NULL)), _g_object_unref0 (self->htmltags), _tmp33_);
		gtk_widget_set_sensitive ((GtkWidget*) self->htmltags, FALSE);
		self->liststore = (_tmp34_ = gtk_list_store_new (1, G_TYPE_STRING, NULL), _g_object_unref0 (self->liststore), _tmp34_);
		self->category_list = (_tmp36_ = _g_object_ref0 ((_tmp35_ = gtk_builder_get_object (self->builder, "category_list"), GTK_IS_TREE_VIEW (_tmp35_) ? ((GtkTreeView*) _tmp35_) : NULL)), _g_object_unref0 (self->category_list), _tmp36_);
		gtk_tree_view_insert_column_with_attributes (self->category_list, -1, _ ("Categories"), (GtkCellRenderer*) (_tmp37_ = g_object_ref_sink ((GtkCellRendererText*) gtk_cell_renderer_text_new ())), "text", 0, NULL);
		_g_object_unref0 (_tmp37_);
		gtk_tree_view_set_model (self->category_list, (GtkTreeModel*) self->liststore);
		selection = _g_object_ref0 (gtk_tree_view_get_selection (self->category_list));
		gtk_tree_selection_set_mode (selection, GTK_SELECTION_MULTIPLE);
		self->liststore2 = (_tmp38_ = gtk_list_store_new (2, G_TYPE_STRING, G_TYPE_HASH_TABLE, NULL), _g_object_unref0 (self->liststore2), _tmp38_);
		self->entries_list = (_tmp40_ = _g_object_ref0 ((_tmp39_ = gtk_builder_get_object (self->builder, "entries_list"), GTK_IS_TREE_VIEW (_tmp39_) ? ((GtkTreeView*) _tmp39_) : NULL)), _g_object_unref0 (self->entries_list), _tmp40_);
		gtk_tree_view_insert_column_with_attributes (self->entries_list, -1, _ ("Post Title"), (GtkCellRenderer*) (_tmp41_ = g_object_ref_sink ((GtkCellRendererText*) gtk_cell_renderer_text_new ())), "text", 0, NULL);
		_g_object_unref0 (_tmp41_);
		gtk_tree_view_set_model (self->entries_list, (GtkTreeModel*) self->liststore2);
		selection2 = _g_object_ref0 (gtk_tree_view_get_selection (self->entries_list));
		gtk_tree_selection_set_mode (selection2, GTK_SELECTION_SINGLE);
		self->entry = (_tmp43_ = (g_value_init (&_tmp42_, G_TYPE_HASH_TABLE), _tmp42_), G_IS_VALUE (&self->entry) ? (g_value_unset (&self->entry), NULL) : NULL, _tmp43_);
		gtk_widget_show_all ((GtkWidget*) self->window);
		gtk_widget_hide_all ((GtkWidget*) self->progressbar);
		self->style_bttn = (_tmp45_ = _g_object_ref0 ((_tmp44_ = gtk_builder_get_object (self->builder, "style"), GTK_IS_TOOL_BUTTON (_tmp44_) ? ((GtkToolButton*) _tmp44_) : NULL)), _g_object_unref0 (self->style_bttn), _tmp45_);
		g_signal_connect_object (self->style_bttn, "clicked", (GCallback) _lekhonee_main_style_bttn_cb_gtk_tool_button_clicked, self, 0);
		gtk_widget_hide_all ((GtkWidget*) self->style_bttn);
		self->vbox3 = (_tmp47_ = _g_object_ref0 ((_tmp46_ = gtk_builder_get_object (self->builder, "vbox3"), GTK_IS_VBOX (_tmp46_) ? ((GtkVBox*) _tmp46_) : NULL)), _g_object_unref0 (self->vbox3), _tmp47_);
		gtk_widget_hide_all ((GtkWidget*) self->vbox3);
		self->file_txt = (_tmp49_ = _g_object_ref0 ((_tmp48_ = gtk_builder_get_object (self->builder, "file_txt"), GTK_IS_ENTRY (_tmp48_) ? ((GtkEntry*) _tmp48_) : NULL)), _g_object_unref0 (self->file_txt), _tmp49_);
		self->scw3 = (_tmp51_ = _g_object_ref0 ((_tmp50_ = gtk_builder_get_object (self->builder, "scw3"), GTK_IS_SCROLLED_WINDOW (_tmp50_) ? ((GtkScrolledWindow*) _tmp50_) : NULL)), _g_object_unref0 (self->scw3), _tmp51_);
		gtk_widget_hide_all ((GtkWidget*) self->scw3);
		self->accounts = (_tmp52_ = auth_accounts_new (), _g_object_unref0 (self->accounts), _tmp52_);
		gtk_window_resize (self->window, 700, 400);
		self->source_flag = FALSE;
		g_signal_connect_object ((GtkWidget*) self->window, "delete-event", (GCallback) _lekhonee_main_on_delete_event_gtk_widget_delete_event, self, 0);
		self->refresh_bttn = (_tmp54_ = _g_object_ref0 ((_tmp53_ = gtk_builder_get_object (self->builder, "refresh_bttn"), GTK_IS_BUTTON (_tmp53_) ? ((GtkButton*) _tmp53_) : NULL)), _g_object_unref0 (self->refresh_bttn), _tmp54_);
		lekhonee_main_create_connections (self);
		gtk_widget_realize ((GtkWidget*) self->editor);
		gtk_widget_grab_focus ((GtkWidget*) self->editor);
		_g_object_unref0 (acc_file);
		_g_object_unref0 (langm);
		_g_object_unref0 (lang);
		_g_object_unref0 (selection);
		_g_object_unref0 (selection2);
	}
	goto __finally9;
	__catch9_g_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			fprintf (stderr, "Could not load UI: %s\n", e->message);
			_g_error_free0 (e);
		}
	}
	__finally9:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	return self;
}


LekhoneeMain* lekhonee_main_new (void) {
	return lekhonee_main_construct (TYPE_LEKHONEE_MAIN);
}


static void _lekhonee_main_redraw_accountmenu_account_widget_setup_menuui (AccountWidget* _sender, gpointer self) {
	lekhonee_main_redraw_accountmenu (self);
}


void lekhonee_main_show_config_dialog (LekhoneeMain* self, GtkMenuItem* i) {
	PrefDialog* _tmp0_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (i != NULL);
	self->pref_dialog = (_tmp0_ = g_object_ref_sink (pref_dialog_new (self->window, self->accounts)), _g_object_unref0 (self->pref_dialog), _tmp0_);
	g_signal_connect_object (self->pref_dialog->accountWidget, "setup-menuui", (GCallback) _lekhonee_main_redraw_accountmenu_account_widget_setup_menuui, self, 0);
}


void lekhonee_main_redraw_accountmenu (LekhoneeMain* self) {
	AuthAccounts* accounts;
	g_return_if_fail (self != NULL);
	accounts = auth_accounts_new ();
	account_action_set_ui (self->account_act, accounts);
	_g_object_unref0 (accounts);
}


void lekhonee_main_store_config (LekhoneeMain* self, const char* server, const char* user, const char* password, gboolean ad) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (server != NULL);
	g_return_if_fail (user != NULL);
	g_return_if_fail (password != NULL);
	self->advert = ad;
	wordpress_set_details (self->wp, user, password, server);
	lekhonee_main_get_categories (self, self->refresh_bttn);
}


void lekhonee_main_show_dialog (LekhoneeMain* self, GtkMenuItem* w) {
	GtkAboutDialog* dialog;
	gint _tmp1__length1;
	char** _tmp1_;
	char** _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (w != NULL);
	dialog = g_object_ref_sink ((GtkAboutDialog*) gtk_about_dialog_new ());
	gtk_buildable_set_name ((GtkBuildable*) dialog, "lekhonee-gnome");
	gtk_about_dialog_set_copyright (dialog, "(c) 2009-2010 Kushal Das");
	gtk_about_dialog_set_website (dialog, "http://fedorahosted.org/lekhonee");
	gtk_about_dialog_set_version (dialog, "0.11");
	gtk_about_dialog_set_authors (dialog, (_tmp1_ = (_tmp0_ = g_new0 (char*, 2 + 1), _tmp0_[0] = g_strdup ("Kushal Das kushal@fedoraproject.org"), _tmp0_[1] = NULL, _tmp0_), _tmp1__length1 = 2, _tmp1_));
	_tmp1_ = (_vala_array_free (_tmp1_, _tmp1__length1, (GDestroyNotify) g_free), NULL);
	gtk_about_dialog_set_program_name (dialog, "lekhonee-gnome");
	gtk_about_dialog_set_translator_credits (dialog, "Sankarshan Mukhopadhyay <sankarshan@fedoraproject.org>\n" \
"yurchor <yurchor@@fedoraproject.org>\n" \
"logan <logan@fedoraproject.org>\n" \
"Piotr Drąg <raven@fedoraproject.org>\n" \
"Sébastien Natroll <sebantien@fedoraproject.org>\n" \
"kmilos <kmilos@fedoraproject.org>\n" \
"Kris Thomsen <kristho@fedoraproject.org>\n" \
"Fabian Affolter <fab@fedoraproject.org>\n" \
"Geert Warrink <warrink@fedoraproject.org>\n" \
"Taylon Silmer Lacerda Silva <taylon@fedoraproject.org>\n" \
"Nikolas Slivka <snicore@fedoraproject.org>\n" \
"Andrew Zaytsev <andzaytsev@fedoraproject.org>\n" \
"ulissisgc <ulissisgc@fedoraproject.org>\n" \
"Thomas Canniot <mrtom@fedoraproject.org>\n" \
"Guido Grazioli <guidograzioli@fedoraproject.org>\n" \
"ypoyarko <ypoyarko@fedoraproject.org>\n" \
"Domingo Becker <beckerde@fedoraproject.org>\n" \
"tomchiukc <tomchiukc@fedoraproject.org>\n" \
"Claudio Rodrigo Pereyra Diaz <elsupergomez@fedoraproject.org>\n" \
"A S Alam <aalam@fedoraproject.org>\n" \
"Ankit Patel <ankit@fedoraproject.org>\n" \
" ");
	gtk_dialog_run ((GtkDialog*) dialog);
	gtk_object_destroy ((GtkObject*) dialog);
	_g_object_unref0 (dialog);
}


static void _lekhonee_main_show_dialog_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	lekhonee_main_show_dialog (self, _sender);
}


static void _lekhonee_main_on_action_gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self) {
	lekhonee_main_on_action (self, _sender);
}


static void _lekhonee_main_show_config_dialog_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	lekhonee_main_show_config_dialog (self, _sender);
}


static void _lekhonee_main_save_file_cb_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	lekhonee_main_save_file_cb (self, _sender);
}


static void _lekhonee_main_open_file_cb_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	lekhonee_main_open_file_cb (self, _sender);
}


static void _lekhonee_main_on_new_cb_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	lekhonee_main_on_new_cb (self, _sender);
}


static void _lekhonee_main_quit_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	lekhonee_main_quit (self, _sender);
}


static void _lekhonee_main_on_blockquote_cb_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	lekhonee_main_on_blockquote_cb (self, _sender);
}


static void _lekhonee_main_on_code_cb_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	lekhonee_main_on_code_cb (self, _sender);
}


static void _lekhonee_main_on_pre_cb_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	lekhonee_main_on_pre_cb (self, _sender);
}


static void _lekhonee_main_on_last_entry_cb_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	lekhonee_main_on_last_entry_cb (self, _sender);
}


static void _lekhonee_main_on_upload_cb_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	lekhonee_main_on_upload_cb (self, _sender);
}


static void _lekhonee_main_on_cancel_cb_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	lekhonee_main_on_cancel_cb (self, _sender);
}


static void _lekhonee_main_on_select_cb_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	lekhonee_main_on_select_cb (self, _sender);
}


static void _lekhonee_main_on_uploadfile_cb_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	lekhonee_main_on_uploadfile_cb (self, _sender);
}


static void _lekhonee_main_on_publish_cb_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	lekhonee_main_on_publish_cb (self, _sender);
}


static void _lekhonee_main_on_draft_cb_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	lekhonee_main_on_draft_cb (self, _sender);
}


static void _lekhonee_main_on_add_category_cb_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	lekhonee_main_on_add_category_cb (self, _sender);
}


static void _lekhonee_main_on_old_posts_menuitem_cb_gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	lekhonee_main_on_old_posts_menuitem_cb (self, _sender);
}


static gboolean _lekhonee_main_on_oldposts_key_cb_gtk_widget_key_press_event (GtkWidget* _sender, GdkEventKey* event, gpointer self) {
	return lekhonee_main_on_oldposts_key_cb (self, event);
}


static gboolean _lekhonee_main_on_oldposts_button_cb_gtk_widget_button_press_event (GtkWidget* _sender, GdkEventButton* event, gpointer self) {
	return lekhonee_main_on_oldposts_button_cb (self, event);
}


static void _lekhonee_main_set_wp_details_account_action_current_account (AccountAction* _sender, const char* login, const char* pass, const char* service, const char* proxy, gpointer self) {
	lekhonee_main_set_wp_details (self, login, pass, service, proxy);
}


static void _lekhonee_main_change_view_gtk_notebook_switch_page (GtkNotebook* _sender, GtkNotebookPage* page, guint page_num, gpointer self) {
	lekhonee_main_change_view (self, page, page_num);
}


static void _lekhonee_main_link_bttn_cb_gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self) {
	lekhonee_main_link_bttn_cb (self, _sender);
}


static void _lekhonee_main_image_bttn_cb_gtk_tool_button_clicked (GtkToolButton* _sender, gpointer self) {
	lekhonee_main_image_bttn_cb (self, _sender);
}


static void _lekhonee_main_on_spell_cb_gtk_toggle_button_toggled (GtkToggleButton* _sender, gpointer self) {
	lekhonee_main_on_spell_cb (self, _sender);
}


static void _lekhonee_main_get_categories_gtk_button_clicked (GtkButton* _sender, gpointer self) {
	lekhonee_main_get_categories (self, _sender);
}


static void _lekhonee_main_populate_posts_wordpress_get_old_posts (Wordpress* _sender, GValueArray* v, gpointer self) {
	lekhonee_main_populate_posts (self, v);
}


void lekhonee_main_create_connections (LekhoneeMain* self) {
	GObject* _tmp0_;
	GtkImageMenuItem* about_activity;
	GObject* _tmp1_;
	GtkToolButton* bold;
	GObject* _tmp2_;
	GtkToolButton* italic;
	GObject* _tmp3_;
	GtkToolButton* underline;
	GObject* _tmp4_;
	GtkToolButton* insertunorderedlist;
	GObject* _tmp5_;
	GtkToolButton* insertpara;
	GObject* _tmp6_;
	GtkImageMenuItem* p_menuitem;
	GObject* _tmp7_;
	GtkImageMenuItem* save_menuitem;
	GObject* _tmp8_;
	GtkImageMenuItem* open_menuitem;
	GObject* _tmp9_;
	GtkImageMenuItem* new_menuitem;
	GObject* _tmp10_;
	GtkImageMenuItem* quit_menuitem;
	GObject* _tmp11_;
	GtkMenuItem* blockquote_menuitem;
	GObject* _tmp12_;
	GtkMenuItem* code_menuitem;
	GObject* _tmp13_;
	GtkMenuItem* pre_menuitem;
	GObject* _tmp14_;
	GtkMenuItem* last_entry_menuitem;
	GObject* _tmp15_;
	GtkMenuItem* upload_menuitem;
	GObject* _tmp16_;
	GtkButton* cancel_bttn;
	GObject* _tmp17_;
	GtkButton* file_select_bttn;
	GObject* _tmp18_;
	GtkButton* file_upload_bttn;
	GObject* _tmp19_;
	GtkButton* publish_bttn;
	GObject* _tmp20_;
	GtkButton* draft_bttn;
	GObject* _tmp21_;
	GtkButton* add_category_bttn;
	GObject* _tmp22_;
	GtkMenuItem* old_posts_menuitem;
	GObject* _tmp23_;
	GtkMenuItem* accounts_menuitem;
	AccountAction* _tmp24_;
	AuthAccounts* accounts;
	GObject* _tmp25_;
	GtkToolButton* link_ui_bttn;
	GObject* _tmp26_;
	GtkToolButton* image_ui_bttn;
	GtkCheckButton* _tmp28_;
	GObject* _tmp27_;
	g_return_if_fail (self != NULL);
	about_activity = _g_object_ref0 ((_tmp0_ = gtk_builder_get_object (self->builder, "imagemenuitem10"), GTK_IS_IMAGE_MENU_ITEM (_tmp0_) ? ((GtkImageMenuItem*) _tmp0_) : NULL));
	g_signal_connect_object ((GtkMenuItem*) about_activity, "activate", (GCallback) _lekhonee_main_show_dialog_gtk_menu_item_activate, self, 0);
	bold = _g_object_ref0 ((_tmp1_ = gtk_builder_get_object (self->builder, "bold"), GTK_IS_TOOL_BUTTON (_tmp1_) ? ((GtkToolButton*) _tmp1_) : NULL));
	italic = _g_object_ref0 ((_tmp2_ = gtk_builder_get_object (self->builder, "italic"), GTK_IS_TOOL_BUTTON (_tmp2_) ? ((GtkToolButton*) _tmp2_) : NULL));
	underline = _g_object_ref0 ((_tmp3_ = gtk_builder_get_object (self->builder, "underline"), GTK_IS_TOOL_BUTTON (_tmp3_) ? ((GtkToolButton*) _tmp3_) : NULL));
	insertunorderedlist = _g_object_ref0 ((_tmp4_ = gtk_builder_get_object (self->builder, "insertunorderedlist"), GTK_IS_TOOL_BUTTON (_tmp4_) ? ((GtkToolButton*) _tmp4_) : NULL));
	insertpara = _g_object_ref0 ((_tmp5_ = gtk_builder_get_object (self->builder, "insertParagraph"), GTK_IS_TOOL_BUTTON (_tmp5_) ? ((GtkToolButton*) _tmp5_) : NULL));
	g_signal_connect_object (bold, "clicked", (GCallback) _lekhonee_main_on_action_gtk_tool_button_clicked, self, 0);
	g_signal_connect_object (italic, "clicked", (GCallback) _lekhonee_main_on_action_gtk_tool_button_clicked, self, 0);
	g_signal_connect_object (underline, "clicked", (GCallback) _lekhonee_main_on_action_gtk_tool_button_clicked, self, 0);
	g_signal_connect_object (insertunorderedlist, "clicked", (GCallback) _lekhonee_main_on_action_gtk_tool_button_clicked, self, 0);
	g_signal_connect_object (insertpara, "clicked", (GCallback) _lekhonee_main_on_action_gtk_tool_button_clicked, self, 0);
	p_menuitem = _g_object_ref0 ((_tmp6_ = gtk_builder_get_object (self->builder, "preferences_menuitem"), GTK_IS_IMAGE_MENU_ITEM (_tmp6_) ? ((GtkImageMenuItem*) _tmp6_) : NULL));
	g_signal_connect_object ((GtkMenuItem*) p_menuitem, "activate", (GCallback) _lekhonee_main_show_config_dialog_gtk_menu_item_activate, self, 0);
	save_menuitem = _g_object_ref0 ((_tmp7_ = gtk_builder_get_object (self->builder, "save_menuitem"), GTK_IS_IMAGE_MENU_ITEM (_tmp7_) ? ((GtkImageMenuItem*) _tmp7_) : NULL));
	g_signal_connect_object ((GtkMenuItem*) save_menuitem, "activate", (GCallback) _lekhonee_main_save_file_cb_gtk_menu_item_activate, self, 0);
	open_menuitem = _g_object_ref0 ((_tmp8_ = gtk_builder_get_object (self->builder, "open_menuitem"), GTK_IS_IMAGE_MENU_ITEM (_tmp8_) ? ((GtkImageMenuItem*) _tmp8_) : NULL));
	g_signal_connect_object ((GtkMenuItem*) open_menuitem, "activate", (GCallback) _lekhonee_main_open_file_cb_gtk_menu_item_activate, self, 0);
	new_menuitem = _g_object_ref0 ((_tmp9_ = gtk_builder_get_object (self->builder, "imagemenuitem1"), GTK_IS_IMAGE_MENU_ITEM (_tmp9_) ? ((GtkImageMenuItem*) _tmp9_) : NULL));
	g_signal_connect_object ((GtkMenuItem*) new_menuitem, "activate", (GCallback) _lekhonee_main_on_new_cb_gtk_menu_item_activate, self, 0);
	quit_menuitem = _g_object_ref0 ((_tmp10_ = gtk_builder_get_object (self->builder, "imagemenuitem5"), GTK_IS_IMAGE_MENU_ITEM (_tmp10_) ? ((GtkImageMenuItem*) _tmp10_) : NULL));
	g_signal_connect_object ((GtkMenuItem*) quit_menuitem, "activate", (GCallback) _lekhonee_main_quit_gtk_menu_item_activate, self, 0);
	blockquote_menuitem = _g_object_ref0 ((_tmp11_ = gtk_builder_get_object (self->builder, "blockquote_menuitem"), GTK_IS_MENU_ITEM (_tmp11_) ? ((GtkMenuItem*) _tmp11_) : NULL));
	g_signal_connect_object (blockquote_menuitem, "activate", (GCallback) _lekhonee_main_on_blockquote_cb_gtk_menu_item_activate, self, 0);
	code_menuitem = _g_object_ref0 ((_tmp12_ = gtk_builder_get_object (self->builder, "code_menuitem"), GTK_IS_MENU_ITEM (_tmp12_) ? ((GtkMenuItem*) _tmp12_) : NULL));
	g_signal_connect_object (code_menuitem, "activate", (GCallback) _lekhonee_main_on_code_cb_gtk_menu_item_activate, self, 0);
	pre_menuitem = _g_object_ref0 ((_tmp13_ = gtk_builder_get_object (self->builder, "pre_menuitem"), GTK_IS_MENU_ITEM (_tmp13_) ? ((GtkMenuItem*) _tmp13_) : NULL));
	g_signal_connect_object (pre_menuitem, "activate", (GCallback) _lekhonee_main_on_pre_cb_gtk_menu_item_activate, self, 0);
	last_entry_menuitem = _g_object_ref0 ((_tmp14_ = gtk_builder_get_object (self->builder, "last_entry"), GTK_IS_MENU_ITEM (_tmp14_) ? ((GtkMenuItem*) _tmp14_) : NULL));
	g_signal_connect_object (last_entry_menuitem, "activate", (GCallback) _lekhonee_main_on_last_entry_cb_gtk_menu_item_activate, self, 0);
	upload_menuitem = _g_object_ref0 ((_tmp15_ = gtk_builder_get_object (self->builder, "upload_menuitem"), GTK_IS_MENU_ITEM (_tmp15_) ? ((GtkMenuItem*) _tmp15_) : NULL));
	g_signal_connect_object (upload_menuitem, "activate", (GCallback) _lekhonee_main_on_upload_cb_gtk_menu_item_activate, self, 0);
	cancel_bttn = _g_object_ref0 ((_tmp16_ = gtk_builder_get_object (self->builder, "file_cancel_bttn"), GTK_IS_BUTTON (_tmp16_) ? ((GtkButton*) _tmp16_) : NULL));
	g_signal_connect_object (cancel_bttn, "clicked", (GCallback) _lekhonee_main_on_cancel_cb_gtk_button_clicked, self, 0);
	file_select_bttn = _g_object_ref0 ((_tmp17_ = gtk_builder_get_object (self->builder, "file_select_bttn"), GTK_IS_BUTTON (_tmp17_) ? ((GtkButton*) _tmp17_) : NULL));
	g_signal_connect_object (file_select_bttn, "clicked", (GCallback) _lekhonee_main_on_select_cb_gtk_button_clicked, self, 0);
	file_upload_bttn = _g_object_ref0 ((_tmp18_ = gtk_builder_get_object (self->builder, "file_upload_bttn"), GTK_IS_BUTTON (_tmp18_) ? ((GtkButton*) _tmp18_) : NULL));
	g_signal_connect_object (file_upload_bttn, "clicked", (GCallback) _lekhonee_main_on_uploadfile_cb_gtk_button_clicked, self, 0);
	publish_bttn = _g_object_ref0 ((_tmp19_ = gtk_builder_get_object (self->builder, "publish_bttn"), GTK_IS_BUTTON (_tmp19_) ? ((GtkButton*) _tmp19_) : NULL));
	g_signal_connect_object (publish_bttn, "clicked", (GCallback) _lekhonee_main_on_publish_cb_gtk_button_clicked, self, 0);
	draft_bttn = _g_object_ref0 ((_tmp20_ = gtk_builder_get_object (self->builder, "draft_bttn"), GTK_IS_BUTTON (_tmp20_) ? ((GtkButton*) _tmp20_) : NULL));
	g_signal_connect_object (draft_bttn, "clicked", (GCallback) _lekhonee_main_on_draft_cb_gtk_button_clicked, self, 0);
	add_category_bttn = _g_object_ref0 ((_tmp21_ = gtk_builder_get_object (self->builder, "add_category_bttn"), GTK_IS_BUTTON (_tmp21_) ? ((GtkButton*) _tmp21_) : NULL));
	g_signal_connect_object (add_category_bttn, "clicked", (GCallback) _lekhonee_main_on_add_category_cb_gtk_button_clicked, self, 0);
	old_posts_menuitem = _g_object_ref0 ((_tmp22_ = gtk_builder_get_object (self->builder, "old_posts_menuitem"), GTK_IS_MENU_ITEM (_tmp22_) ? ((GtkMenuItem*) _tmp22_) : NULL));
	g_signal_connect_object (old_posts_menuitem, "activate", (GCallback) _lekhonee_main_on_old_posts_menuitem_cb_gtk_menu_item_activate, self, 0);
	g_signal_connect_object ((GtkWidget*) self->entries_list, "key-press-event", (GCallback) _lekhonee_main_on_oldposts_key_cb_gtk_widget_key_press_event, self, 0);
	g_signal_connect_object ((GtkWidget*) self->entries_list, "button-press-event", (GCallback) _lekhonee_main_on_oldposts_button_cb_gtk_widget_button_press_event, self, 0);
	accounts_menuitem = _g_object_ref0 ((_tmp23_ = gtk_builder_get_object (self->builder, "account_menuitem"), GTK_IS_MENU_ITEM (_tmp23_) ? ((GtkMenuItem*) _tmp23_) : NULL));
	self->account_act = (_tmp24_ = account_action_new (accounts_menuitem), _g_object_unref0 (self->account_act), _tmp24_);
	g_signal_connect_object (self->account_act, "current-account", (GCallback) _lekhonee_main_set_wp_details_account_action_current_account, self, 0);
	accounts = auth_accounts_new ();
	account_action_set_ui (self->account_act, accounts);
	g_signal_connect_object (self->notebook, "switch-page", (GCallback) _lekhonee_main_change_view_gtk_notebook_switch_page, self, 0);
	link_ui_bttn = _g_object_ref0 ((_tmp25_ = gtk_builder_get_object (self->builder, "link_ui_bttn"), GTK_IS_TOOL_BUTTON (_tmp25_) ? ((GtkToolButton*) _tmp25_) : NULL));
	g_signal_connect_object (link_ui_bttn, "clicked", (GCallback) _lekhonee_main_link_bttn_cb_gtk_tool_button_clicked, self, 0);
	image_ui_bttn = _g_object_ref0 ((_tmp26_ = gtk_builder_get_object (self->builder, "image_ui_bttn"), GTK_IS_TOOL_BUTTON (_tmp26_) ? ((GtkToolButton*) _tmp26_) : NULL));
	g_signal_connect_object (image_ui_bttn, "clicked", (GCallback) _lekhonee_main_image_bttn_cb_gtk_tool_button_clicked, self, 0);
	self->spell_box = (_tmp28_ = _g_object_ref0 ((_tmp27_ = gtk_builder_get_object (self->builder, "spell_box"), GTK_IS_CHECK_BUTTON (_tmp27_) ? ((GtkCheckButton*) _tmp27_) : NULL)), _g_object_unref0 (self->spell_box), _tmp28_);
	g_signal_connect_object ((GtkToggleButton*) self->spell_box, "toggled", (GCallback) _lekhonee_main_on_spell_cb_gtk_toggle_button_toggled, self, 0);
	g_signal_connect_object (self->refresh_bttn, "clicked", (GCallback) _lekhonee_main_get_categories_gtk_button_clicked, self, 0);
	g_signal_connect_object (self->wp, "get-old-posts", (GCallback) _lekhonee_main_populate_posts_wordpress_get_old_posts, self, 0);
	_g_object_unref0 (about_activity);
	_g_object_unref0 (bold);
	_g_object_unref0 (italic);
	_g_object_unref0 (underline);
	_g_object_unref0 (insertunorderedlist);
	_g_object_unref0 (insertpara);
	_g_object_unref0 (p_menuitem);
	_g_object_unref0 (save_menuitem);
	_g_object_unref0 (open_menuitem);
	_g_object_unref0 (new_menuitem);
	_g_object_unref0 (quit_menuitem);
	_g_object_unref0 (blockquote_menuitem);
	_g_object_unref0 (code_menuitem);
	_g_object_unref0 (pre_menuitem);
	_g_object_unref0 (last_entry_menuitem);
	_g_object_unref0 (upload_menuitem);
	_g_object_unref0 (cancel_bttn);
	_g_object_unref0 (file_select_bttn);
	_g_object_unref0 (file_upload_bttn);
	_g_object_unref0 (publish_bttn);
	_g_object_unref0 (draft_bttn);
	_g_object_unref0 (add_category_bttn);
	_g_object_unref0 (old_posts_menuitem);
	_g_object_unref0 (accounts_menuitem);
	_g_object_unref0 (accounts);
	_g_object_unref0 (link_ui_bttn);
	_g_object_unref0 (image_ui_bttn);
}


void lekhonee_main_on_spell_cb (LekhoneeMain* self, GtkToggleButton* b) {
	GError * _inner_error_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (b != NULL);
	_inner_error_ = NULL;
	if (gtk_toggle_button_get_active (b)) {
		GValue _tmp1_;
		GValue _tmp0_ = {0};
		GtkSpell* _tmp2_;
		GtkSpell* _tmp3_;
		g_object_set_property ((GObject*) self->wsettings, "enable_spell_checking", (_tmp1_ = (g_value_init (&_tmp0_, G_TYPE_BOOLEAN), g_value_set_boolean (&_tmp0_, TRUE), _tmp0_), &_tmp1_));
		_tmp2_ = gtkspell_new_attach ((GtkTextView*) self->sourceview, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		self->spell = (_tmp3_ = _tmp2_, _0 (self->spell), _tmp3_);
		gtkspell_recheck_all (self->spell);
	} else {
		GValue _tmp5_;
		GValue _tmp4_ = {0};
		gtkspell_detach (self->spell);
		g_object_set_property ((GObject*) self->wsettings, "enable_spell_checking", (_tmp5_ = (g_value_init (&_tmp4_, G_TYPE_BOOLEAN), g_value_set_boolean (&_tmp4_, FALSE), _tmp4_), &_tmp5_));
	}
}


void lekhonee_main_set_wp_details (LekhoneeMain* self, const char* login, const char* pass, const char* service, const char* proxy) {
	char* server;
	gboolean test;
	g_return_if_fail (self != NULL);
	g_return_if_fail (login != NULL);
	g_return_if_fail (pass != NULL);
	g_return_if_fail (service != NULL);
	g_return_if_fail (proxy != NULL);
	server = g_strdup ("");
	if (_vala_strcmp0 (service, "wordpress.com") == 0) {
		char* _tmp3_;
		char* _tmp2_;
		char* _tmp1_;
		char* _tmp0_;
		server = (_tmp3_ = g_strconcat (_tmp2_ = g_strconcat (_tmp1_ = g_strconcat (_tmp0_ = g_strconcat ("http://", login, NULL), ".", NULL), service, NULL), "/xmlrpc.php", NULL), _g_free0 (server), _tmp3_);
		_g_free0 (_tmp2_);
		_g_free0 (_tmp1_);
		_g_free0 (_tmp0_);
	} else {
		char* _tmp4_;
		server = (_tmp4_ = g_strdup (proxy), _g_free0 (server), _tmp4_);
	}
	test = wordpress_set_details (self->wp, login, pass, server);
	if (test) {
		lekhonee_main_get_categories (self, self->refresh_bttn);
	}
	_g_free0 (server);
}


void lekhonee_main_show_error (LekhoneeMain* self, const char* message) {
	GtkMessageDialog* dm;
	g_return_if_fail (self != NULL);
	g_return_if_fail (message != NULL);
	dm = g_object_ref_sink ((GtkMessageDialog*) gtk_message_dialog_new (self->window, GTK_DIALOG_MODAL, GTK_MESSAGE_ERROR, GTK_BUTTONS_OK, message));
	gtk_window_set_title ((GtkWindow*) dm, _ ("lekhonee-gnome"));
	gtk_dialog_run ((GtkDialog*) dm);
	gtk_object_destroy ((GtkObject*) dm);
	_g_object_unref0 (dm);
}


void lekhonee_main_on_add_category_cb (LekhoneeMain* self, GtkButton* b) {
	char* name;
	g_return_if_fail (self != NULL);
	g_return_if_fail (b != NULL);
	if (_vala_strcmp0 (self->wp->server, "") == 0) {
		lekhonee_main_show_error (self, _ ("Select an account first"));
		return;
	}
	name = g_strdup (gtk_entry_get_text (self->category_entry));
	if (_vala_strcmp0 (name, "") != 0) {
		wordpress_add_category (self->wp, name);
		lekhonee_main_get_categories (self, self->refresh_bttn);
		gtk_entry_set_text (self->category_entry, "");
	}
	_g_free0 (name);
}


static const char* string_to_string (const char* self) {
	const char* result = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	result = self;
	return result;
}


void lekhonee_main_on_action (LekhoneeMain* self, GtkToolButton* button) {
	char* name;
	g_return_if_fail (self != NULL);
	g_return_if_fail (button != NULL);
	name = g_strdup (gtk_buildable_get_name ((GtkBuildable*) button));
	if (!self->source_flag) {
		char* _tmp0_;
		webkit_web_view_execute_script (self->editor, _tmp0_ = g_strconcat ("document.execCommand('", string_to_string (name), "', false, false);", NULL));
		_g_free0 (_tmp0_);
	} else {
		if (_vala_strcmp0 (name, "bold") == 0) {
			lekhonee_main_bold_bttn_cb (self);
		} else {
			if (_vala_strcmp0 (name, "italic") == 0) {
				lekhonee_main_italic_bttn_cb (self);
			} else {
				if (_vala_strcmp0 (name, "underline") == 0) {
					lekhonee_main_underline_bttn_cb (self);
				} else {
					if (_vala_strcmp0 (name, "insertunorderedlist") == 0) {
						lekhonee_main_unorderedlist_cb (self);
					} else {
						if (_vala_strcmp0 (name, "insertParagraph") == 0) {
							lekhonee_main_insertpara_cb (self);
						}
					}
				}
			}
		}
	}
	_g_free0 (name);
}


void lekhonee_main_insertpara_cb (LekhoneeMain* self) {
	GtkTextIter _tmp0_ = {0};
	GtkTextIter start;
	GtkTextIter _tmp1_ = {0};
	GtkTextIter end;
	char* text;
	char* _result_;
	g_return_if_fail (self != NULL);
	start = (_tmp0_);
	end = (_tmp1_);
	gtk_text_buffer_get_selection_bounds ((GtkTextBuffer*) self->blog_txt, &start, &end);
	text = g_strdup (gtk_text_buffer_get_text ((GtkTextBuffer*) self->blog_txt, &start, &end, FALSE));
	gtk_text_buffer_delete ((GtkTextBuffer*) self->blog_txt, &start, &end);
	_result_ = g_strdup ("<div><br></div>");
	gtk_text_buffer_insert_at_cursor ((GtkTextBuffer*) self->blog_txt, _result_, (gint) strlen (_result_));
	_g_free0 (text);
	_g_free0 (_result_);
}


void lekhonee_main_unorderedlist_cb (LekhoneeMain* self) {
	GtkTextIter _tmp0_ = {0};
	GtkTextIter start;
	GtkTextIter _tmp1_ = {0};
	GtkTextIter end;
	char* text;
	char* _result_;
	g_return_if_fail (self != NULL);
	start = (_tmp0_);
	end = (_tmp1_);
	gtk_text_buffer_get_selection_bounds ((GtkTextBuffer*) self->blog_txt, &start, &end);
	text = g_strdup (gtk_text_buffer_get_text ((GtkTextBuffer*) self->blog_txt, &start, &end, FALSE));
	gtk_text_buffer_delete ((GtkTextBuffer*) self->blog_txt, &start, &end);
	_result_ = g_strconcat ("<ul><li>", string_to_string (text), "</li></ul>", NULL);
	gtk_text_buffer_insert_at_cursor ((GtkTextBuffer*) self->blog_txt, _result_, (gint) strlen (_result_));
	_g_free0 (text);
	_g_free0 (_result_);
}


char* lekhonee_main_get_source (LekhoneeMain* self) {
	char* result = NULL;
	char* mes;
	char** _tmp1_;
	gint _odds_size_;
	gint odds_length1;
	char** _tmp0_;
	char** odds;
	g_return_val_if_fail (self != NULL, NULL);
	webkit_web_view_execute_script (self->editor, "document.title=document.documentElement.innerHTML;");
	mes = g_strdup (webkit_web_frame_get_title (webkit_web_view_get_main_frame (self->editor)));
	odds = (_tmp1_ = _tmp0_ = g_strsplit (mes, "<body>", 0), odds_length1 = _vala_array_length (_tmp0_), _odds_size_ = odds_length1, _tmp1_);
	result = g_strdup (odds[1]);
	_g_free0 (mes);
	odds = (_vala_array_free (odds, odds_length1, (GDestroyNotify) g_free), NULL);
	return result;
}


static GValue* _g_value_dup (GValue* self) {
	return g_boxed_copy (G_TYPE_VALUE, self);
}


static gpointer __g_value_dup0 (gpointer self) {
	return self ? _g_value_dup (self) : NULL;
}


static char* string_replace (const char* self, const char* old, const char* replacement) {
	char* result = NULL;
	GError * _inner_error_;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (old != NULL, NULL);
	g_return_val_if_fail (replacement != NULL, NULL);
	_inner_error_ = NULL;
	{
		char* _tmp0_;
		GRegex* _tmp1_;
		GRegex* regex;
		char* _tmp2_;
		regex = (_tmp1_ = g_regex_new (_tmp0_ = g_regex_escape_string (old, -1), 0, 0, &_inner_error_), _g_free0 (_tmp0_), _tmp1_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch10_g_regex_error;
			}
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		_tmp2_ = g_regex_replace_literal (regex, self, (gssize) (-1), 0, replacement, 0, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_regex_unref0 (regex);
			if (_inner_error_->domain == G_REGEX_ERROR) {
				goto __catch10_g_regex_error;
			}
			_g_regex_unref0 (regex);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return NULL;
		}
		result = _tmp2_;
		_g_regex_unref0 (regex);
		return result;
	}
	goto __finally10;
	__catch10_g_regex_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			g_assert_not_reached ();
			_g_error_free0 (e);
		}
	}
	__finally10:
	if (_inner_error_ != NULL) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
}


void lekhonee_main_style_bttn_cb (LekhoneeMain* self, GtkToolButton* b) {
	GError * _inner_error_;
	char* html;
	char* _tmp1_;
	GHashTable* hash;
	GValue* _tmp2_ = NULL;
	GValue* _tmp3_ = NULL;
	GValue* _tmp4_ = NULL;
	char* id;
	GHashTable* _tmp5_;
	GValue* url;
	char* link_url;
	char* data;
	gint iid;
	char* cache_dir;
	GFile* dir;
	GFile* _tmp6_;
	char* name;
	char* _tmp7_;
	char* _tmp8_;
	char* _tmp9_;
	char* _tmp10_;
	char* _tmp12_;
	char* _tmp11_;
	char* _tmp13_;
	char* config_filename;
	GFile* fcon;
	GFileOutputStream* file_stream;
	GDataOutputStream* data_stream;
	char* _tmp14_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (b != NULL);
	_inner_error_ = NULL;
	html = NULL;
	if ((_vala_strcmp0 (wordpress_get_username (self->wp), "") == 0) | (_vala_strcmp0 (self->wp->server, "") == 0)) {
		char* _tmp0_;
		html = (_tmp0_ = g_strdup ("<html><title></title><body><b>Please create an account first.</b></bod" \
"y</html>"), _g_free0 (html), _tmp0_);
		webkit_web_view_load_string (self->previewer, html, "text/html", "utf-8", "preview");
		_g_free0 (html);
		return;
	}
	html = (_tmp1_ = g_strdup ("<html><title></title><body><b>Please wait while we are getting the the" \
"me. (You need internet connection)</b></body</html>"), _g_free0 (html), _tmp1_);
	webkit_web_view_load_string (self->previewer, html, "text/html", "utf-8", "preview");
	hash = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, g_free);
	g_hash_table_insert (hash, g_strdup ("title"), (_tmp2_ = g_new0 (GValue, 1), g_value_init (_tmp2_, G_TYPE_STRING), g_value_set_string (_tmp2_, "OLDTITLE"), _tmp2_));
	g_hash_table_insert (hash, g_strdup ("description"), (_tmp3_ = g_new0 (GValue, 1), g_value_init (_tmp3_, G_TYPE_STRING), g_value_set_string (_tmp3_, "TESTDESC"), _tmp3_));
	g_hash_table_insert (hash, g_strdup ("dateCreated"), (_tmp4_ = g_new0 (GValue, 1), g_value_init (_tmp4_, SOUP_TYPE_DATE), g_value_take_boxed (_tmp4_, soup_date_new (2000, 1, 1, 1, 1, 1)), _tmp4_));
	id = wordpress_post (self->wp, hash, TRUE);
	hash = (_tmp5_ = wordpress_get_post (self->wp, id), _g_hash_table_unref0 (hash), _tmp5_);
	url = __g_value_dup0 ((GValue*) g_hash_table_lookup (hash, "permaLink"));
	link_url = g_strdup (g_value_get_string (url));
	data = get_lekhonee_template (link_url, "OLDTITLE", "TESTDESC");
	iid = atoi (id);
	wordpress_delete_post (self->wp, iid);
	cache_dir = g_strconcat (g_get_user_cache_dir (), "/lekhonee-gnome", NULL);
	dir = g_file_new_for_path (cache_dir);
	if (!g_file_query_exists (dir, NULL)) {
		g_file_make_directory (dir, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_free0 (html);
			_g_hash_table_unref0 (hash);
			_g_free0 (id);
			_g_free0 (url);
			_g_free0 (link_url);
			_g_free0 (data);
			_g_free0 (cache_dir);
			_g_object_unref0 (dir);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	dir = (_tmp6_ = NULL, _g_object_unref0 (dir), _tmp6_);
	name = g_strdup (self->wp->server);
	name = (_tmp7_ = string_replace (name, "http://", ""), _g_free0 (name), _tmp7_);
	name = (_tmp8_ = string_replace (name, "/", ""), _g_free0 (name), _tmp8_);
	name = (_tmp9_ = string_replace (name, ":", ""), _g_free0 (name), _tmp9_);
	name = (_tmp10_ = string_replace (name, ".", ""), _g_free0 (name), _tmp10_);
	config_filename = (_tmp13_ = g_strconcat (_tmp12_ = g_strconcat (_tmp11_ = g_strconcat (cache_dir, "/", NULL), name, NULL), ".html", NULL), _g_free0 (_tmp12_), _g_free0 (_tmp11_), _tmp13_);
	fcon = g_file_new_for_path (config_filename);
	if (g_file_query_exists (fcon, NULL)) {
		g_file_delete (fcon, NULL, &_inner_error_);
		if (_inner_error_ != NULL) {
			_g_free0 (html);
			_g_hash_table_unref0 (hash);
			_g_free0 (id);
			_g_free0 (url);
			_g_free0 (link_url);
			_g_free0 (data);
			_g_free0 (cache_dir);
			_g_object_unref0 (dir);
			_g_free0 (name);
			_g_free0 (config_filename);
			_g_object_unref0 (fcon);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	file_stream = g_file_create (fcon, G_FILE_CREATE_REPLACE_DESTINATION, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		_g_free0 (html);
		_g_hash_table_unref0 (hash);
		_g_free0 (id);
		_g_free0 (url);
		_g_free0 (link_url);
		_g_free0 (data);
		_g_free0 (cache_dir);
		_g_object_unref0 (dir);
		_g_free0 (name);
		_g_free0 (config_filename);
		_g_object_unref0 (fcon);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	data_stream = g_data_output_stream_new ((GOutputStream*) file_stream);
	g_data_output_stream_put_string (data_stream, data, NULL, &_inner_error_);
	if (_inner_error_ != NULL) {
		_g_free0 (html);
		_g_hash_table_unref0 (hash);
		_g_free0 (id);
		_g_free0 (url);
		_g_free0 (link_url);
		_g_free0 (data);
		_g_free0 (cache_dir);
		_g_object_unref0 (dir);
		_g_free0 (name);
		_g_free0 (config_filename);
		_g_object_unref0 (fcon);
		_g_object_unref0 (file_stream);
		_g_object_unref0 (data_stream);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	gtk_widget_hide_all ((GtkWidget*) self->style_bttn);
	html = (_tmp14_ = g_strdup ("<html><title></title><body><b>Come back to this page again to see the " \
"preview.</b></body</html>"), _g_free0 (html), _tmp14_);
	webkit_web_view_load_string (self->previewer, html, "text/html", "utf-8", "preview");
	_g_free0 (html);
	_g_hash_table_unref0 (hash);
	_g_free0 (id);
	_g_free0 (url);
	_g_free0 (link_url);
	_g_free0 (data);
	_g_free0 (cache_dir);
	_g_object_unref0 (dir);
	_g_free0 (name);
	_g_free0 (config_filename);
	_g_object_unref0 (fcon);
	_g_object_unref0 (file_stream);
	_g_object_unref0 (data_stream);
}


static char* string_slice (const char* self, glong start, glong end) {
	char* result = NULL;
	glong string_length;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	const char* start_string;
	g_return_val_if_fail (self != NULL, NULL);
	string_length = g_utf8_strlen (self, -1);
	if (start < 0) {
		start = string_length + start;
	}
	if (end < 0) {
		end = string_length + end;
	}
	if (start >= 0) {
		_tmp0_ = start <= string_length;
	} else {
		_tmp0_ = FALSE;
	}
	g_return_val_if_fail (_tmp0_, NULL);
	if (end >= 0) {
		_tmp1_ = end <= string_length;
	} else {
		_tmp1_ = FALSE;
	}
	g_return_val_if_fail (_tmp1_, NULL);
	g_return_val_if_fail (start <= end, NULL);
	start_string = g_utf8_offset_to_pointer (self, start);
	result = g_strndup (start_string, ((gchar*) g_utf8_offset_to_pointer (start_string, end - start)) - ((gchar*) start_string));
	return result;
}


static void lekhonee_main_real_change_view (LekhoneeMain* self, GtkNotebookPage* page, guint offset) {
	GError * _inner_error_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (page != NULL);
	_inner_error_ = NULL;
	if (offset == 1) {
		if (self->last_seen == 0) {
			char* _tmp0_;
			char* _tmp1_;
			char* blog;
			blog = (_tmp1_ = string_slice (_tmp0_ = lekhonee_main_get_source (self), (glong) 0, (glong) (-7)), _g_free0 (_tmp0_), _tmp1_);
			gtk_text_buffer_set_text ((GtkTextBuffer*) self->blog_txt, blog, (gint) strlen (blog));
			_g_free0 (blog);
		}
		self->source_flag = TRUE;
		gtk_widget_set_sensitive ((GtkWidget*) self->htmltags, TRUE);
		self->last_seen = 1;
	} else {
		if (offset == 0) {
			if (self->last_seen == 1) {
				GtkTextIter start = {0};
				GtkTextIter end = {0};
				char* text;
				char* html;
				gtk_text_buffer_get_bounds ((GtkTextBuffer*) self->blog_txt, &start, &end);
				text = g_strdup (gtk_text_buffer_get_text ((GtkTextBuffer*) self->blog_txt, &start, &end, FALSE));
				html = g_strconcat ("<html><title></title><body>", string_to_string (text), "</body</html>", NULL);
				webkit_web_view_load_string (self->editor, html, "text/html", "utf-8", "preview");
				_g_free0 (text);
				_g_free0 (html);
			}
			self->source_flag = FALSE;
			gtk_widget_set_sensitive ((GtkWidget*) self->htmltags, FALSE);
			self->last_seen = 0;
		} else {
			if (offset == 2) {
				char* name;
				char* _tmp2_;
				char* _tmp3_;
				char* _tmp4_;
				char* _tmp5_;
				char* cache_dir;
				char* _tmp7_;
				char* _tmp6_;
				char* _tmp8_;
				char* config_filename;
				GFile* fcon;
				char* content;
				GFileInputStream* _tmp9_;
				GFileInputStream* _tmp10_;
				GDataInputStream* _tmp11_;
				GDataInputStream* stream;
				char* _tmp12_;
				char* _tmp13_;
				name = g_strdup (self->wp->server);
				name = (_tmp2_ = string_replace (name, "http://", ""), _g_free0 (name), _tmp2_);
				name = (_tmp3_ = string_replace (name, "/", ""), _g_free0 (name), _tmp3_);
				name = (_tmp4_ = string_replace (name, ":", ""), _g_free0 (name), _tmp4_);
				name = (_tmp5_ = string_replace (name, ".", ""), _g_free0 (name), _tmp5_);
				cache_dir = g_strconcat (g_get_user_cache_dir (), "/lekhonee-gnome", NULL);
				config_filename = (_tmp8_ = g_strconcat (_tmp7_ = g_strconcat (_tmp6_ = g_strconcat (cache_dir, "/", NULL), name, NULL), ".html", NULL), _g_free0 (_tmp7_), _g_free0 (_tmp6_), _tmp8_);
				fcon = g_file_new_for_path (config_filename);
				if (!g_file_query_exists (fcon, NULL)) {
					gtk_widget_show_all ((GtkWidget*) self->style_bttn);
					webkit_web_view_load_string (self->previewer, "<head><body><b>Please click the Download Style button (<img src=\"http" \
"://kushaldas.in/tmp/download_theme.png\">) in the toolbar first to dow" \
"nload the blog style.</b></body></html>", "text/html", "utf-8", "preview");
					_g_free0 (name);
					_g_free0 (cache_dir);
					_g_free0 (config_filename);
					_g_object_unref0 (fcon);
					return;
				}
				content = NULL;
				_tmp9_ = g_file_read (fcon, NULL, &_inner_error_);
				if (_inner_error_ != NULL) {
					_g_free0 (name);
					_g_free0 (cache_dir);
					_g_free0 (config_filename);
					_g_object_unref0 (fcon);
					_g_free0 (content);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
				stream = (_tmp11_ = g_data_input_stream_new ((GInputStream*) (_tmp10_ = _tmp9_)), _g_object_unref0 (_tmp10_), _tmp11_);
				_tmp12_ = g_data_input_stream_read_until (stream, "", NULL, NULL, &_inner_error_);
				if (_inner_error_ != NULL) {
					_g_free0 (name);
					_g_free0 (cache_dir);
					_g_free0 (config_filename);
					_g_object_unref0 (fcon);
					_g_free0 (content);
					_g_object_unref0 (stream);
					g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
				content = (_tmp13_ = _tmp12_, _g_free0 (content), _tmp13_);
				lekhonee_main_load_preview (self, content);
				_g_free0 (name);
				_g_free0 (cache_dir);
				_g_free0 (config_filename);
				_g_object_unref0 (fcon);
				_g_free0 (content);
				_g_object_unref0 (stream);
			}
		}
	}
}


void lekhonee_main_change_view (LekhoneeMain* self, GtkNotebookPage* page, guint offset) {
	LEKHONEE_MAIN_GET_CLASS (self)->change_view (self, page, offset);
}


void lekhonee_main_load_preview (LekhoneeMain* self, const char* content) {
	char* blog;
	char* title;
	char* str;
	char* _tmp3_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (content != NULL);
	blog = g_strdup ("");
	if (self->last_seen == 0) {
		char* _tmp1_;
		char* _tmp0_;
		blog = (_tmp1_ = string_slice (_tmp0_ = lekhonee_main_get_source (self), (glong) 0, (glong) (-7)), _g_free0 (blog), _tmp1_);
		_g_free0 (_tmp0_);
	} else {
		if (self->last_seen == 1) {
			GtkTextIter start = {0};
			GtkTextIter end = {0};
			char* _tmp2_;
			gtk_text_buffer_get_bounds ((GtkTextBuffer*) self->blog_txt, &start, &end);
			blog = (_tmp2_ = g_strdup (gtk_text_buffer_get_text ((GtkTextBuffer*) self->blog_txt, &start, &end, FALSE)), _g_free0 (blog), _tmp2_);
		}
	}
	title = g_strdup (gtk_entry_get_text (self->title_entry));
	str = string_replace (content, "OLDTITLE", title);
	str = (_tmp3_ = string_replace (str, "TESTDESC", blog), _g_free0 (str), _tmp3_);
	webkit_web_view_load_string (self->previewer, str, "text/html", "utf-8", "preview");
	_g_free0 (blog);
	_g_free0 (title);
	_g_free0 (str);
}


static gboolean _lekhonee_main_update_bar_gsource_func (gpointer self) {
	return lekhonee_main_update_bar (self);
}


void lekhonee_main_get_categories (LekhoneeMain* self, GtkButton* b) {
	char** _tmp1_;
	gint __result__size_;
	gint _result__length1;
	gint _tmp0_;
	char** _result_;
	g_return_if_fail (self != NULL);
	g_return_if_fail (b != NULL);
	if (_vala_strcmp0 (self->wp->server, "") == 0) {
		lekhonee_main_show_error (self, _ ("Select an account first"));
		return;
	}
	gtk_list_store_clear (self->liststore);
	gtk_widget_show_all ((GtkWidget*) self->progressbar);
	self->vid = g_timeout_add_full (G_PRIORITY_HIGH, (guint) 100, _lekhonee_main_update_bar_gsource_func, g_object_ref (self), g_object_unref);
	gtk_progress_bar_set_text (self->progressbar, _ ("Fetching categories from server"));
	_result_ = (_tmp1_ = wordpress_get_categories (self->wp, &_tmp0_), _result__length1 = _tmp0_, __result__size_ = _result__length1, _tmp1_);
	{
		char** val_collection;
		int val_collection_length1;
		int val_it;
		val_collection = _result_;
		val_collection_length1 = _result__length1;
		for (val_it = 0; val_it < _result__length1; val_it = val_it + 1) {
			char* val;
			val = g_strdup (val_collection[val_it]);
			{
				GtkTreeIter _tmp2_ = {0};
				GtkTreeIter iter;
				iter = (_tmp2_);
				gtk_list_store_append (self->liststore, &iter);
				gtk_list_store_set (self->liststore, &iter, 0, val, -1);
				_g_free0 (val);
			}
		}
	}
	g_source_remove (self->vid);
	gtk_progress_bar_set_fraction (self->progressbar, 0.0);
	gtk_progress_bar_set_text (self->progressbar, "");
	gtk_widget_hide_all ((GtkWidget*) self->progressbar);
	_result_ = (_vala_array_free (_result_, _result__length1, (GDestroyNotify) g_free), NULL);
}


void lekhonee_main_bold_bttn_cb (LekhoneeMain* self) {
	GtkTextIter _tmp0_ = {0};
	GtkTextIter start;
	GtkTextIter _tmp1_ = {0};
	GtkTextIter end;
	char* text;
	char* _result_;
	g_return_if_fail (self != NULL);
	start = (_tmp0_);
	end = (_tmp1_);
	gtk_text_buffer_get_selection_bounds ((GtkTextBuffer*) self->blog_txt, &start, &end);
	text = g_strdup (gtk_text_buffer_get_text ((GtkTextBuffer*) self->blog_txt, &start, &end, FALSE));
	gtk_text_buffer_delete ((GtkTextBuffer*) self->blog_txt, &start, &end);
	_result_ = g_strconcat ("<strong>", string_to_string (text), "</strong>", NULL);
	gtk_text_buffer_insert_at_cursor ((GtkTextBuffer*) self->blog_txt, _result_, (gint) strlen (_result_));
	_g_free0 (text);
	_g_free0 (_result_);
}


void lekhonee_main_italic_bttn_cb (LekhoneeMain* self) {
	GtkTextIter _tmp0_ = {0};
	GtkTextIter start;
	GtkTextIter _tmp1_ = {0};
	GtkTextIter end;
	char* text;
	char* _result_;
	g_return_if_fail (self != NULL);
	start = (_tmp0_);
	end = (_tmp1_);
	gtk_text_buffer_get_selection_bounds ((GtkTextBuffer*) self->blog_txt, &start, &end);
	text = g_strdup (gtk_text_buffer_get_text ((GtkTextBuffer*) self->blog_txt, &start, &end, FALSE));
	gtk_text_buffer_delete ((GtkTextBuffer*) self->blog_txt, &start, &end);
	_result_ = g_strconcat ("<i>", string_to_string (text), "</i>", NULL);
	gtk_text_buffer_insert_at_cursor ((GtkTextBuffer*) self->blog_txt, _result_, (gint) strlen (_result_));
	_g_free0 (text);
	_g_free0 (_result_);
}


void lekhonee_main_underline_bttn_cb (LekhoneeMain* self) {
	GtkTextIter _tmp0_ = {0};
	GtkTextIter start;
	GtkTextIter _tmp1_ = {0};
	GtkTextIter end;
	char* text;
	char* _result_;
	g_return_if_fail (self != NULL);
	start = (_tmp0_);
	end = (_tmp1_);
	gtk_text_buffer_get_selection_bounds ((GtkTextBuffer*) self->blog_txt, &start, &end);
	text = g_strdup (gtk_text_buffer_get_text ((GtkTextBuffer*) self->blog_txt, &start, &end, FALSE));
	gtk_text_buffer_delete ((GtkTextBuffer*) self->blog_txt, &start, &end);
	_result_ = g_strconcat ("<u>", string_to_string (text), "</u>", NULL);
	gtk_text_buffer_insert_at_cursor ((GtkTextBuffer*) self->blog_txt, _result_, (gint) strlen (_result_));
	_g_free0 (text);
	_g_free0 (_result_);
}


static void _lekhonee_main_insert_image_generic_dialog_send_link (GenericDialog* _sender, const char* mesaage, gpointer self) {
	lekhonee_main_insert_image (self, mesaage);
}


void lekhonee_main_image_bttn_cb (LekhoneeMain* self, GtkToolButton* b) {
	GenericDialog* d;
	g_return_if_fail (self != NULL);
	g_return_if_fail (b != NULL);
	d = g_object_ref_sink (generic_dialog_new (_ ("Insert URL of the image")));
	gtk_widget_show_all ((GtkWidget*) d);
	g_signal_connect_object (d, "send-link", (GCallback) _lekhonee_main_insert_image_generic_dialog_send_link, self, 0);
	_g_object_unref0 (d);
}


void lekhonee_main_insert_image (LekhoneeMain* self, const char* mes) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (mes != NULL);
	if (self->source_flag) {
		GtkTextIter _tmp0_ = {0};
		GtkTextIter start;
		GtkTextIter _tmp1_ = {0};
		GtkTextIter end;
		char* text;
		char* _result_;
		start = (_tmp0_);
		end = (_tmp1_);
		gtk_text_buffer_get_selection_bounds ((GtkTextBuffer*) self->blog_txt, &start, &end);
		text = g_strdup (gtk_text_buffer_get_text ((GtkTextBuffer*) self->blog_txt, &start, &end, FALSE));
		gtk_text_buffer_delete ((GtkTextBuffer*) self->blog_txt, &start, &end);
		_result_ = g_strconcat ("<image src=\"", string_to_string (mes), "\">", string_to_string (text), NULL);
		gtk_text_buffer_insert_at_cursor ((GtkTextBuffer*) self->blog_txt, _result_, (gint) strlen (_result_));
		_g_free0 (text);
		_g_free0 (_result_);
	} else {
		char* _result_;
		_result_ = g_strconcat ("document.execCommand('insertImage', null, '", string_to_string (mes), "');", NULL);
		webkit_web_view_execute_script (self->editor, _result_);
		_g_free0 (_result_);
	}
}


static void _lekhonee_main_insert_link_generic_dialog_send_link (GenericDialog* _sender, const char* mesaage, gpointer self) {
	lekhonee_main_insert_link (self, mesaage);
}


void lekhonee_main_link_bttn_cb (LekhoneeMain* self, GtkToolButton* b) {
	GenericDialog* d;
	g_return_if_fail (self != NULL);
	g_return_if_fail (b != NULL);
	d = g_object_ref_sink (generic_dialog_new (_ ("Insert URL")));
	gtk_widget_show_all ((GtkWidget*) d);
	g_signal_connect_object (d, "send-link", (GCallback) _lekhonee_main_insert_link_generic_dialog_send_link, self, 0);
	_g_object_unref0 (d);
}


void lekhonee_main_insert_link (LekhoneeMain* self, const char* mes) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (mes != NULL);
	if (self->source_flag) {
		GtkTextIter _tmp0_ = {0};
		GtkTextIter start;
		GtkTextIter _tmp1_ = {0};
		GtkTextIter end;
		char* text;
		char* _result_;
		start = (_tmp0_);
		end = (_tmp1_);
		gtk_text_buffer_get_selection_bounds ((GtkTextBuffer*) self->blog_txt, &start, &end);
		text = g_strdup (gtk_text_buffer_get_text ((GtkTextBuffer*) self->blog_txt, &start, &end, FALSE));
		gtk_text_buffer_delete ((GtkTextBuffer*) self->blog_txt, &start, &end);
		_result_ = g_strconcat ("<a href=\"", string_to_string (mes), "\">", string_to_string (text), "</a>", NULL);
		gtk_text_buffer_insert_at_cursor ((GtkTextBuffer*) self->blog_txt, _result_, (gint) strlen (_result_));
		_g_free0 (text);
		_g_free0 (_result_);
	} else {
		char* _result_;
		_result_ = g_strconcat ("document.execCommand('createLink', true, '", string_to_string (mes), "');", NULL);
		webkit_web_view_execute_script (self->editor, _result_);
		_g_free0 (_result_);
	}
}


void lekhonee_main_on_blockquote_cb (LekhoneeMain* self, GtkMenuItem* i) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (i != NULL);
	if (self->source_flag) {
		GtkTextIter _tmp0_ = {0};
		GtkTextIter start;
		GtkTextIter _tmp1_ = {0};
		GtkTextIter end;
		char* text;
		char* _result_;
		start = (_tmp0_);
		end = (_tmp1_);
		gtk_text_buffer_get_selection_bounds ((GtkTextBuffer*) self->blog_txt, &start, &end);
		text = g_strdup (gtk_text_buffer_get_text ((GtkTextBuffer*) self->blog_txt, &start, &end, FALSE));
		gtk_text_buffer_delete ((GtkTextBuffer*) self->blog_txt, &start, &end);
		_result_ = g_strconcat ("<blockquote>", string_to_string (text), "</blockquote>", NULL);
		gtk_text_buffer_insert_at_cursor ((GtkTextBuffer*) self->blog_txt, _result_, (gint) strlen (_result_));
		_g_free0 (text);
		_g_free0 (_result_);
	}
}


void lekhonee_main_on_code_cb (LekhoneeMain* self, GtkMenuItem* i) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (i != NULL);
	if (self->source_flag) {
		GtkTextIter _tmp0_ = {0};
		GtkTextIter start;
		GtkTextIter _tmp1_ = {0};
		GtkTextIter end;
		char* text;
		char* _result_;
		start = (_tmp0_);
		end = (_tmp1_);
		gtk_text_buffer_get_selection_bounds ((GtkTextBuffer*) self->blog_txt, &start, &end);
		text = g_strdup (gtk_text_buffer_get_text ((GtkTextBuffer*) self->blog_txt, &start, &end, FALSE));
		gtk_text_buffer_delete ((GtkTextBuffer*) self->blog_txt, &start, &end);
		_result_ = g_strconcat ("<code>", string_to_string (text), "</code>", NULL);
		gtk_text_buffer_insert_at_cursor ((GtkTextBuffer*) self->blog_txt, _result_, (gint) strlen (_result_));
		_g_free0 (text);
		_g_free0 (_result_);
	}
}


void lekhonee_main_on_pre_cb (LekhoneeMain* self, GtkMenuItem* i) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (i != NULL);
	if (self->source_flag) {
		GtkTextIter _tmp0_ = {0};
		GtkTextIter start;
		GtkTextIter _tmp1_ = {0};
		GtkTextIter end;
		char* text;
		char* _result_;
		start = (_tmp0_);
		end = (_tmp1_);
		gtk_text_buffer_get_selection_bounds ((GtkTextBuffer*) self->blog_txt, &start, &end);
		text = g_strdup (gtk_text_buffer_get_text ((GtkTextBuffer*) self->blog_txt, &start, &end, FALSE));
		gtk_text_buffer_delete ((GtkTextBuffer*) self->blog_txt, &start, &end);
		_result_ = g_strconcat ("<pre>", string_to_string (text), "</pre>", NULL);
		gtk_text_buffer_insert_at_cursor ((GtkTextBuffer*) self->blog_txt, _result_, (gint) strlen (_result_));
		_g_free0 (text);
		_g_free0 (_result_);
	}
}


void lekhonee_main_on_last_entry_cb (LekhoneeMain* self, GtkMenuItem* i) {
	GValue _tmp1_;
	GValue _tmp0_ = {0};
	g_return_if_fail (self != NULL);
	g_return_if_fail (i != NULL);
	if (_vala_strcmp0 (self->wp->server, "") == 0) {
		lekhonee_main_show_error (self, _ ("Select an account first"));
		return;
	}
	gtk_widget_show_all ((GtkWidget*) self->progressbar);
	self->vid = g_timeout_add_full (G_PRIORITY_HIGH, (guint) 100, _lekhonee_main_update_bar_gsource_func, g_object_ref (self), g_object_unref);
	gtk_progress_bar_set_text (self->progressbar, "Fetching the last post from server");
	self->entry = (_tmp1_ = (g_value_init (&_tmp0_, G_TYPE_HASH_TABLE), g_value_take_boxed (&_tmp0_, wordpress_get_last_post (self->wp)), _tmp0_), G_IS_VALUE (&self->entry) ? (g_value_unset (&self->entry), NULL) : NULL, _tmp1_);
	g_source_remove (self->vid);
	gtk_progress_bar_set_fraction (self->progressbar, 0.0);
	gtk_progress_bar_set_text (self->progressbar, "");
	gtk_widget_hide_all ((GtkWidget*) self->progressbar);
	lekhonee_main_load_post_details (self);
}


static gpointer _g_hash_table_ref0 (gpointer self) {
	return self ? g_hash_table_ref (self) : NULL;
}


void lekhonee_main_load_post_details (LekhoneeMain* self) {
	GHashTable* hash;
	GValue* title;
	char* s_title;
	GValue* desc;
	char* s_desc;
	GValue* tags;
	char* s_tags;
	GtkTreeSelection* ts;
	GValueArray* categories;
	g_return_if_fail (self != NULL);
	hash = _g_hash_table_ref0 (g_value_get_boxed (&self->entry));
	if (((gint) g_hash_table_size (hash)) == 0) {
		_g_hash_table_unref0 (hash);
		return;
	}
	title = __g_value_dup0 ((GValue*) g_hash_table_lookup (hash, "title"));
	s_title = g_strdup (g_value_get_string (title));
	gtk_entry_set_text (self->title_entry, s_title);
	desc = __g_value_dup0 ((GValue*) g_hash_table_lookup (hash, "description"));
	s_desc = g_strdup (g_value_get_string (desc));
	if (self->source_flag) {
		gtk_text_buffer_set_text ((GtkTextBuffer*) self->blog_txt, s_desc, (gint) strlen (s_desc));
		;
	} else {
		char* _tmp0_;
		char* html;
		s_desc = (_tmp0_ = string_replace (s_desc, "\n", "<br>"), _g_free0 (s_desc), _tmp0_);
		html = g_strconcat ("<html><title></title><body>", string_to_string (s_desc), "</body</html>", NULL);
		webkit_web_view_load_string (self->editor, html, "text/html", "utf-8", "preview");
		_g_free0 (html);
	}
	tags = __g_value_dup0 ((GValue*) g_hash_table_lookup (hash, "mt_keywords"));
	s_tags = g_strdup (g_value_get_string (tags));
	gtk_entry_set_text (self->tags_entry, s_tags);
	ts = _g_object_ref0 (gtk_tree_view_get_selection (self->category_list));
	categories = g_value_get_boxed ((GValue*) g_hash_table_lookup (hash, "categories"));
	{
		GValueArray* cate_collection;
		guint cate_index;
		cate_collection = categories;
		for (cate_index = 0; cate_index < cate_collection->n_values; cate_index = cate_index + 1) {
			GValue cate;
			cate = *g_value_array_get_nth (cate_collection, cate_index);
			{
				{
					gint ii;
					ii = 0;
					{
						gboolean _tmp1_;
						_tmp1_ = TRUE;
						while (TRUE) {
							GtkTreeIter _tmp2_ = {0};
							GtkTreeIter iter;
							char* _tmp3_;
							GtkTreePath* _tmp4_;
							GtkTreePath* path;
							GValue V = {0};
							GValue _tmp6_;
							GValue _tmp5_ = {0};
							if (!_tmp1_) {
								ii++;
							}
							_tmp1_ = FALSE;
							if (!(ii < self->liststore->length)) {
								break;
							}
							iter = (_tmp2_);
							path = (_tmp4_ = gtk_tree_path_new_from_string (_tmp3_ = g_strdup_printf ("%i", ii)), _g_free0 (_tmp3_), _tmp4_);
							gtk_tree_model_get_iter ((GtkTreeModel*) self->liststore, &iter, path);
							g_value_init (&V, G_TYPE_STRING);
							gtk_tree_model_get_value ((GtkTreeModel*) self->liststore, &iter, 0, &_tmp5_);
							V = (_tmp6_ = _tmp5_, G_IS_VALUE (&V) ? (g_value_unset (&V), NULL) : NULL, _tmp6_);
							if (_vala_strcmp0 (g_value_get_string (&cate), g_value_get_string (&V)) == 0) {
								gtk_tree_selection_select_iter (ts, &iter);
							}
							_gtk_tree_path_free0 (path);
							G_IS_VALUE (&V) ? (g_value_unset (&V), NULL) : NULL;
						}
					}
				}
			}
		}
	}
	self->edit_flag = TRUE;
	gtk_widget_set_sensitive ((GtkWidget*) self->draft_bttn, FALSE);
	gtk_button_set_label (self->publish_bttn, _ ("Update"));
	_g_hash_table_unref0 (hash);
	_g_free0 (title);
	_g_free0 (s_title);
	_g_free0 (desc);
	_g_free0 (s_desc);
	_g_free0 (tags);
	_g_free0 (s_tags);
	_g_object_unref0 (ts);
}


void lekhonee_main_on_old_posts_menuitem_cb (LekhoneeMain* self, GtkMenuItem* i) {
	gboolean ret;
	g_return_if_fail (self != NULL);
	g_return_if_fail (i != NULL);
	if (_vala_strcmp0 (self->wp->server, "") == 0) {
		lekhonee_main_show_error (self, _ ("Select an account first"));
		return;
	}
	gtk_list_store_clear (self->liststore2);
	gtk_widget_show_all ((GtkWidget*) self->progressbar);
	self->vid = g_timeout_add_full (G_PRIORITY_HIGH, (guint) 200, _lekhonee_main_update_bar_gsource_func, g_object_ref (self), g_object_unref);
	gtk_progress_bar_set_text (self->progressbar, _ ("Fetching posts from server"));
	ret = wordpress_get_posts (self->wp);
	gtk_widget_show_all ((GtkWidget*) self->scw3);
	gtk_widget_grab_focus ((GtkWidget*) self->entries_list);
	g_source_remove (self->vid);
	gtk_progress_bar_set_fraction (self->progressbar, 0.0);
	gtk_widget_hide_all ((GtkWidget*) self->progressbar);
}


gboolean lekhonee_main_update_bar (LekhoneeMain* self) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	gtk_progress_bar_pulse (self->progressbar);
	result = TRUE;
	return result;
}


gboolean lekhonee_main_on_oldposts_key_cb (LekhoneeMain* self, GdkEventKey* event) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	if ((*event).keyval == 65307) {
		gtk_widget_hide_all ((GtkWidget*) self->scw3);
	}
	result = TRUE;
	return result;
}


gboolean lekhonee_main_on_oldposts_button_cb (LekhoneeMain* self, GdkEventButton* event) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	if ((*event).type == GDK_2BUTTON_PRESS) {
		GtkTreeSelection* sect;
		GtkTreeModel* model;
		GtkTreeIter iter = {0};
		GtkTreeModel* _tmp1_;
		GtkTreeModel* _tmp0_ = NULL;
		GValue _tmp3_;
		GValue _tmp2_ = {0};
		sect = _g_object_ref0 (gtk_tree_view_get_selection (self->entries_list));
		model = NULL;
		gtk_tree_selection_get_selected (sect, &_tmp0_, &iter);
		model = (_tmp1_ = _g_object_ref0 (_tmp0_), _g_object_unref0 (model), _tmp1_);
		gtk_tree_model_get_value (model, &iter, 1, &_tmp2_);
		self->entry = (_tmp3_ = _tmp2_, G_IS_VALUE (&self->entry) ? (g_value_unset (&self->entry), NULL) : NULL, _tmp3_);
		lekhonee_main_load_post_details (self);
		gtk_widget_hide_all ((GtkWidget*) self->scw3);
		_g_object_unref0 (sect);
		_g_object_unref0 (model);
	}
	result = FALSE;
	return result;
}


void lekhonee_main_populate_posts (LekhoneeMain* self, GValueArray* values) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (values != NULL);
	{
		gint i;
		i = 0;
		{
			gboolean _tmp0_;
			_tmp0_ = TRUE;
			while (TRUE) {
				GHashTable* hash;
				GValue* val;
				GtkTreeIter _tmp1_ = {0};
				GtkTreeIter iter;
				if (!_tmp0_) {
					i++;
				}
				_tmp0_ = FALSE;
				if (!(i < values->n_values)) {
					break;
				}
				hash = _g_hash_table_ref0 (g_value_get_boxed (g_value_array_get_nth (values, (guint) i)));
				val = __g_value_dup0 ((GValue*) g_hash_table_lookup (hash, "title"));
				iter = (_tmp1_);
				gtk_list_store_append (self->liststore2, &iter);
				gtk_list_store_set (self->liststore2, &iter, 0, g_value_get_string (val), -1);
				gtk_list_store_set (self->liststore2, &iter, 1, hash, -1);
				_g_hash_table_unref0 (hash);
				_g_free0 (val);
			}
		}
	}
	g_source_remove (self->vid);
	gtk_progress_bar_set_fraction (self->progressbar, 0.0);
	gtk_progress_bar_set_text (self->progressbar, "");
	gtk_widget_hide_all ((GtkWidget*) self->progressbar);
}


static glong string_get_length (const char* self) {
	glong result;
	g_return_val_if_fail (self != NULL, 0L);
	result = g_utf8_strlen (self, -1);
	return result;
}


gboolean lekhonee_main_check_exit (LekhoneeMain* self) {
	gboolean result = FALSE;
	char* text;
	g_return_val_if_fail (self != NULL, FALSE);
	text = NULL;
	if (self->source_flag) {
		GtkTextIter start = {0};
		GtkTextIter end = {0};
		char* _tmp0_;
		gtk_text_buffer_get_bounds ((GtkTextBuffer*) self->blog_txt, &start, &end);
		text = (_tmp0_ = g_strdup (gtk_text_buffer_get_text ((GtkTextBuffer*) self->blog_txt, &start, &end, FALSE)), _g_free0 (text), _tmp0_);
	} else {
		char* _tmp2_;
		char* _tmp1_;
		text = (_tmp2_ = string_slice (_tmp1_ = lekhonee_main_get_source (self), (glong) 0, (glong) (-7)), _g_free0 (text), _tmp2_);
		_g_free0 (_tmp1_);
	}
	if (string_get_length (text) == 0) {
		result = FALSE;
		_g_free0 (text);
		return result;
	} else {
		result = TRUE;
		_g_free0 (text);
		return result;
	}
	_g_free0 (text);
}


static void _lekhonee_main_on_newcb_response_gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self) {
	lekhonee_main_on_newcb_response (self, _sender, response_id);
}


void lekhonee_main_on_new_cb (LekhoneeMain* self, GtkMenuItem* i) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (i != NULL);
	if (lekhonee_main_check_exit (self)) {
		GtkMessageDialog* dm;
		dm = g_object_ref_sink ((GtkMessageDialog*) gtk_message_dialog_new (self->window, GTK_DIALOG_MODAL, GTK_MESSAGE_INFO, GTK_BUTTONS_OK_CANCEL, _ ("Are you sure to clear the current post?")));
		g_signal_connect_object ((GtkDialog*) dm, "response", (GCallback) _lekhonee_main_on_newcb_response_gtk_dialog_response, self, 0);
		gtk_dialog_run ((GtkDialog*) dm);
		gtk_object_destroy ((GtkObject*) dm);
		_g_object_unref0 (dm);
	}
}


void lekhonee_main_on_newcb_response (LekhoneeMain* self, GtkDialog* source, gint response_id) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (source != NULL);
	switch (response_id) {
		case GTK_RESPONSE_OK:
		{
			lekhonee_main_clear_it (self);
			break;
		}
	}
}


void lekhonee_main_clear_it (LekhoneeMain* self) {
	GtkTextIter start = {0};
	GtkTextIter end = {0};
	g_return_if_fail (self != NULL);
	gtk_text_buffer_get_bounds ((GtkTextBuffer*) self->blog_txt, &start, &end);
	gtk_text_buffer_set_text ((GtkTextBuffer*) self->blog_txt, "", 0);
	gtk_entry_set_text (self->title_entry, "");
	gtk_entry_set_text (self->tags_entry, "");
	webkit_web_view_load_string (self->editor, "", "text/html", "utf-8", "preview");
	if (self->edit_flag) {
		self->edit_flag = TRUE;
		gtk_button_set_label (self->publish_bttn, "Publish");
		gtk_widget_set_sensitive ((GtkWidget*) self->draft_bttn, TRUE);
	}
}


void lekhonee_main_on_upload_cb (LekhoneeMain* self, GtkMenuItem* i) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (i != NULL);
	gtk_widget_show_all ((GtkWidget*) self->vbox3);
}


void lekhonee_main_on_cancel_cb (LekhoneeMain* self, GtkButton* b) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (b != NULL);
	gtk_widget_hide_all ((GtkWidget*) self->vbox3);
}


void lekhonee_main_on_select_cb (LekhoneeMain* self, GtkButton* b) {
	GtkFileChooserDialog* chooser;
	g_return_if_fail (self != NULL);
	g_return_if_fail (b != NULL);
	chooser = g_object_ref_sink ((GtkFileChooserDialog*) gtk_file_chooser_dialog_new ("Select File", self->window, GTK_FILE_CHOOSER_ACTION_OPEN, GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL, GTK_STOCK_OPEN, GTK_RESPONSE_ACCEPT, NULL, NULL));
	if (gtk_dialog_run ((GtkDialog*) chooser) == GTK_RESPONSE_ACCEPT) {
		char* name;
		name = gtk_file_chooser_get_filename ((GtkFileChooser*) chooser);
		gtk_entry_set_text (self->file_txt, name);
		_g_free0 (name);
	}
	gtk_object_destroy ((GtkObject*) chooser);
	_g_object_unref0 (chooser);
}


static gchar* string_to_utf8 (const char* self, int* result_length1) {
	gchar* result = NULL;
	gchar* _tmp1_;
	gint __result__size_;
	gint _result__length1;
	gint _tmp0_;
	gchar* _result_;
	gchar* _tmp2_;
	g_return_val_if_fail (self != NULL, NULL);
	_result_ = (_tmp1_ = g_new0 (gchar, _tmp0_ = strlen (self) + 1), _result__length1 = _tmp0_, __result__size_ = _result__length1, _tmp1_);
	_result__length1--;
	memcpy (_result_, self, strlen (self));
	result = (_tmp2_ = _result_, *result_length1 = _result__length1, _tmp2_);
	return result;
	_result_ = (g_free (_result_), NULL);
}


void lekhonee_main_on_uploadfile_cb (LekhoneeMain* self, GtkButton* b) {
	GError * _inner_error_;
	GFile* file;
	char* raw_data;
	gsize l = 0UL;
	gboolean t = FALSE;
	gint _tmp3__length1;
	guchar* _tmp3_;
	gint _tmp2_;
	char* _tmp4_;
	char* content_type;
	GHashTable* hash;
	GValue _tmp5_ = {0};
	GValue type;
	GValue _tmp6_ = {0};
	GValue name;
	char* output;
	char* _error_;
	gint exit_status = 0;
	GValue* _tmp12_ = NULL;
	char* mes;
	g_return_if_fail (self != NULL);
	g_return_if_fail (b != NULL);
	_inner_error_ = NULL;
	if (_vala_strcmp0 (self->wp->server, "") == 0) {
		lekhonee_main_show_error (self, _ ("Select an account first"));
		return;
	}
	file = g_file_new_for_path (gtk_entry_get_text (self->file_txt));
	if (!g_file_query_exists (file, NULL)) {
		_g_object_unref0 (file);
		return;
	}
	raw_data = NULL;
	{
		char* _tmp1_;
		char* _tmp0_ = NULL;
		g_file_get_contents (gtk_entry_get_text (self->file_txt), &_tmp0_, &l, &_inner_error_);
		raw_data = (_tmp1_ = _tmp0_, _g_free0 (raw_data), _tmp1_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_FILE_ERROR) {
				goto __catch11_g_file_error;
			}
			_g_object_unref0 (file);
			_g_free0 (raw_data);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	goto __finally11;
	__catch11_g_file_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			_g_error_free0 (e);
			_g_object_unref0 (file);
			_g_free0 (raw_data);
			return;
		}
	}
	__finally11:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (file);
		_g_free0 (raw_data);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	content_type = (_tmp4_ = g_strdup (g_content_type_guess (gtk_entry_get_text (self->file_txt), (_tmp3_ = (guchar*) string_to_utf8 (raw_data, &_tmp2_), _tmp3__length1 = _tmp2_, _tmp3_), _tmp2_, &t)), _tmp3_ = (g_free (_tmp3_), NULL), _tmp4_);
	hash = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, g_free);
	type = (g_value_init (&_tmp5_, G_TYPE_STRING), g_value_set_string (&_tmp5_, content_type), _tmp5_);
	name = (g_value_init (&_tmp6_, G_TYPE_STRING), g_value_take_string (&_tmp6_, g_filename_display_basename (gtk_entry_get_text (self->file_txt))), _tmp6_);
	output = NULL;
	_error_ = NULL;
	{
		char* _tmp11_;
		char* _tmp10_ = NULL;
		char* _tmp9_;
		char* _tmp8_ = NULL;
		char* _tmp7_;
		(g_spawn_command_line_sync (_tmp7_ = g_strconcat ("base64" " ", gtk_entry_get_text (self->file_txt), NULL), &_tmp8_, &_tmp10_, &exit_status, &_inner_error_), output = (_tmp9_ = _tmp8_, _g_free0 (output), _tmp9_));
		_error_ = (_tmp11_ = _tmp10_, _g_free0 (_error_), _tmp11_);
		_g_free0 (_tmp7_);
		if (_inner_error_ != NULL) {
			if (_inner_error_->domain == G_SPAWN_ERROR) {
				goto __catch12_g_spawn_error;
			}
			_g_object_unref0 (file);
			_g_free0 (raw_data);
			_g_free0 (content_type);
			_g_hash_table_unref0 (hash);
			G_IS_VALUE (&type) ? (g_value_unset (&type), NULL) : NULL;
			G_IS_VALUE (&name) ? (g_value_unset (&name), NULL) : NULL;
			_g_free0 (output);
			_g_free0 (_error_);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
	goto __finally12;
	__catch12_g_spawn_error:
	{
		GError * e;
		e = _inner_error_;
		_inner_error_ = NULL;
		{
			gtk_widget_hide_all ((GtkWidget*) self->vbox3);
			_g_error_free0 (e);
			_g_object_unref0 (file);
			_g_free0 (raw_data);
			_g_free0 (content_type);
			_g_hash_table_unref0 (hash);
			G_IS_VALUE (&type) ? (g_value_unset (&type), NULL) : NULL;
			G_IS_VALUE (&name) ? (g_value_unset (&name), NULL) : NULL;
			_g_free0 (output);
			_g_free0 (_error_);
			return;
		}
	}
	__finally12:
	if (_inner_error_ != NULL) {
		_g_object_unref0 (file);
		_g_free0 (raw_data);
		_g_free0 (content_type);
		_g_hash_table_unref0 (hash);
		G_IS_VALUE (&type) ? (g_value_unset (&type), NULL) : NULL;
		G_IS_VALUE (&name) ? (g_value_unset (&name), NULL) : NULL;
		_g_free0 (output);
		_g_free0 (_error_);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	g_hash_table_insert (hash, g_strdup ("name"), __g_value_dup0 (&name));
	g_hash_table_insert (hash, g_strdup ("type"), __g_value_dup0 (&type));
	g_hash_table_insert (hash, g_strdup ("bits"), (_tmp12_ = g_new0 (GValue, 1), g_value_init (_tmp12_, G_TYPE_STRING), g_value_set_string (_tmp12_, output), _tmp12_));
	gtk_widget_show_all ((GtkWidget*) self->progressbar);
	self->vid = g_timeout_add_full (G_PRIORITY_HIGH, (guint) 200, _lekhonee_main_update_bar_gsource_func, g_object_ref (self), g_object_unref);
	gtk_progress_bar_set_text (self->progressbar, _ ("Uploading file to the server"));
	mes = wordpress_upload_file (self->wp, hash);
	if (self->source_flag) {
		GtkTextIter _tmp13_ = {0};
		GtkTextIter start;
		GtkTextIter _tmp14_ = {0};
		GtkTextIter end;
		char* text;
		char* _result_;
		start = (_tmp13_);
		end = (_tmp14_);
		gtk_text_buffer_get_selection_bounds ((GtkTextBuffer*) self->blog_txt, &start, &end);
		text = g_strdup (gtk_text_buffer_get_text ((GtkTextBuffer*) self->blog_txt, &start, &end, FALSE));
		gtk_text_buffer_delete ((GtkTextBuffer*) self->blog_txt, &start, &end);
		_result_ = g_strconcat ("<a href=\"", string_to_string (mes), "\">", string_to_string (text), "</a>", NULL);
		gtk_text_buffer_insert_at_cursor ((GtkTextBuffer*) self->blog_txt, _result_, (gint) strlen (_result_));
		_g_free0 (text);
		_g_free0 (_result_);
	} else {
		char* _result_;
		_result_ = g_strconcat ("document.execCommand('createLink', true, '", string_to_string (mes), "');", NULL);
		webkit_web_view_execute_script (self->editor, _result_);
		_g_free0 (_result_);
	}
	gtk_widget_hide_all ((GtkWidget*) self->vbox3);
	g_source_remove (self->vid);
	gtk_progress_bar_set_fraction (self->progressbar, 0.0);
	gtk_progress_bar_set_text (self->progressbar, "");
	gtk_widget_hide_all ((GtkWidget*) self->progressbar);
	_g_object_unref0 (file);
	_g_free0 (raw_data);
	_g_free0 (content_type);
	_g_hash_table_unref0 (hash);
	G_IS_VALUE (&type) ? (g_value_unset (&type), NULL) : NULL;
	G_IS_VALUE (&name) ? (g_value_unset (&name), NULL) : NULL;
	_g_free0 (output);
	_g_free0 (_error_);
	_g_free0 (mes);
}


void lekhonee_main_on_publish_cb (LekhoneeMain* self, GtkButton* b) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (b != NULL);
	lekhonee_main_message_post (self, TRUE);
	return;
}


void lekhonee_main_on_draft_cb (LekhoneeMain* self, GtkButton* b) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (b != NULL);
	lekhonee_main_message_post (self, FALSE);
	return;
}


static char* string_strip (const char* self) {
	char* result = NULL;
	char* _result_;
	g_return_val_if_fail (self != NULL, NULL);
	_result_ = g_strdup (self);
	g_strstrip (_result_);
	result = _result_;
	return result;
}


static gpointer _gtk_tree_path_copy0 (gpointer self) {
	return self ? gtk_tree_path_copy (self) : NULL;
}


static void _g_list_free_gtk_tree_path_free (GList* self) {
	g_list_foreach (self, (GFunc) gtk_tree_path_free, NULL);
	g_list_free (self);
}


void lekhonee_main_message_post (LekhoneeMain* self, gboolean publish) {
	GValue desc = {0};
	char* inter_desc;
	GValue _tmp4_;
	GValue _tmp3_ = {0};
	GValue _tmp5_ = {0};
	GValue title;
	GHashTable* hash;
	char** _tmp7_;
	gint _tags_size_;
	gint tags_length1;
	char** _tmp6_;
	char** tags;
	GValueArray* mtags;
	GValueArray* cats;
	GtkTreeSelection* sect;
	GtkTreeModel* model;
	GtkTreeIter iter = {0};
	GtkTreeModel* _tmp13_;
	GList* _tmp12_;
	GtkTreeModel* _tmp11_ = NULL;
	GList* slist;
	GObject* _tmp18_;
	GtkCheckButton* comment_box;
	GValue _tmp19_ = {0};
	GValue comments;
	GValue* _tmp20_ = NULL;
	GValue* _tmp21_ = NULL;
	char* pid;
	g_return_if_fail (self != NULL);
	if (_vala_strcmp0 (self->wp->server, "") == 0) {
		lekhonee_main_show_error (self, _ ("Select an account first"));
		return;
	}
	inter_desc = g_strdup ("");
	if (self->source_flag) {
		GtkTextIter start = {0};
		GtkTextIter end = {0};
		char* _tmp0_;
		gtk_text_buffer_get_bounds ((GtkTextBuffer*) self->blog_txt, &start, &end);
		inter_desc = (_tmp0_ = g_strdup ((const char*) gtk_text_buffer_get_text ((GtkTextBuffer*) self->blog_txt, &start, &end, FALSE)), _g_free0 (inter_desc), _tmp0_);
	} else {
		char* _tmp2_;
		char* _tmp1_;
		inter_desc = (_tmp2_ = (char*) string_slice (_tmp1_ = lekhonee_main_get_source (self), (glong) 0, (glong) (-7)), _g_free0 (inter_desc), _tmp2_);
		_g_free0 (_tmp1_);
	}
	if (!self->edit_flag) {
	}
	desc = (_tmp4_ = (g_value_init (&_tmp3_, G_TYPE_STRING), g_value_set_string (&_tmp3_, inter_desc), _tmp3_), G_IS_VALUE (&desc) ? (g_value_unset (&desc), NULL) : NULL, _tmp4_);
	title = (g_value_init (&_tmp5_, G_TYPE_STRING), g_value_set_string (&_tmp5_, (const char*) gtk_entry_get_text (self->title_entry)), _tmp5_);
	hash = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, g_free);
	tags = (_tmp7_ = _tmp6_ = g_strsplit (gtk_entry_get_text (self->tags_entry), ",", 0), tags_length1 = _vala_array_length (_tmp6_), _tags_size_ = tags_length1, _tmp7_);
	mtags = g_value_array_new ((guint) 1);
	{
		char** x_collection;
		int x_collection_length1;
		int x_it;
		x_collection = tags;
		x_collection_length1 = tags_length1;
		for (x_it = 0; x_it < tags_length1; x_it = x_it + 1) {
			char* x;
			x = g_strdup (x_collection[x_it]);
			{
				GValue _tmp10_;
				GValue _tmp9_ = {0};
				char* _tmp8_;
				g_value_array_append (mtags, (_tmp10_ = (g_value_init (&_tmp9_, G_TYPE_STRING), g_value_take_string (&_tmp9_, _tmp8_ = string_strip (x)), _tmp9_), &_tmp10_));
				_g_free0 (_tmp8_);
				_g_free0 (x);
			}
		}
	}
	cats = g_value_array_new ((guint) 1);
	sect = _g_object_ref0 (gtk_tree_view_get_selection (self->category_list));
	model = NULL;
	slist = (_tmp12_ = gtk_tree_selection_get_selected_rows (sect, &_tmp11_), model = (_tmp13_ = _g_object_ref0 (_tmp11_), _g_object_unref0 (model), _tmp13_), _tmp12_);
	{
		GList* sec_collection;
		GList* sec_it;
		sec_collection = slist;
		for (sec_it = sec_collection; sec_it != NULL; sec_it = sec_it->next) {
			GtkTreePath* sec;
			sec = _gtk_tree_path_copy0 ((GtkTreePath*) sec_it->data);
			{
				GValue v = {0};
				GValue _tmp15_;
				GValue _tmp14_ = {0};
				GValue _tmp17_;
				GValue _tmp16_ = {0};
				gtk_tree_model_get_iter (model, &iter, sec);
				g_value_init (&v, G_TYPE_STRING);
				gtk_tree_model_get_value ((GtkTreeModel*) self->liststore, &iter, 0, &_tmp14_);
				v = (_tmp15_ = _tmp14_, G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL, _tmp15_);
				g_value_array_append (cats, (_tmp17_ = (g_value_init (&_tmp16_, G_TYPE_STRING), g_value_set_string (&_tmp16_, g_value_get_string (&v)), _tmp16_), &_tmp17_));
				_gtk_tree_path_free0 (sec);
				G_IS_VALUE (&v) ? (g_value_unset (&v), NULL) : NULL;
			}
		}
	}
	comment_box = _g_object_ref0 ((_tmp18_ = gtk_builder_get_object (self->builder, "comment_box"), GTK_IS_CHECK_BUTTON (_tmp18_) ? ((GtkCheckButton*) _tmp18_) : NULL));
	comments = (g_value_init (&_tmp19_, G_TYPE_BOOLEAN), g_value_set_boolean (&_tmp19_, gtk_toggle_button_get_active ((GtkToggleButton*) comment_box)), _tmp19_);
	g_hash_table_insert (hash, g_strdup ("title"), __g_value_dup0 (&title));
	g_hash_table_insert (hash, g_strdup ("description"), __g_value_dup0 (&desc));
	g_hash_table_insert (hash, g_strdup ("mt_keywords"), (_tmp20_ = g_new0 (GValue, 1), g_value_init (_tmp20_, G_TYPE_VALUE_ARRAY), g_value_set_boxed (_tmp20_, mtags), _tmp20_));
	g_hash_table_insert (hash, g_strdup ("categories"), (_tmp21_ = g_new0 (GValue, 1), g_value_init (_tmp21_, G_TYPE_VALUE_ARRAY), g_value_set_boxed (_tmp21_, cats), _tmp21_));
	g_hash_table_insert (hash, g_strdup ("mt_allow_comments"), __g_value_dup0 (&comments));
	gtk_widget_show_all ((GtkWidget*) self->progressbar);
	self->vid = g_timeout_add_full (G_PRIORITY_HIGH, (guint) 200, _lekhonee_main_update_bar_gsource_func, g_object_ref (self), g_object_unref);
	gtk_progress_bar_set_text (self->progressbar, _ ("posting to the server"));
	pid = NULL;
	if (self->edit_flag) {
		char* postid;
		GHashTable* oldhash;
		GValue _tmp22_ = {0};
		GValue val;
		char* _tmp23_;
		char* _tmp24_;
		postid = NULL;
		oldhash = _g_hash_table_ref0 (g_value_get_boxed (&self->entry));
		val = G_IS_VALUE ((GValue*) g_hash_table_lookup (oldhash, "postid")) ? (g_value_init (&_tmp22_, G_VALUE_TYPE ((GValue*) g_hash_table_lookup (oldhash, "postid"))), g_value_copy ((GValue*) g_hash_table_lookup (oldhash, "postid"), &_tmp22_), _tmp22_) : (*((GValue*) g_hash_table_lookup (oldhash, "postid")));
		postid = (_tmp23_ = g_strdup (g_value_get_string (&val)), _g_free0 (postid), _tmp23_);
		pid = (_tmp24_ = wordpress_update (self->wp, postid, hash, publish), _g_free0 (pid), _tmp24_);
		_g_free0 (postid);
		_g_hash_table_unref0 (oldhash);
		G_IS_VALUE (&val) ? (g_value_unset (&val), NULL) : NULL;
	} else {
		char* _tmp25_;
		pid = (_tmp25_ = wordpress_post (self->wp, hash, publish), _g_free0 (pid), _tmp25_);
	}
	if (_vala_strcmp0 (pid, "None") != 0) {
		char* _tmp26_;
		GtkMessageDialog* _tmp27_;
		GtkMessageDialog* dm;
		dm = (_tmp27_ = g_object_ref_sink ((GtkMessageDialog*) gtk_message_dialog_new (self->window, GTK_DIALOG_MODAL, GTK_MESSAGE_INFO, GTK_BUTTONS_OK, _tmp26_ = g_strconcat ("Message posted with ID ", pid, NULL))), _g_free0 (_tmp26_), _tmp27_);
		gtk_dialog_run ((GtkDialog*) dm);
		gtk_object_destroy ((GtkObject*) dm);
		_g_object_unref0 (dm);
	}
	g_source_remove (self->vid);
	gtk_progress_bar_set_text (self->progressbar, "");
	gtk_progress_bar_set_fraction (self->progressbar, 0.0);
	gtk_widget_hide_all ((GtkWidget*) self->progressbar);
	lekhonee_main_clear_it (self);
	self->edit_flag = FALSE;
	G_IS_VALUE (&desc) ? (g_value_unset (&desc), NULL) : NULL;
	_g_free0 (inter_desc);
	G_IS_VALUE (&title) ? (g_value_unset (&title), NULL) : NULL;
	_g_hash_table_unref0 (hash);
	tags = (_vala_array_free (tags, tags_length1, (GDestroyNotify) g_free), NULL);
	_g_value_array_free0 (mtags);
	_g_value_array_free0 (cats);
	_g_object_unref0 (sect);
	_g_object_unref0 (model);
	__g_list_free_gtk_tree_path_free0 (slist);
	_g_object_unref0 (comment_box);
	G_IS_VALUE (&comments) ? (g_value_unset (&comments), NULL) : NULL;
	_g_free0 (pid);
}


void lekhonee_main_open_file_cb (LekhoneeMain* self, GtkMenuItem* i) {
	char* title;
	char* desc;
	char* tags;
	GtkFileChooserDialog* chooser;
	GtkFileFilter* filter;
	g_return_if_fail (self != NULL);
	g_return_if_fail (i != NULL);
	title = g_strdup ("");
	desc = g_strdup ("");
	tags = g_strdup ("");
	chooser = g_object_ref_sink ((GtkFileChooserDialog*) gtk_file_chooser_dialog_new ("Open Post", self->window, GTK_FILE_CHOOSER_ACTION_OPEN, GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL, GTK_STOCK_OPEN, GTK_RESPONSE_ACCEPT, NULL, NULL));
	gtk_file_chooser_set_do_overwrite_confirmation ((GtkFileChooser*) chooser, TRUE);
	gtk_file_chooser_set_current_folder ((GtkFileChooser*) chooser, g_get_home_dir ());
	filter = g_object_ref_sink (gtk_file_filter_new ());
	gtk_file_filter_set_name (filter, "Lekhonee files");
	gtk_file_filter_add_pattern (filter, "*.lekhonee");
	gtk_file_chooser_add_filter ((GtkFileChooser*) chooser, filter);
	if (gtk_dialog_run ((GtkDialog*) chooser) == GTK_RESPONSE_ACCEPT) {
		char* filename;
		char* _tmp5_;
		char* _tmp4_ = NULL;
		char* _tmp3_;
		char* _tmp2_ = NULL;
		char* _tmp1_;
		char* _tmp0_ = NULL;
		filename = gtk_file_chooser_get_filename ((GtkFileChooser*) chooser);
		((xml_open_file (filename, &_tmp0_, &_tmp2_, &_tmp4_), title = (_tmp1_ = _tmp0_, _g_free0 (title), _tmp1_)), desc = (_tmp3_ = _tmp2_, _g_free0 (desc), _tmp3_));
		tags = (_tmp5_ = _tmp4_, _g_free0 (tags), _tmp5_);
		_g_free0 (filename);
	}
	gtk_entry_set_text (self->title_entry, title);
	gtk_entry_set_text (self->tags_entry, tags);
	webkit_web_view_load_string (self->editor, desc, "text/html", "utf-8", "preview");
	gtk_object_destroy ((GtkObject*) chooser);
	_g_free0 (title);
	_g_free0 (desc);
	_g_free0 (tags);
	_g_object_unref0 (chooser);
	_g_object_unref0 (filter);
}


void lekhonee_main_save_file_cb (LekhoneeMain* self, GtkMenuItem* i) {
	GtkFileChooserDialog* chooser;
	GtkFileFilter* filter;
	g_return_if_fail (self != NULL);
	g_return_if_fail (i != NULL);
	chooser = g_object_ref_sink ((GtkFileChooserDialog*) gtk_file_chooser_dialog_new ("Save Post", self->window, GTK_FILE_CHOOSER_ACTION_SAVE, GTK_STOCK_CANCEL, GTK_RESPONSE_CANCEL, GTK_STOCK_SAVE, GTK_RESPONSE_ACCEPT, NULL, NULL));
	gtk_file_chooser_set_do_overwrite_confirmation ((GtkFileChooser*) chooser, TRUE);
	gtk_file_chooser_set_current_folder ((GtkFileChooser*) chooser, g_get_home_dir ());
	filter = g_object_ref_sink (gtk_file_filter_new ());
	gtk_file_filter_set_name (filter, "Lekhonee files");
	gtk_file_filter_add_pattern (filter, "*.lekhonee");
	gtk_file_chooser_add_filter ((GtkFileChooser*) chooser, filter);
	if (gtk_dialog_run ((GtkDialog*) chooser) == GTK_RESPONSE_ACCEPT) {
		char* title;
		char* desc;
		char* tags;
		char* filename;
		char* oldname;
		char* _tmp3_;
		title = g_strdup (gtk_entry_get_text (self->title_entry));
		desc = NULL;
		if (self->source_flag) {
			GtkTextIter start = {0};
			GtkTextIter end = {0};
			char* _tmp0_;
			gtk_text_buffer_get_bounds ((GtkTextBuffer*) self->blog_txt, &start, &end);
			desc = (_tmp0_ = g_strdup (gtk_text_buffer_get_text ((GtkTextBuffer*) self->blog_txt, &start, &end, FALSE)), _g_free0 (desc), _tmp0_);
		} else {
			char* _tmp2_;
			char* _tmp1_;
			desc = (_tmp2_ = string_slice (_tmp1_ = lekhonee_main_get_source (self), (glong) 0, (glong) (-7)), _g_free0 (desc), _tmp2_);
			_g_free0 (_tmp1_);
		}
		tags = g_strdup (gtk_entry_get_text (self->tags_entry));
		filename = NULL;
		oldname = NULL;
		oldname = (_tmp3_ = gtk_file_chooser_get_filename ((GtkFileChooser*) chooser), _g_free0 (oldname), _tmp3_);
		if (oldname != NULL) {
			char* _tmp4_;
			filename = (_tmp4_ = g_strdup ((const char*) oldname), _g_free0 (filename), _tmp4_);
			if (!g_str_has_suffix (filename, ".lekhonee")) {
				char* _tmp5_;
				filename = (_tmp5_ = g_strconcat (filename, ".lekhonee", NULL), _g_free0 (filename), _tmp5_);
			}
		} else {
			gtk_object_destroy ((GtkObject*) chooser);
			_g_free0 (title);
			_g_free0 (desc);
			_g_free0 (tags);
			_g_free0 (filename);
			_g_free0 (oldname);
			_g_object_unref0 (chooser);
			_g_object_unref0 (filter);
			return;
		}
		xml_save_file (filename, title, desc, tags);
		_g_free0 (title);
		_g_free0 (desc);
		_g_free0 (tags);
		_g_free0 (filename);
		_g_free0 (oldname);
	}
	gtk_object_destroy ((GtkObject*) chooser);
	_g_object_unref0 (chooser);
	_g_object_unref0 (filter);
}


gboolean lekhonee_main_navigation_requested (LekhoneeMain* self, WebKitWebFrame* p0, WebKitNetworkRequest* p1, WebKitWebNavigationAction* p2, WebKitWebPolicyDecision* p3) {
	gboolean result = FALSE;
	char* uri;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (p0 != NULL, FALSE);
	g_return_val_if_fail (p1 != NULL, FALSE);
	g_return_val_if_fail (p2 != NULL, FALSE);
	g_return_val_if_fail (p3 != NULL, FALSE);
	uri = g_strdup (webkit_network_request_get_uri (p1));
	if (_vala_strcmp0 (uri, "preview") == 0) {
		result = FALSE;
		_g_free0 (uri);
		return result;
	}
	result = TRUE;
	_g_free0 (uri);
	return result;
}


static void _lekhonee_main_on_quit_response_gtk_dialog_response (GtkDialog* _sender, gint response_id, gpointer self) {
	lekhonee_main_on_quit_response (self, _sender, response_id);
}


void lekhonee_main_quit (LekhoneeMain* self, GtkObject* o) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (o != NULL);
	if (lekhonee_main_check_exit (self)) {
		GtkMessageDialog* dm;
		dm = g_object_ref_sink ((GtkMessageDialog*) gtk_message_dialog_new (self->window, GTK_DIALOG_MODAL, GTK_MESSAGE_INFO, GTK_BUTTONS_OK_CANCEL, _ ("Are you sure to quit lekhonee-gnome without posting the current post?")));
		g_signal_connect_object ((GtkDialog*) dm, "response", (GCallback) _lekhonee_main_on_quit_response_gtk_dialog_response, self, 0);
		gtk_dialog_run ((GtkDialog*) dm);
		gtk_object_destroy ((GtkObject*) dm);
		_g_object_unref0 (dm);
	} else {
		gtk_main_quit ();
	}
}


void lekhonee_main_on_quit_response (LekhoneeMain* self, GtkDialog* source, gint response_id) {
	g_return_if_fail (self != NULL);
	g_return_if_fail (source != NULL);
	switch (response_id) {
		case GTK_RESPONSE_OK:
		{
			gtk_main_quit ();
			break;
		}
	}
}


gboolean lekhonee_main_on_delete_event (LekhoneeMain* self, GtkWidget* w, GdkEvent* e) {
	gboolean result = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (w != NULL, FALSE);
	g_return_val_if_fail (e != NULL, FALSE);
	lekhonee_main_quit (self, (GtkObject*) self->refresh_bttn);
	result = TRUE;
	return result;
}


gint lekhonee_main_main (char** args, int args_length1) {
	gint result = 0;
	LekhoneeMain* lh;
	gtk_init (&args_length1, &args);
	lh = lekhonee_main_new ();
	gtk_main ();
	result = 0;
	_g_object_unref0 (lh);
	return result;
}


int main (int argc, char ** argv) {
	g_thread_init (NULL);
	g_type_init ();
	return lekhonee_main_main (argv, argc);
}


static void lekhonee_main_class_init (LekhoneeMainClass * klass) {
	lekhonee_main_parent_class = g_type_class_peek_parent (klass);
	LEKHONEE_MAIN_CLASS (klass)->change_view = lekhonee_main_real_change_view;
	G_OBJECT_CLASS (klass)->finalize = lekhonee_main_finalize;
}


static void lekhonee_main_instance_init (LekhoneeMain * self) {
}


static void lekhonee_main_finalize (GObject* obj) {
	LekhoneeMain * self;
	self = LEKHONEE_MAIN (obj);
	_g_object_unref0 (self->wp);
	_g_object_unref0 (self->builder);
	_g_object_unref0 (self->window);
	_g_object_unref0 (self->category_list);
	_g_object_unref0 (self->entries_list);
	_g_object_unref0 (self->liststore);
	_g_object_unref0 (self->liststore2);
	_g_object_unref0 (self->scw);
	_g_object_unref0 (self->scw2);
	_g_object_unref0 (self->scw3);
	_g_object_unref0 (self->scw5);
	_g_object_unref0 (self->vbox3);
	_g_object_unref0 (self->refresh_bttn);
	_g_object_unref0 (self->htmltags);
	_g_object_unref0 (self->progressbar);
	_g_object_unref0 (self->file_txt);
	_g_object_unref0 (self->accounts);
	_g_object_unref0 (self->account_act);
	_g_object_unref0 (self->pref_dialog);
	_g_object_unref0 (self->blog_txt);
	_g_object_unref0 (self->sourceview);
	_g_object_unref0 (self->notebook);
	_g_object_unref0 (self->editor);
	_g_object_unref0 (self->wsettings);
	_g_object_unref0 (self->previewer);
	_g_object_unref0 (self->title_entry);
	_g_object_unref0 (self->category_entry);
	_g_object_unref0 (self->tags_entry);
	_g_object_unref0 (self->draft_bttn);
	_g_object_unref0 (self->publish_bttn);
	_g_object_unref0 (self->style_bttn);
	_g_object_unref0 (self->spell_box);
	G_IS_VALUE (&self->entry) ? (g_value_unset (&self->entry), NULL) : NULL;
	_0 (self->spell);
	G_OBJECT_CLASS (lekhonee_main_parent_class)->finalize (obj);
}


GType lekhonee_main_get_type (void) {
	static volatile gsize lekhonee_main_type_id__volatile = 0;
	if (g_once_init_enter (&lekhonee_main_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (LekhoneeMainClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) lekhonee_main_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (LekhoneeMain), 0, (GInstanceInitFunc) lekhonee_main_instance_init, NULL };
		GType lekhonee_main_type_id;
		lekhonee_main_type_id = g_type_register_static (G_TYPE_OBJECT, "LekhoneeMain", &g_define_type_info, 0);
		g_once_init_leave (&lekhonee_main_type_id__volatile, lekhonee_main_type_id);
	}
	return lekhonee_main_type_id__volatile;
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}


static int _vala_strcmp0 (const char * str1, const char * str2) {
	if (str1 == NULL) {
		return -(str1 != str2);
	}
	if (str2 == NULL) {
		return str1 != str2;
	}
	return strcmp (str1, str2);
}




