.\" ============================================================
.\"
.\"	 Linux Network Administrators' Guide
.\"		Compilation Guide
.\"
.\"	     Copyright 1994 O. Kirch
.\"
.\" ============================================================
.\" This document requires the GNU mm macro package.
.\" 
.PH "''''
.po 3n
.ll 70m
.ce 100
The Linux Network Administrators' Guide

Olaf Kirch, <okir@monad.swb.de>
Linux Documentation Project


18. Aug. 1994
Release 1.0
.ce 0
.sp 1c
.PH "'Networking Guide 1.0''Release Notes'
.PF "''- % -''
.P
Welcome to the public release of the new Linux Network Administrators'
Guide!  After one year of work in (well, almost) seclusion, I'm proud
to present you a completely revised, greatly improved and expanded
Networking Guide.
.P
.\" ============================================================
.H 1 "What's In It?
.\" ============================================================
The new NAG is an almost complete rewrite of the version I released 
almost exactly one year ago.  It features several new chapters,
including the setup of SLIP, PPP, and NIS. It also has a
complete sendmail chapter now, written by Vince Skahan.
.P
The NAG is written mainly for networking rookies (as I have been when
I started this project almost two years ago), but I hope it will be
useful to more experienced networkers alike. It explains everything in
pretty much detail, beginning with the basics of networking and slowly
working its way up to the configuration of mail and news, covering
both the setup of TCP/IP-based services and UUCP. The following list
shows the table of contents:
.P
.BL
.LI 
	Preface
.LI 
	Introduction to Networking
.LI 
	Issues of TCP/IP Networking
.LI 
	Configuring the Networking Hardware
.LI 
	Setting up the Serial Hardware
.LI 
	Configuring TCP/IP Networking
.LI 
	Name Service and Resolver Configuraton
.LI 
	Serial Line IP
.LI 
	The Point-to-Point Protocol
.LI 
	Various Network Applications
.LI 
	The Network Information System
.LI 
	The Network File System
.LI 
	Managing Taylor UUCP
.LI 
	Electronic Mail
.LI 
	Getting smail Up and Running
.LI 
	Sendmail+IDA
.LI 
	Netnews
.LI 
	C News
.LI 
	A Description of NNTP
.LI 
	Newsreader Configuration
.LI 
	Glossary
.LI 
	Annotated Bibliography
.LE
.P
The level of detail comes at a certain cost, which is the size of the
book. When running it through LaTeX, it comes out at around 350 pages
at the moment, counting table of contents, glossary, and index. This
is quite a bit. I hope you'll enjoy it nevertheless.
.P
.\" ============================================================
.H 1 "With a little help...
.\" ============================================================
The NAG wouldn't be what it is today if it wasn't for the involvement
of O'Reilly and Associates in this project, who are going to publish
the Official Printed Version of the NAG some time later this year.
Since December 1993, I've been working with Andy Oram at O'Reilly who
read everything I wrote, and sent me countless reviews, so much of the
quality in this book is actually due to him.
.P
Still, the NAG will remain freely distributable under the Linux
Documentation Project's License, just the way the previous release
was. Thus, no-one will be shut off; rather, you will be able to
choose between the online version and a high-quality printed version.
.\" ============================================================
.H 1 "Obtaining the NAG
.\" ============================================================
The NAG is available both as LaTeX source, and preformatted in several
ways. The primary FTP sites are
.P
.in 3c
\fBsunsite.unc.edu:/pub/Linux/docs/LDP\fP
.br
\fBtsx-11.mit.edu:/pub/linux/docs/LDP\fP
.br
.in -3c
.P
The following packages are available:
.BL
.LI \fBnag-1.0.tar.gz\fR
This file contains the LaTeX source of the NAG. I've tried to make it
as portable as possible, so I do hope it will compile cleanly on most
LaTeX installations.  Some nuances of the DVI and Postscript output
can be controlled by a configuration file which allows you, among
other things, to select a tighter printing which reduces the size of
the printed book by almost 100 pages. For details, please refer to
the installation notes in that archive.
.\" ----------------------------------------------------------------
.LI \fBnag-dvi-1.0.tar.gz\fR
This file contains the preformatted DVI output of the NAG, suitable
for printing on US Letter paper. All figures in the NAG are done
using using xfig, from which I generated epic/eepic output for the
DVI version. The eepic macros rely on some LaTeX \\special's that
some DVI printer drivers may not have implemented. If you don't see
any figures on your printout, or get pages full of error messages
about \\special's not supported while printing the NAG, your best
option may be this: Convert the DVI file to PostScript and print the
offending pages from using ghostcsript.
.\" ----------------------------------------------------------------
.LI \fBnag-ps-1.0.tar.gz\fR
This file contains the preformatted PostScript output of the
NAG, again suitable for printing on Letter Paper. This should be
almost painless to use.
.\" ----------------------------------------------------------------
.LI \fBnag-ascii-1.0.tar.gz\fR
This is the ASCII version, which is provided for the benefit of those
without the disk space or printer capabilities to handle a full
TeX or ghostcript installation. As things go with ASCII, the output is
not very high quality, will eat horrendous amounts of paper when actually
printing it (close to 400 pages), and doesn't have any figures
(anybody who is willing to try his or her hand on ASCII art is very
welcome).
.LE
.P
All these files are gzipped tar archives.
.\" ----------------------------------------------------------------
.H 1 Feedback
.\" ----------------------------------------------------------------
If you have complaints, suggestions, fixes, or questions, please mail
me at the address given above. However, let me say a word about
`bug' reporting: if you have fixes to the NAG itself,
please don't use references like `page 87, second paragraph', but
rather give me a section number, or even a detailed description like
`In the mount section of the NFS chapter'. Although I \fImay\fR find the
sentence you refer to when you use page numbers, there's no guarantee
the mistake you spotted is anywhere close to that page on my printed
copy.
.P
I hope I didn't forget anything,
.br
Enjoy
.br
\h'4c'Olaf Kirch
