/*
 * $Id: Cns_constants.h 9431 2013-09-11 19:56:02Z dhsmith $
 */

/*
 * Copyright (C) 1999-2010 by CERN/IT/PDP/DM
 * All rights reserved
 */

/*
 * @(#)$RCSfile: Cns_constants.h,v $ $Revision: 9431 $ $Date: 2013-09-11 21:56:02 +0200 (Wed, 11 Sep 2013) $ CERN IT-PDP/DM Jean-Philippe Baud
 */

#ifndef _CNS_CONSTANTS_H
#define _CNS_CONSTANTS_H
#include "Castor_limits.h"

#define DIRXSIZE (HYPERSIZE+WORDSIZE+LONGSIZE+LONGSIZE+LONGSIZE+HYPERSIZE+TIME_TSIZE+TIME_TSIZE+TIME_TSIZE+WORDSIZE+BYTESIZE)
#define DIRGSIZE (HYPERSIZE+CA_MAXGUIDLEN+1+WORDSIZE+LONGSIZE+LONGSIZE+LONGSIZE+HYPERSIZE+TIME_TSIZE+TIME_TSIZE+TIME_TSIZE+WORDSIZE+BYTESIZE+3+33)
#define DIRXTSIZE (HYPERSIZE+WORDSIZE+WORDSIZE+HYPERSIZE+LONGSIZE+1+CA_MAXVIDLEN+1+LONGSIZE+4)
#define DIRXT2SIZE (HYPERSIZE+WORDSIZE+WORDSIZE+HYPERSIZE+LONGSIZE+1+CA_MAXVIDLEN+1+WORDSIZE+LONGSIZE+4)
#define DIRXT3SIZE (HYPERSIZE+HYPERSIZE+WORDSIZE+WORDSIZE+HYPERSIZE+LONGSIZE+1+CA_MAXVIDLEN+1+WORDSIZE+LONGSIZE+4)
#define LISTCSIZE (LONGSIZE+CA_MAXCLASNAMELEN+1+LONGSIZE+LONGSIZE+LONGSIZE+LONGSIZE+LONGSIZE+LONGSIZE+LONGSIZE+LONGSIZE+LONGSIZE+LONGSIZE+LONGSIZE+LONGSIZE)
#define LISTLSIZE (CA_MAXPATHLEN+1)
#define LISTRSIZE (HYPERSIZE+TIME_TSIZE+CA_MAXHOSTNAMELEN+1+CA_MAXSFNLEN+1)
#define LISTR2SIZE (HYPERSIZE+HYPERSIZE+TIME_TSIZE+TIME_TSIZE+2+CA_MAXPOOLNAMELEN+1+CA_MAXHOSTNAMELEN+1+80+CA_MAXSFNLEN+1)
#define LISTRSSIZE (HYPERSIZE+HYPERSIZE+TIME_TSIZE+TIME_TSIZE+TIME_TSIZE+TIME_TSIZE+3+37+CA_MAXPOOLNAMELEN+1+CA_MAXHOSTNAMELEN+1+80)
#define LISTRXSIZE (HYPERSIZE+HYPERSIZE+TIME_TSIZE+TIME_TSIZE+2+CA_MAXPOOLNAMELEN+1+CA_MAXHOSTNAMELEN+1+80)

#define CNS_PORT 5010

		/* constants used for setting retention period on disk */

#define	AS_LONG_AS_POSSIBLE	0x7FFFFFFF
#define	INFINITE_LIFETIME	0x7FFFFFFE

			/* ACL types */

#define CNS_ACL_USER_OBJ	1
#define CNS_ACL_USER		2
#define CNS_ACL_GROUP_OBJ	3
#define CNS_ACL_GROUP		4
#define CNS_ACL_MASK		5
#define CNS_ACL_OTHER		6
#define CNS_ACL_DEFAULT		0x20

			/* path parsing options */

#define CNS_MUST_EXIST	1
#define CNS_NOFOLLOW	2

			/* select server options */

#define CNS_SSRV_NOTPATH	1

                        /* User/group statuses */

#define ARGUS_BAN	1
#define LOCAL_BAN	2

			/* long options for Cns utilities */

#define	OPT_CLASS_GID	0
#define	OPT_CLASS_GROUP	1
#define	OPT_CLASS_ID	2
#define	OPT_CLASS_NAME	3
#define	OPT_CLASS_UID	4
#define	OPT_CLASS_USER	5
#define	OPT_FLAGS	6
#define	OPT_MAX_DRV	7
#define	OPT_MAX_FSZ	8
#define	OPT_MAX_SSZ	9
#define	OPT_MIGR_INTV	10
#define	OPT_MIN_FSZ	11
#define	OPT_MIN_TIME	12
#define	OPT_NBCOPIES	13
#define	OPT_NEW_C_NAME	14
#define	OPT_RETENP_DISK	15
#define	OPT_TPPOOLS	16
#define	OPT_IDMAP_GID	17
#define	OPT_IDMAP_GROUP	18
#define	OPT_IDMAP_UID	17
#define	OPT_IDMAP_USER	18
#define	OPT_IDMAP_STATUS 19

			/* name server utilities exit codes */

#define	USERR	  1	/* user error */
#define	SYERR 	  2	/* system error */
#define	CONFERR	  4	/* configuration error */
#endif
