/*

   Copyright (C) 2001,2002,2003,2004 Michael Rubinstein

   This file is part of the L-function package L.

   This program is free software; you can redistribute it and/or
   modify it under the terms of the GNU General Public License
   as published by the Free Software Foundation; either version 2
   of the License, or (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   Check the License for details. You should have received a copy of it, along
   with the package; see the file 'COPYING'. If not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

*/


#ifndef Lglobals_H
#define Lglobals_H

using namespace std;

#include <valarray>
#ifdef USE_MPFR
    #include "Lgmpfrxx.h"
    typedef mpfr_class Double;
#else
    #ifdef USE_LONG_DOUBLE
    typedef long double Double;
    #else
    typedef double Double;
    #endif
#endif

#include "Lcomplex.h"     //for complex numbers
//#include <complex>     //for complex numbers
typedef complex<Double> Complex;

#ifdef USE_LONG_DOUBLE
    #include "Lcommon_ld.h"
#else
    #include "Lcommon.h"
#endif

#include<limits>
#include<iostream>

//#include "Lint_complex.h"
#include <math.h>

//--------Incomplete gamma function global variables--------

extern Complex last_z;         // the last z to be considered in inc_GAMMA
extern Complex last_w;         // the last w to be considered in inc_GAMMA
extern Complex last_comp_inc_GAMMA; // g(last_z,last_w)

extern Complex last_z_GAMMA;  //the last z to be considered in GAMMA
extern Complex last_log_G;    //the last log(GAMMA(z));

extern Double temme_a[1002],temme_g[501];

//used in Temme's asymptotic expansion of the
//incomplete gamma function
//XXXX might need more terms if I go to higher precision


//-----Constants----------------------------------------------
extern Double Pi;
extern Double log_2Pi;
extern Complex I;


//-----Global variables----------------------------------------
extern int my_verbose;       // verbosity level: 0 means no verbose

extern int DIGITS, DIGITS2; // precision and sacrifice
extern int DIGITS3; // how many digits to output
extern Double tolerance;
extern Double tolerance_sqrd;
extern Double tolerance2;
extern Double tolerance3;

extern int global_derivative;  //used to specify which derivative to compute

extern int max_n; //the largest n used in a dirichlet series while computing a value

extern Double A; //controls the 'support' of g(w) in Riemann sum method
extern Double incr; //the increment in the Riemann sum method

extern Double *LG;         // lookup table for log(n)
extern Double *two_inverse_SQUARE_ROOT;         // lookup table for sqrt(n)
extern int number_sqrts;    // how many sqrt(n)'s to store
extern int number_logs;    // how many log(n)'s to store

extern Double *bernoulli;  // lookup table for bernoulli numbers

extern bool print_warning;

extern Long my_LLONG_MAX;


//-----intializing and cleaning up routines----------------------

void initialize_globals(int n=200);
void delete_globals();

void extend_LG_table(int m);
void extend_sqrt_table(int m);

//----- used in one of the gamma routines. put it here since it is called
//----- during initialize_globals

Double dfac(int i);

inline Double my_norm(Complex z)
{
    return(real(z*conj(z)));
}

#endif
