#!/bin/sh -e
# Copyright (c) 2002-2003 Martin A. Godisch <martin@godisch.de>

test -e latrine.c
umask 022
aclocal -I /usr/share/autoconf-archive
autoheader -Wall
autoconf -Wall
./configure
make mo distclean
cd ..
chmod -R go=u-w .
version="`pwd`"
version="${version##*-}"
tarname="latrine-${version}.tar.gz"
cd ..
fakeroot tar cvzf $tarname --exclude CVS --exclude .cvsignore --exclude debian latrine-$version
ln -sf $tarname latrine_$version.orig.tar.gz
cd latrine-$version
if ! grep -iq "AC_INIT.*[${version}]" src/configure.ac; then
	echo "*** WARNING: version in configure.ac out of date  ***"
fi
if grep -iq "not yet released" CHANGES; then
	echo "*** WARNING: release date in CHANGES file missing ***"
fi
if grep -iq "^${version}:" TODO; then
	echo "*** WARNING: current version in TODO file present ***"
fi
for i in src/po/??.po; do
	if grep -iq "fuzzy" $i; then
		echo "*** WARNING: fuzzy strings in $i   ***"
	fi
done
cd ..
echo -n "Sign $tarname? [y/N] "
read sign
if test "$sign" = y; then
	gpg -ab $tarname
else
	echo "No."
fi
