package latexDraw.ui.dialog;

import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;

import javax.swing.*;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import javax.swing.event.ChangeEvent;

import latexDraw.figures.BezierCurve;
import latexDraw.figures.Figure;
import latexDraw.lang.LaTeXDrawLang;
import latexDraw.psTricks.PSTricksConstants;
import latexDraw.ui.DrawPanel;
import latexDraw.ui.components.LaTeXDrawComboBox;
import latexDraw.util.LaTeXDrawPoint2D;


/** 
 * This class defines the frame which allows to modify a Bézier curve.<br>
 *<br>
 * This file is part of LaTeXDraw<br>
 * Copyright (c) 2005-2008 Arnaud BLOUIN<br>
 *<br>
 *  LaTeXDraw is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  any later version.<br>
 *<br>
 *  LaTeXDraw is distributed without any warranty; without even the 
 *  implied warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR 
 *  PURPOSE. See the GNU General Public License for more details.<br>
 *<br>
 * 01/20/06<br>
 * @author Arnaud BLOUIN<br>
 * @version 2.0.0<br>
 */
public class ParametersBezierCurveFrame extends ParametersPolygonJoinedLinesFrame
{
	private static final long serialVersionUID = 1L;

	/** Allows to show or to hide the control points of the Bézier curve */
	protected JCheckBox showPointsCB;
	
	/** The current X-coordinates of the control point field */
	protected JSpinner xFirstCtrlField;
	
	/** The current Y-coordinates of the control point field */
	protected JSpinner yFirstCtrlField;
	
	/** The right X-coordinates field */
	protected JSpinner xSecondCtrlField;
	
	/** The right Y-coordinates field */
	protected JSpinner ySecondCtrlField;
	
	protected LaTeXDrawComboBox closingChoice;
	
	protected JCheckBox openCB;
	
	protected JButton equilibrateB;
	
	protected JSpinner equilibrateValueF;
	
	protected JCheckBox moveAll;
	
	public static final String LABEL_EQUILIBRATE_FIELD = "equilibrateF";//$NON-NLS-1$
	
	public static final String LABEL_EQUILIBRATE = "equilibrateB";//$NON-NLS-1$
	
	/** The label of the first X-coordinate of the control point of the current point. */
	public static final String LABEL_CTRLPTS_FIRST_X = "firstCtrlX";//$NON-NLS-1$
	
	/** The label of the first Y-coordinate of the control point of the current point. */
	public static final String LABEL_CTRLPTS_FIRST_Y = "firstCtrlY";//$NON-NLS-1$
	
	/** The label of the first X-coordinate of the control point of the current point. */
	public static final String LABEL_CTRLPTS_SECOND_X = "sndCtrlX";//$NON-NLS-1$
	
	/** The label of the first Y-coordinate of the control point of the current point. */
	public static final String LABEL_CTRLPTS_SECOND_Y = "sndCtrlY";//$NON-NLS-1$
	
	public static final String ACTION_CMD_OPENCB = "openCB";//$NON-NLS-1$
	
	public static final String ACTION_CMD_MOVE_ALL = "moveAll";//$NON-NLS-1$

	
	
	/**
	 * The constructor by default.
	 */
	public ParametersBezierCurveFrame(Frame parent, DrawPanel d, boolean attachToMainFrame)
	{
		super(parent, d, false, attachToMainFrame);
		
		try
		{
	  		Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
	  		JPanel pButton  = createButtonsPanel(this);
	  		JPanel pGeneral = new JPanel();
	  		JTabbedPane tabbedPane = new JTabbedPane();
	  		
	  		pGeneral.setLayout(new BoxLayout(pGeneral, BoxLayout.Y_AXIS));
	  		pGeneral.add(createPositionPanel());
	     	pGeneral.add(createBordersPanel(false));

	     	JPanel panel2 = new JPanel();
	     	panel2.setLayout(new BoxLayout(panel2, BoxLayout.Y_AXIS));
	     	JPanel showP = new JPanel(new FlowLayout(FlowLayout.LEFT));
	     	showPointsCB = new JCheckBox(LABEL_SHOWPOINTCB);
	     	showPointsCB.addActionListener(this);
	     	showPointsCB.setActionCommand(LABEL_SHOWPOINTCB);
	     	showP.add(showPointsCB);
	     	panel2.add(showP);
	     	
	     	JPanel closeP = new JPanel(new FlowLayout(FlowLayout.LEFT));
	     	openCB = new JCheckBox(LaTeXDrawLang.getString1_9("ParametersAkinPointsFrame.1")); //$NON-NLS-1$
	     	openCB.setActionCommand(ACTION_CMD_OPENCB);
	     	openCB.setName(ACTION_CMD_OPENCB);
	     	openCB.addActionListener(this);
	     	closeP.add(openCB);
	     	
	     	closeP.add(new JLabel(LaTeXDrawLang.getString1_9("ParametersAkinPointsFrame.2"))); //$NON-NLS-1$
	     	closingChoice = BezierCurve.createTypeChoice();
	     	closingChoice.addItemListener(this);
	     	closeP.add(closingChoice);
	     	panel2.add(closeP);
	     	
	     	JPanel equilibrateP = new JPanel(new FlowLayout(FlowLayout.LEFT));
	     	equilibrateB = new JButton(LaTeXDrawLang.getString1_9("ParametersBezierCurveFrame.2")); //$NON-NLS-1$
	     	equilibrateB.setToolTipText(LaTeXDrawLang.getString1_9("ParametersBezierCurveFrame.3")); //$NON-NLS-1$
	     	equilibrateB.setActionCommand(LABEL_EQUILIBRATE);
	     	equilibrateB.addActionListener(this);
	     	equilibrateP.add(equilibrateB);
	     	panel2.add(equilibrateP);
	     	
	     	equilibrateP.add(new JLabel(LaTeXDrawLang.getString1_9("ParametersBezierCurveFrame.4"))); //$NON-NLS-1$
	     	
	     	SpinnerModel model = new SpinnerNumberModel(BezierCurve.DEFAULT_EQUILIBRATE_GAP, 1, 1000, 1);
	     	equilibrateValueF = new JSpinner(model);
	     	equilibrateValueF.setToolTipText(LaTeXDrawLang.getString1_9("ParametersBezierCurveFrame.5")); //$NON-NLS-1$
	     	equilibrateValueF.setEditor(new JSpinner.NumberEditor(equilibrateValueF, "0"));//$NON-NLS-1$
	     	equilibrateValueF.addChangeListener(this);
	     	equilibrateValueF.setName(LABEL_EQUILIBRATE_FIELD);
	     	equilibrateValueF.setMaximumSize(new Dimension(100, 40));
	     	equilibrateP.add(equilibrateValueF);
	     	
	     	pGeneral.add(panel2);
	     	
	     	panel2.setBorder(new CompoundBorder(new TitledBorder(null, TITLE_TABBED_PANE_OTHERS, 
					  TitledBorder.LEFT, TitledBorder.TOP), new EmptyBorder(0,0,0,0)));
	     	
	     	JPanel pOther = new JPanel();
	     	pOther.setLayout(new BoxLayout(pOther, BoxLayout.Y_AXIS));
	     	pOther.add(createShadowPanel());
	     	pOther.add(createFillPanel());
	     	pOther.add(createHatchingPanel());
	     	pOther.add(createGradientPanel());
	     	pOther.add(createDoubleLinePanel());
	     	tabbedPane.addTab(TITLE_TABBED_PANE_GENERAL, pGeneral);
	     	tabbedPane.addTab(TITLE_TABBED_PANE_OTHERS, pOther);
	     	tabbedPane.addTab(NAME_TABBEDPANE_ARROW, createArrowPanel(true, false));
	     	BoxLayout bl = new BoxLayout(getContentPane(), BoxLayout.Y_AXIS);
	     	getContentPane().removeAll();
	     	getContentPane().setLayout(bl);
	     	getContentPane().add(glimpsePanelZoom);
	     	getContentPane().add(tabbedPane);
			getContentPane().add(pButton);
	  		pack();
	  		setLocation(dim.width/2-getWidth()/2, dim.height/2-getHeight()/2);
			setVisible(false);

		}catch(Exception e)
		{
			e.printStackTrace(); 
			ExceptionFrameDialog.showExceptionDialog(e);
		}
	     	
	}

	
	
	
	@Override
	protected JPanel createPositionPanel()
	{
		super.createPositionPanel();
		
		JPanel coordP = new JPanel(new GridBagLayout());
  		GridBagConstraints constraint = new GridBagConstraints();
    	constraint.gridx = 0;
     	constraint.gridy = 0;
     	constraint.gridwidth = 1;
     	constraint.gridheight = 1;
     	constraint.weightx = 0.1;
     	constraint.weighty = 0.1;
     	constraint.fill = GridBagConstraints.NONE;
     	constraint.anchor = GridBagConstraints.CENTER;
     	coordP.add(new JLabel(LaTeXDrawLang.getDialogFrameString("ParametersPolygonFrame.1")), constraint); //$NON-NLS-1$
  		
     	constraint.gridx++;	
     	coordP.add(pointChoice, constraint);
     	
     	moveAll = new JCheckBox(LaTeXDrawLang.getDialogFrameString("ParamsBC.0")); //$NON-NLS-1$
     	moveAll.setName(ACTION_CMD_MOVE_ALL);
     	moveAll.setActionCommand(ACTION_CMD_MOVE_ALL);
     	moveAll.setToolTipText(LaTeXDrawLang.getDialogFrameString("ParamsBC.1")); //$NON-NLS-1$
     	moveAll.setSelected(true);
     	constraint.gridx++;	
     	coordP.add(moveAll, constraint);
  		
    	constraint.gridx=0; constraint.gridy++;
     	coordP.add(new JLabel(LABEL_X), constraint);
  		
     	constraint.gridx++;
     	coordP.add(xCoord, constraint);
     	
    	constraint.gridx++;	
     	coordP.add(new JLabel(LABEL_Y), constraint);
  		
     	constraint.gridx++;	
     	coordP.add(yCoord, constraint);
     	
     	constraint.gridx=0; constraint.gridy++;
     	coordP.add(new JLabel(LaTeXDrawLang.getString1_9("ParametersBezierCurveFrame.6")), constraint); //$NON-NLS-1$
  		
     	SpinnerModel model = new SpinnerNumberModel(0,0,10000,0.1);
     	xFirstCtrlField = new JSpinner(model);
     	xFirstCtrlField.setEditor(new JSpinner.NumberEditor(xFirstCtrlField, "0.0"));//$NON-NLS-1$
     	xFirstCtrlField.addChangeListener(this);
     	xFirstCtrlField.setName(LABEL_CTRLPTS_FIRST_X);
     	constraint.gridx++;
     	coordP.add(xFirstCtrlField, constraint);
     	
     	constraint.gridx++;
     	coordP.add(new JLabel(LaTeXDrawLang.getString1_9("ParametersBezierCurveFrame.7")), constraint); //$NON-NLS-1$
     	
     	model = new SpinnerNumberModel(0,0,10000,0.1);
     	yFirstCtrlField = new JSpinner(model);
     	yFirstCtrlField.setEditor(new JSpinner.NumberEditor(yFirstCtrlField, "0.0"));//$NON-NLS-1$
     	yFirstCtrlField.addChangeListener(this);
     	yFirstCtrlField.setName(LABEL_CTRLPTS_FIRST_Y);
     	constraint.gridx++;
     	coordP.add(yFirstCtrlField, constraint);
     	
     	constraint.gridx=0; constraint.gridy++;
     	coordP.add(new JLabel(LaTeXDrawLang.getString1_9("ParametersBezierCurveFrame.8")), constraint); //$NON-NLS-1$
     	
     	model = new SpinnerNumberModel(0,0,10000,0.1);
     	xSecondCtrlField = new JSpinner(model);
     	xSecondCtrlField.setEditor(new JSpinner.NumberEditor(xSecondCtrlField, "0.0"));//$NON-NLS-1$
     	xSecondCtrlField.addChangeListener(this);
     	xSecondCtrlField.setName(LABEL_CTRLPTS_SECOND_X);
     	constraint.gridx++;
     	coordP.add(xSecondCtrlField, constraint);
     	
     	constraint.gridx++;
     	coordP.add(new JLabel(LaTeXDrawLang.getString1_9("ParametersBezierCurveFrame.9")), constraint); //$NON-NLS-1$
     	
     	model = new SpinnerNumberModel(0,0,10000,0.1);
     	ySecondCtrlField = new JSpinner(model);
     	ySecondCtrlField.setEditor(new JSpinner.NumberEditor(ySecondCtrlField, "0.0"));//$NON-NLS-1$
     	ySecondCtrlField.addChangeListener(this);
     	ySecondCtrlField.setName(LABEL_CTRLPTS_SECOND_Y);
     	constraint.gridx++;
     	coordP.add(ySecondCtrlField, constraint);
     	
     	constraint.gridx = 0;	constraint.gridy++;
     	coordP.add(new JLabel(LABEL_ROTATION), constraint);
     	constraint.gridx++;
     	coordP.add(rotationField, constraint);
     	
     	coordP.setBorder(new CompoundBorder(new TitledBorder(null, LABEL_POSITION_DIMENSIONS, 
						  TitledBorder.LEFT, TitledBorder.TOP), new EmptyBorder(0,0,0,0)));
     	
     	return coordP;
	}
	
	
	
	@Override
	public void setVisible(boolean visible, Figure selected, boolean deleteOnCancel, boolean isFramedBox) 
	{
		try
		{
			if(!(selected instanceof BezierCurve))
				throw new ClassCastException();
			
			super.setVisible(visible, selected, deleteOnCancel, isFramedBox);

		}catch(Exception ex)
		{
			ex.printStackTrace(); 
			ExceptionFrameDialog.showExceptionDialog(ex);
		}	
	}
	
	
	
	@Override
	public void setDefaultsValues()
	{
		try
		{
			super.setDefaultsValues();
			
			showPointsCB.setSelected(BezierCurve.DEFAULT_SHOWPOINTS);
			((BezierCurve)glimpsePanel.glimpseFigure).setShowPoints(BezierCurve.DEFAULT_SHOWPOINTS);
			closingChoice.setSelectedItem(String.valueOf(BezierCurve.DEFAULT_CLOSE_TYPE));
			openCB.setSelected(BezierCurve.DEFAULT_OPEN);
			equilibrateValueF.setValue(BezierCurve.DEFAULT_EQUILIBRATE_GAP);
			
			glimpsePanel.repaint();
			
		}catch(Exception e)
		{
			e.printStackTrace();
			ExceptionFrameDialog.showExceptionDialog(e);
		}
	}
	
	
	
	
	
	@Override
	public void saveParameters()
	{
		super.saveParameters();
		
		BezierCurve bc1 = (BezierCurve)figure;
		BezierCurve bc2 = (BezierCurve)glimpsePanel.glimpseFigure;
		int i, size = bc1.getNbPoints();
		
		for(i=0; i<size; i++)
		{
			bc1.getPoint(i).setLocation(bc2.getPoint(i));
			bc1.getFirstControlPoint(i).setLocation(bc2.getFirstControlPoint(i));
			bc1.getSecondControlPoint(i).setLocation(bc2.getSecondControlPoint(i));
		}

		bc1.setEquilibrateGap(Double.valueOf(equilibrateValueF.getValue().toString()).intValue());
		bc1.setShowPoints(showPointsCB.isSelected());
		bc1.setOpen(openCB.isSelected());
		bc1.setCloseType(Integer.valueOf(((JLabel)closingChoice.getSelectedItem()).getText()));
		bc1.updateBorders();
		
		drawPanel.getDraw().updateBorders();
		drawPanel.updateDraw(true);
	}
	
	

	
	@Override
	public void setFigureFrameField()
	{
		super.setFigureFrameField();
		
		BezierCurve bc = (BezierCurve)figure;
		
		arrow2Choice.setEnabled(bc.isOpen());
		equilibrateValueF.setValue(bc.getEquilibrateGap());
		showPointsCB.setSelected(bc.isShowPoints());
		openCB.setSelected(bc.isOpen());
		closingChoice.setSelectedItem(String.valueOf(bc.getCloseType()));
		closingChoice.setEnabled(!openCB.isSelected());
		glimpsePanel.glimpseFigure.setSelected(true);
		glimpsePanel.glimpseFigure.getBorders().setSelected(false);
	}

	
	
	
	@Override
	public void stateChanged(ChangeEvent e) 
	{
		try
		{
			Object o = e.getSource();
			BezierCurve bc = (BezierCurve) glimpsePanel.getGlimpseFigure();
			
			if(o instanceof JSpinner)
			{
				String name = ((JSpinner)o).getName();
				int id = Integer.valueOf(pointChoice.getSelectedItem().toString()).intValue()-1;
				
				if(name.equals(LABEL_X))
				{
					float x = Float.valueOf(xCoord.getValue().toString()).floatValue();
					xs[id] = x;
					bc.setPoint(x, bc.getPoint(id).y, id, moveAll.isSelected());
					
					if(moveAll.isSelected())
					{
						xSecondCtrlField.setValue(bc.getSecondControlPoint(id).x);
						xFirstCtrlField.setValue(bc.getFirstControlPoint(id).x);
					}
					
					setModified(true);
					glimpsePanel.repaint();
					return ;
				}
				
				if(name.equals(LABEL_Y))
				{
					float y = Float.valueOf(yCoord.getValue().toString()).floatValue();
					ys[id] = y;
					bc.setPoint(bc.getPoint(id).x, y, id, moveAll.isSelected());
							
					if(moveAll.isSelected())
					{
						ySecondCtrlField.setValue(bc.getSecondControlPoint(id).y);
						yFirstCtrlField.setValue(bc.getFirstControlPoint(id).y);
					}
					
					setModified(true);
					glimpsePanel.repaint();
					return ;
				}
				
				if(name.equals(LABEL_EQUILIBRATE_FIELD))
				{
					setModified(true);
					bc.setEquilibrateGap(Double.valueOf(equilibrateValueF.getValue().toString()).intValue());
					return ;
				}
				
				if(name.equals(LABEL_CTRLPTS_FIRST_X))
				{
					bc.setXCoordFirstCtrl(Double.valueOf(xFirstCtrlField.getValue().toString()).doubleValue(), id);
					xSecondCtrlField.setValue(bc.getSecondControlPoint(id).x);
					setModified(true);
					glimpsePanel.repaint();
					return ;
				}
				
				if(name.equals(LABEL_CTRLPTS_FIRST_Y))
				{
					bc.setYCoordFirstCtrl(Double.valueOf(yFirstCtrlField.getValue().toString()).doubleValue(), id);
					ySecondCtrlField.setValue(bc.getSecondControlPoint(id).y);
					setModified(true);
					glimpsePanel.repaint();
					return ;
				}
				
				if(name.equals(LABEL_CTRLPTS_SECOND_X))
				{
					bc.setXCoordSecondCtrl(Double.valueOf(xSecondCtrlField.getValue().toString()).doubleValue(), id);
					xFirstCtrlField.setValue(bc.getFirstControlPoint(id).x);
					setModified(true);
					glimpsePanel.repaint();
					return ;
				}
				
				if(name.equals(LABEL_CTRLPTS_SECOND_Y))
				{
					bc.setYCoordSecondCtrl(Double.valueOf(ySecondCtrlField.getValue().toString()).doubleValue(), id);
					yFirstCtrlField.setValue(bc.getFirstControlPoint(id).y);
					setModified(true);
					glimpsePanel.repaint();
					return ;
				}
			}
			
			super.stateChanged(e);
			
		}catch(Exception ex)
		{
			ex.printStackTrace(); 
			ExceptionFrameDialog.showExceptionDialog(ex);
		}
	}


	
	

	@Override
	public void actionPerformed(ActionEvent e)
	{
		super.actionPerformed(e);
		Object src = e.getSource();
		BezierCurve f = (BezierCurve)glimpsePanel.getGlimpseFigure();
		
		if(src instanceof JButton)
		{
			String label = ((JButton)src).getActionCommand();
			
			if(label.equals(LABEL_EQUILIBRATE))
			{
				int i = Integer.valueOf(pointChoice.getSelectedItem().toString()).intValue()-1;
				f.equilibrate();
				
				LaTeXDrawPoint2D pt = f.getPoint(i);
				xCoord.removeChangeListener(this);
				yCoord.removeChangeListener(this);
				xCoord.setValue((float)pt.x);
				yCoord.setValue((float)pt.y);
				xCoord.addChangeListener(this);
				yCoord.addChangeListener(this);
				
				pt = f.getFirstControlPoint(i);
				xFirstCtrlField.removeChangeListener(this);
				yFirstCtrlField.removeChangeListener(this);
				xFirstCtrlField.setValue((float)pt.x);
				yFirstCtrlField.setValue((float)pt.y);
				xFirstCtrlField.addChangeListener(this);
				yFirstCtrlField.addChangeListener(this);
				
				pt = f.getSecondControlPoint(i);
				xSecondCtrlField.removeChangeListener(this);
				ySecondCtrlField.removeChangeListener(this);
				xSecondCtrlField.setValue((float)pt.x);
				ySecondCtrlField.setValue((float)pt.y);
				xSecondCtrlField.addChangeListener(this);
				ySecondCtrlField.addChangeListener(this);
				
				setModified(true);
				glimpsePanel.repaint();
				return ;
			}
			return ;
		}
		
		if(src instanceof JCheckBox)
		{
			String label = ((JCheckBox)src).getActionCommand();
			
			if(label.equals(LABEL_SHOWPOINTCB))
			{
				boolean isSel = showPointsCB.isSelected();
				boolean displayDotF = isSel || f.getArrow1Style().equals(PSTricksConstants.CIRCLEEND_STYLE) ||
										f.getArrow2Style().equals(PSTricksConstants.CIRCLEEND_STYLE) ||
										f.getArrow1Style().equals(PSTricksConstants.CIRCLEIN_STYLE) ||
										f.getArrow2Style().equals(PSTricksConstants.CIRCLEIN_STYLE) ||
										f.getArrow1Style().equals(PSTricksConstants.DISKEND_STYLE) ||
										f.getArrow2Style().equals(PSTricksConstants.DISKEND_STYLE) ||
										f.getArrow1Style().equals(PSTricksConstants.DISKIN_STYLE) ||
										f.getArrow2Style().equals(PSTricksConstants.DISKIN_STYLE);
				f.setShowPoints(isSel);
				
				dotSizeDim.setEnabled(displayDotF);
				dotSizeNum.setEnabled(displayDotF);
				setModified(true);
				glimpsePanel.repaint();
				return ;
			}
			
			if(label.equals(ACTION_CMD_OPENCB))
			{
				int id = Integer.valueOf(pointChoice.getSelectedItem().toString()).intValue()-1;
				boolean ok = openCB.isSelected() && (id==0 || id==f.getNbPoints()-1);
				
				f.setOpen(openCB.isSelected());
				closingChoice.setEnabled(!openCB.isSelected());
				
				xSecondCtrlField.setEnabled(!ok);
				ySecondCtrlField.setEnabled(!ok);
				arrow2Choice.setEnabled(openCB.isSelected());
				setModified(true);
				glimpsePanel.repaint();
				return ;
			}
		}
	}



	@Override
	public void itemStateChanged(ItemEvent e)
	{
		super.itemStateChanged(e);
		
		Object o = e.getSource();
		BezierCurve f = (BezierCurve)glimpsePanel.getGlimpseFigure();
		
		if(o instanceof LaTeXDrawComboBox)
		{
			String ac = ((LaTeXDrawComboBox)o).getActionCommand();
			
			if(ac==null)
				return;
			
			if(ac.equals(BezierCurve.LABEL_CLOSE_CHOICE))
			{
				f.setCloseType(Integer.valueOf(((JLabel)closingChoice.getSelectedItem()).getText()).intValue());
				setModified(true);
				glimpsePanel.repaint();
				return ;
			}
		}

		
		if(o instanceof JComboBox)
		{
			if(((JComboBox)o).getName().equals(LABEL_CHOICE_PTS))
			{
				int id = Integer.valueOf(pointChoice.getSelectedItem().toString()).intValue()-1;
				
				xFirstCtrlField.setValue(f.getFirstControlPoint(id).x);
				yFirstCtrlField.setValue(f.getFirstControlPoint(id).y);
				xSecondCtrlField.setValue(f.getSecondControlPoint(id).x);
				ySecondCtrlField.setValue(f.getSecondControlPoint(id).y);
				
				boolean ok = f.isOpen() && (id==0 || id==f.getNbPoints()-1);
				
				xSecondCtrlField.setEnabled(!ok);
				ySecondCtrlField.setEnabled(!ok);
				
				return ;
			}
		}
	}



	@Override
	public void updateEnableParamsArrow()
	{
		super.updateEnableParamsArrow();
		
		if(arrow2Choice!=null && openCB!=null)
			arrow2Choice.setEnabled(openCB.isSelected());
		
		if(!dotSizeDim.isEnabled() && showPointsCB!=null && showPointsCB.isSelected())
		{
			dotSizeDim.setEnabled(true);
			dotSizeNum.setEnabled(true);
		}
	}
}
