#! /usr/bin/env ruby
$LOAD_PATH.unshift("..")
require 'test/unit'
require 'langscan/_pairmatcher'
require 'langscan/scheme'

class PairMatcherTest < Test::Unit::TestCase

  def pm
    unless @pm
      @pm = LangScan::PairMatcher.new(2,2,2,2)
      @pm.define_intertoken_fragment :space, nil
      @pm.define_intertoken_fragment :comment, nil
      @pm.define_pair :paren, :punct, "(", :punct, ")"
      @pm.define_pair :vector, :punct, "#(", :punct, ")"
    end
    @pm
  end

  def pair_check(pair, expected)
    expected.each {|k, v|
      value = pair.send(k)
      if value.class == Array && value[0].class == LangScan::Fragment
        v.each_with_index {|token, i|
          assert_equal(token, value[i].to_a)
        }
      else
        assert_equal(v, value)
      end
    }
  end

  def test_vector_in_paren
    text = "( #( ) )"
    expected = {
      :vector => {
        :pair_def => [:punct, "#(", :punct, ")", :vector],
        :before_open_len => 1,
        :around_open_tokens => [[:punct, "(", 1, 0],
                                [:punct, "#(", 1, 2],
                                [:punct, ")", 1, 5],
                                [:punct, ")", 1, 7]],
        :before_close_len => 2,
        :around_close_tokens => [[:punct, "(", 1, 0],
                                 [:punct, "#(", 1, 2],
                                 [:punct, ")", 1, 5],
                                 [:punct, ")", 1, 7]]
      },
      :paren => {
        :pair_def => [:punct, "(", :punct, ")", :paren],
        :before_open_len => 0,
        :around_open_tokens => [[:punct, "(", 1, 0],
                                [:punct, "#(", 1, 2],
                                [:punct, ")", 1, 5]],
        :before_close_len => 2,
        :around_close_tokens => [[:punct, "#(", 1, 2],
                                [:punct, ")", 1, 5],
                                [:punct, ")", 1, 7]]
      }
    }
    pm.parse(LangScan::Scheme::Tokenizer.new(text), lambda {|f|}) {|pair|
      pair_check(pair, expected[pair.pair_type])
    }
  end

  def test_paren_in_vector
    text = "#( ( ) )"
    expected = {
      :vector => {
        :pair_def => [:punct, "#(", :punct, ")", :vector],
        :before_open_len => 0,
        :around_open_tokens => [[:punct, "#(", 1, 0],
                                [:punct, "(", 1, 3],
                                [:punct, ")", 1, 5]],
        :before_close_len => 2,
        :around_close_tokens => [[:punct, "(", 1, 3],
                                 [:punct, ")", 1, 5],
                                 [:punct, ")", 1, 7]]
      },
      :paren => {
        :pair_def => [:punct, "(", :punct, ")", :paren],
        :before_open_len => 1,
        :around_open_tokens => [[:punct, "#(", 1, 0],
                                [:punct, "(", 1, 3],
                                [:punct, ")", 1, 5],
                                [:punct, ")", 1, 7]],
        :before_close_len => 2,
        :around_close_tokens => [[:punct, "#(", 1, 0],
                                [:punct, "(", 1, 3],
                                [:punct, ")", 1, 5],
                                [:punct, ")", 1, 7]]
      }
    }
    pm.parse(LangScan::Scheme::Tokenizer.new(text), lambda {|f|}) {|pair|
      pair_check(pair, expected[pair.pair_type])
    }    
  end

end
