/*
 * Copyright 1998-2001, University of Notre Dame.
 * Authors: Jeffrey M. Squyres, Arun Rodrigues, and Brian Barrett with
 *          Kinis L. Meyer, M. D. McNally, and Andrew Lumsdaine
 * 
 * This file is part of the Notre Dame LAM implementation of MPI.
 * 
 * You should have received a copy of the License Agreement for the Notre
 * Dame LAM implementation of MPI along with the software; see the file
 * LICENSE.  If not, contact Office of Research, University of Notre
 * Dame, Notre Dame, IN 46556.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted subject to the conditions specified in the
 * LICENSE file.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 * 
 * Additional copyrights may follow.
 * 
 *	Ohio Trollius
 *	Copyright 1995 The Ohio State University
 *	GDB
 *
 *	$Log: rtrstore.c,v $
 *	Revision 6.2  1999/05/26 21:50:03  kmeyer1
 *	
 *	added copyright
 *	
 *	Revision 6.1  1996/11/24 00:26:20  nevin
 *	Ohio Release
 *	
 * Revision 6.0  96/02/29  14:05:44  gdburns
 * Ohio Release
 * 
 *	Function:	- stores trace data with traced
 *			- generates 1 to N store requests, each less
 *			  than MAXNMSGLEN
 *
 *	Accepts:	- target node ID (should be LOCAL)
 *			- list number
 *			- process ID
 *			- ptr to trace data buffer
 *			- buffer length
 *
 *	Returns:	- return value of nsend()
 */

#include <events.h>
#include <net.h>
#include <portable.h>
#include <trreq.h>
#include <typical.h>

int
lam_rtrstore(nodeid, lnum, pid, buffer, length)

int4			nodeid;
int4			lnum;
int4			pid;
CONST char		*buffer;
int4			length;

{
	struct nmsg	nhead;		/* network message desc. */
	struct trreq	*request;	/* traced request */

	request = (struct trreq *) nhead.nh_data;

	request->trq_req = TRQSTORE;
	request->trq_pid = pid;
	request->trq_lnum = lnum;

	nhead.nh_node = nodeid;
	nhead.nh_event = EVTRACED;
	nhead.nh_type = 0;
	nhead.nh_flags = 0;
	nhead.nh_msg = (char *) buffer;

	while (length > 0) {
		nhead.nh_length = (length > MAXNMSGLEN) ? MAXNMSGLEN : length;
		request->trq_length = nhead.nh_length;

		if (nsend(&nhead)) return(LAMERROR);

		length -= nhead.nh_length;
		buffer += nhead.nh_length;
	}

	return(0);
}
