/*
 * Copyright 1998-2001, University of Notre Dame.
 * Authors: Jeffrey M. Squyres, Arun Rodrigues, and Brian Barrett with
 *          Kinis L. Meyer, M. D. McNally, and Andrew Lumsdaine
 * 
 * This file is part of the Notre Dame LAM implementation of MPI.
 * 
 * You should have received a copy of the License Agreement for the Notre
 * Dame LAM implementation of MPI along with the software; see the file
 * LICENSE.  If not, contact Office of Research, University of Notre
 * Dame, Notre Dame, IN 46556.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted subject to the conditions specified in the
 * LICENSE file.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 * 
 * Additional copyrights may follow.
 * 
 *	Ohio Trollius
 *	Copyright 1997 The Ohio State University
 *	GDB
 *
 *	$Id: rtrsimplex.c,v 6.3 1999/05/26 21:50:03 kmeyer1 Exp $
 *
 *	Function:	- simple traced requests
 */

#include <events.h>
#include <net.h>
#include <trreq.h>

/*
 *	lam_rtrsweep
 *
 *	Function:	- sweeps out traced's stored trace data
 *			- no reply from traced
 *	Accepts:	- target node ID
 *			- list number
 *	Returns:	- return value of nsend()
 */
int
lam_rtrsweep(nodeid, lnum)

int4			nodeid;
int4			lnum;

{
	struct nmsg	nhead;		/* network message desc. */
	struct trreq  	*request;	/* traced request */

	request = (struct trreq *) nhead.nh_data;
	request->trq_req = TRQSWEEP;
	request->trq_lnum = lnum;
 	request->trq_pid = TRANYPID;
	
	nhead.nh_node = nodeid;
	nhead.nh_event = EVTRACED;
	nhead.nh_type = 0;
	nhead.nh_flags = 0;
	nhead.nh_length = 0;
	nhead.nh_msg = 0;

	return(nsend(&nhead));
}

/*
 *	lam_rtrudie
 *
 *	Function:	- removes pid related information
 *			- no reply from traced
 *	Accepts:	- target node ID
 *			- pid
 *	Returns:	- return value of nsend()
 */
int
lam_rtrudie(nodeid, pid)

int4			nodeid;
int4			pid;

{
	struct nmsg	nhead;		/* network message desc. */
	struct trreq  	*request;	/* traced request */

	request = (struct trreq *) nhead.nh_data;
	request->trq_req = TRQUDIE;
	request->trq_pid = pid;

	nhead.nh_node = nodeid;
	nhead.nh_event = EVTRACED;
	nhead.nh_type = 0;
	nhead.nh_flags = 0;
	nhead.nh_length = 0;
	nhead.nh_msg = 0;

	return(nsend(&nhead));
}

/*
 *	lam_rtrwipe
 *
 *	Function:	- resets traced
 *			- no reply from traced
 *	Accepts:	- target node ID
 *	Returns:	- return value of nsend()
 */
int
lam_rtrwipe(nodeid)

int4			nodeid;

{
	struct nmsg	nhead;		/* network message desc. */
	struct trreq  	*request;	/* traced request */

	request = (struct trreq *) nhead.nh_data;
	request->trq_req = TRQWIPE;

	nhead.nh_node = nodeid;
	nhead.nh_event = EVTRACED;
	nhead.nh_type = 0;
	nhead.nh_flags = 0;
	nhead.nh_length = 0;
	nhead.nh_msg = 0;

	return(nsend(&nhead));
}

/*
 *	lam_rtrcleanobjs
 *
 *	Function:	- makes traced clean up registered objects
 *			- no reply from traced
 *	Accepts:	- target node ID
 *	Returns:	- return value of nsend()
 */
int
lam_rtrcleanobjs(nodeid)

int4			nodeid;

{
	struct nmsg	nhead;		/* network message desc. */
	struct trreq  	*request;	/* traced request */

	request = (struct trreq *) nhead.nh_data;
	request->trq_req = TRQCLEANOBJS;

	nhead.nh_node = nodeid;
	nhead.nh_event = EVTRACED;
	nhead.nh_type = 0;
	nhead.nh_flags = 0;
	nhead.nh_length = 0;
	nhead.nh_msg = 0;

	return(nsend(&nhead));
}
