/*
 * Copyright 1998-2001, University of Notre Dame.
 * Authors: Jeffrey M. Squyres, Arun Rodrigues, and Brian Barrett with
 *          Kinis L. Meyer, M. D. McNally, and Andrew Lumsdaine
 * 
 * This file is part of the Notre Dame LAM implementation of MPI.
 * 
 * You should have received a copy of the License Agreement for the Notre
 * Dame LAM implementation of MPI along with the software; see the file
 * LICENSE.  If not, contact Office of Research, University of Notre
 * Dame, Notre Dame, IN 46556.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted subject to the conditions specified in the
 * LICENSE file.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 * 
 * Additional copyrights may follow.
 * 
 *	Ohio Trollius
 *	Copyright 1994 The Ohio State University
 *	GDB
 *
 *	$Log: rbfsweep.c,v $
 *	Revision 6.2  1999/05/26 21:50:00  kmeyer1
 *	
 *	added copyright
 *	
 *	Revision 6.1  1996/11/24 00:25:53  nevin
 *	Ohio Release
 *	
 * Revision 6.0  96/02/29  14:04:57  gdburns
 * Ohio Release
 * 
 * Revision 5.2  94/08/22  14:13:27  gdburns
 * Ohio Release
 * 
 * Revision 5.1  94/05/18  12:58:04  gdburns
 * Ohio Release
 * 
 * Revision 2.3  94/04/22  12:46:13  gdburns
 * Ohio Release
 * 
 * Revision 2.2.1.1  94/02/15  15:32:15  gdburns
 * Revise bufferd request codes.
 * 
 * Revision 2.2  93/10/15  11:28:33  gdburns
 * pre-release to 2.3
 * 
 *	Function:	- removes all buffered messages
 */

#include <net.h>
#include <events.h>
#include <bfreq.h>

int
rbfsweep(node)

int4			node;

{
	struct nmsg	nhead;		/* network header */
	struct bfreq  	*request;	/* bufferd request */

	request = (struct bfreq *) nhead.nh_data;
	request->bfq_req = BFQSWEEP;

	nhead.nh_node = node;
	nhead.nh_event = EVBUFFERD;
	nhead.nh_type = DLCTL;
	nhead.nh_flags = NOBUF;
	nhead.nh_length = 0;
	nhead.nh_msg = 0;

	return(nsend(&nhead));
}
