/*
 * Copyright 1998-2001, University of Notre Dame.
 * Authors: Jeffrey M. Squyres, Arun Rodrigues, and Brian Barrett with
 *          Kinis L. Meyer, M. D. McNally, and Andrew Lumsdaine
 * 
 * This file is part of the Notre Dame LAM implementation of MPI.
 * 
 * You should have received a copy of the License Agreement for the Notre
 * Dame LAM implementation of MPI along with the software; see the file
 * LICENSE.  If not, contact Office of Research, University of Notre
 * Dame, Notre Dame, IN 46556.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted subject to the conditions specified in the
 * LICENSE file.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 * 
 * Additional copyrights may follow.
 * 
 *	Ohio Trollius
 *	Copyright 1995 The Ohio State University
 *	GDB
 *
 *      $Id: lpattach.c,v 1.1 2000/02/08 10:17:42 jsquyres Exp $
 *
 *	Function:	- registers with kenyad
 *	Accepts:	- name of program
 *	Returns:	- 0 or ERROR
 */

#include <lam_config.h>

#include <string.h>

#include <events.h>
#include <ksignal.h>
#include <kio.h>
#include <net.h>
#include <portable.h>
#include <preq.h>
#include <t_types.h>
#include <typical.h>
#include <terror.h>

/*
 * external variables
 */
extern struct kio_t	_kio;		/* Kernel Input/Output */

/*
 * external functions
 */
extern int4		kpgetpid();

int
lpattach(name)

CONST char		*name;

{
	struct nmsg	nhead;		/* network message */
	struct preq	request;	/* kenya request */
	struct preply	reply;		/* kenya reply */
	int		mask;

	LAM_ZERO_ME(request);
	LAM_ZERO_ME(nhead);

	request.pq_src_node = ltot(LOCAL);
	request.pq_src_event = ltot((int4) -kbgetpid());
	request.pq_req = ltot(PQATTACH);
	request.pq_pid = ltot((int4) kbgetpid());
	request.pq_rtf = ltot(_kio.ki_rtf);

	if (name == 0) {
		request.pq_name[0] = '\0';
	} else {
		strncpy(request.pq_name, name, PSMAXNAME);
		request.pq_name[PSMAXNAME - 1] = '\0';
	}

	nhead.nh_node = LOCAL;
	nhead.nh_event = EVKENYAD;
	nhead.nh_type = 0;
	nhead.nh_flags = 0;
	nhead.nh_length = sizeof(request);
	nhead.nh_msg = (char *) &request;
	mask = ksigblock(sigmask(SIGUDIE) | sigmask(SIGARREST));

	if (nsend(&nhead)) {
		ksigsetmask(mask);
		return(ERROR);
	}

	nhead.nh_event = -kbgetpid();
	nhead.nh_flags = 0;
	nhead.nh_length = sizeof(reply);
	nhead.nh_msg = (char *) &reply;

/*
 *	if (nrecv(&nhead)) {
 *		ksigsetmask(mask);
 *		return(ERROR);
 *	}
 */

	ksigsetmask(mask);

/*
 *	if (reply.pr_reply) {
 *		errno = ttol(reply.pr_reply);
 *		return(ERROR);
 *	} else {
 */
		_kio.ki_rtf |= RTF_KENYA;
		return(0);
/*
 *	}
 */
}
