/*
 * Copyright 1998-2001, University of Notre Dame.
 * Authors: Jeffrey M. Squyres, Arun Rodrigues, and Brian Barrett with
 *          Kinis L. Meyer, M. D. McNally, and Andrew Lumsdaine
 * 
 * This file is part of the Notre Dame LAM implementation of MPI.
 * 
 * You should have received a copy of the License Agreement for the Notre
 * Dame LAM implementation of MPI along with the software; see the file
 * LICENSE.  If not, contact Office of Research, University of Notre
 * Dame, Notre Dame, IN 46556.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted subject to the conditions specified in the
 * LICENSE file.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 * 
 * Additional copyrights may follow.
 * 
 *	Ohio Trollius
 *	Copyright 1995 The Ohio State University
 *	GDB/RBD
 *
 *	Function:	- receives a network message
 *			- The KTRY functionality is not air-tight.
 *	Accepts:	- network message descriptor
 */

#include <string.h>

#include <bfreq.h>
#include <events.h>
#include <kio.h>
#include <net.h>
#include <terror.h>
#include <typical.h>

/*
 * external variables
 */
extern struct kio_t	_kio;

int
nrecv(nhead)

struct nmsg		*nhead;		/* network message header */

{
	struct nmsg	incoming;	/* incoming packet */
	int4		remlen;		/* remaining length */
	char		*save_msg;	/* nh_msg temporary */
/*
 * Probe first for the message, if KTRY is requested.
 * This is not an air-tight solution.
 */
	if ((nhead->nh_flags & KTRY) && !(nhead->nh_flags & NOBUF)) {
		incoming.nh_event = nhead->nh_event;
		incoming.nh_type = nhead->nh_type;
		incoming.nh_flags = nhead->nh_flags;

		switch (nprobe(&incoming)) {

			case LAMERROR:
			return(LAMERROR);

			case 1:
			break;

			default:
			errno = EWOULDBLOCK;
			return(LAMERROR);
		}
	}
/*
 * Receive the network message using frecv() or bfrecv().
 */
	remlen = nhead->nh_length;

	incoming.nh_event = nhead->nh_event;
	incoming.nh_type = nhead->nh_type;
	incoming.nh_flags = nhead->nh_flags | NMORE;
	incoming.nh_length = MAXNMSGLEN;
	incoming.nh_msg = nhead->nh_msg;

	while ((remlen > MAXNMSGLEN) && (incoming.nh_flags & NMORE)) {
		save_msg = incoming.nh_msg;

		if (nhead->nh_flags & NOBUF) {
			if (frecv(&incoming)) return(LAMERROR);
		} else {
			if (bfrecv(&incoming)) return(LAMERROR);
		}

		incoming.nh_msg = save_msg;
		remlen -= incoming.nh_length;
		incoming.nh_msg += incoming.nh_length;
	}

	if (incoming.nh_flags & NMORE) {
/*
 * The next packet should be the last.
 */
		incoming.nh_length = remlen;

		if (nhead->nh_flags & NOBUF) {
			if (frecv(&incoming)) return(LAMERROR);
		} else {
			if (bfrecv(&incoming)) return(LAMERROR);
		}

		remlen -= LAM_min(remlen, incoming.nh_length);
/*
 * Suck excess packets into the vacuum of space.
 */
		while (incoming.nh_flags & NMORE) {
			incoming.nh_length = 0;

			if (nhead->nh_flags & NOBUF) {
				if (frecv(&incoming)) return(LAMERROR);
			} else {
				if (bfrecv(&incoming)) return(LAMERROR);
			}
		}
	}
/*
 *	else if (remlen > MAXNMSGLEN)
 *
 * We just ran out of packets.
 */
	nhead->nh_length = nhead->nh_length - remlen;
	nhead->nh_type = incoming.nh_type;
	memcpy((char *) nhead->nh_data, (char *) incoming.nh_data,
			NHDSIZE * sizeof(int4));

	return(0);
}

/*
 *	ntry_recv
 *
 *	Function:	- non-blocking nrecv()
 *	Accepts:	- ptr to network message descriptor
 *	Returns:	- 0 or ERROR
 */
int
ntry_recv(nhead)

struct nmsg		*nhead;

{
	int		ret;

	nhead->nh_flags |= KTRY;
	ret = nrecv(nhead);
	nhead->nh_flags &= ~KTRY;
	return(ret);
}
