/*
 * Copyright 1998-2001, University of Notre Dame.
 * Authors: Jeffrey M. Squyres, Arun Rodrigues, and Brian Barrett with
 *          Kinis L. Meyer, M. D. McNally, and Andrew Lumsdaine
 * 
 * This file is part of the Notre Dame LAM implementation of MPI.
 * 
 * You should have received a copy of the License Agreement for the Notre
 * Dame LAM implementation of MPI along with the software; see the file
 * LICENSE.  If not, contact Office of Research, University of Notre
 * Dame, Notre Dame, IN 46556.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted subject to the conditions specified in the
 * LICENSE file.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 * 
 * Additional copyrights may follow.
 * 
 *	Ohio Trollius
 *	Copyright 1995 The Ohio State University
 *	GDB
 *
 *	$Log: bfiselect.c,v $
 *	Revision 6.2  1999/05/26 18:22:02  kmeyer1
 *	added copyright
 *	
 *	Revision 6.1  1996/11/23 23:56:31  nevin
 *	Ohio Release
 *	
 * Revision 6.0  96/02/29  13:57:34  gdburns
 * Ohio Release
 * 
 *	Function:	- nonblocking probe on multiple SQL sync points
 *	Accepts:	- synchronization array
 *			- array size
 *			- additional flags
 *			- index of matched sync pt (out)
 *	Returns:	- 0 or ERROR
 *			- updates bfk_type with probed sync point
 *			- does not return probed length
 */

#include <unistd.h>

#include <bfreq.h>
#include <events.h>
#include <net.h>
#include <terror.h>
#include <typical.h>

int
bfiselect(pbfk, nbfk, flags, sync_index)

struct bfsync		*pbfk;
int			nbfk;
int4			flags;
int			*sync_index;

{
	struct bfreq	*req;		/* bufferd request */
	struct bfreply	*reply;		/* bufferd reply */
	struct nmsg	nhreq;		/* bufferd req msg */
	struct nmsg	nhreply;	/* bufferd reply msg */

	if ((nbfk < 0) || (nbfk > (MAXNMSGLEN / sizeof(struct bfsync)))) {
		errno = EINVAL;
		return(LAMERROR);
	}
/*
 * Send a query message to the buffer.
 */
	req = (struct bfreq *) nhreq.nh_data;
	req->bfq_req = BFQPROBE;
	req->bfq_src_node = LOCAL;
	req->bfq_src_event = -getpid();
	req->bfq_event = pbfk->bfk_event;
	req->bfq_type = pbfk->bfk_type;
	req->bfq_flags = flags;
/*
 * Set up bufferd request message.
 */
	nhreq.nh_dl_event = EVBUFFERD;
	nhreq.nh_node = LOCAL;
	nhreq.nh_event = EVBUFFERD;
	nhreq.nh_type = DLCTL;
	nhreq.nh_flags = flags & KTRACE;
	nhreq.nh_length = (nbfk == 1) ? 0 : sizeof(struct bfsync) * nbfk;
	nhreq.nh_msg = (char *) pbfk;

	nhreply.nh_event = -getpid();
	nhreply.nh_type = 0;
	nhreply.nh_flags = 0;
	nhreply.nh_length = 0;
	nhreply.nh_msg = 0;

	if (dsfr(&nhreq, &nhreply)) return(LAMERROR);

	reply = (struct bfreply *) nhreply.nh_data;

	if (reply->bfr_reply) {
		errno = reply->bfr_reply;
		return(LAMERROR);
	}

	*sync_index = reply->bfr_index;

	if (reply->bfr_index >= 0) {
		pbfk[reply->bfr_index].bfk_type = reply->bfr_type;
	}

	return(0);
}
