/*
 * Copyright 1998-2001, University of Notre Dame.
 * Authors: Jeffrey M. Squyres, Arun Rodrigues, and Brian Barrett with
 *          Kinis L. Meyer, M. D. McNally, and Andrew Lumsdaine
 * 
 * This file is part of the Notre Dame LAM implementation of MPI.
 * 
 * You should have received a copy of the License Agreement for the Notre
 * Dame LAM implementation of MPI along with the software; see the file
 * LICENSE.  If not, contact Office of Research, University of Notre
 * Dame, Notre Dame, IN 46556.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted subject to the conditions specified in the
 * LICENSE file.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 * 
 * Additional copyrights may follow.
 * 
 *	Ohio Trollius
 *	Copyright 1996 The Ohio State University
 *	RBD
 *
 *	$Id: pcontrol.c,v 6.5 1999/12/31 21:27:35 jsquyres Exp $
 *
 *	Function:	- set profiling control level
 *			- NOP in MPI, up for profiling packages
 *	Accepts:	- level setting
 *			- varargs
 *	Returns:	- MPI_SUCCESS
 */

#include <lam_config.h>
#include <mpi.h>
#include <mpisys.h>

#if LAM_WANT_PROTOS

/*@

MPI_Pcontrol - Controls profiling

Input Parameters:
. level - Profiling level 

Notes:

This routine provides a common interface for profiling control.  The
interpretation of 'level' and any other arguments is left to the
profiling library.  LAM/MPI''s implementation of this function is a
no-op that always returns 'MPI_SUCCESS'.

.N fortran

.N ACK
@*/
int MPI_Pcontrol(int level, ...)
{
	return(MPI_SUCCESS);
}

#else

int
MPI_Pcontrol(level)
int			level;
{
	return(MPI_SUCCESS);
}

#endif
