/*
 * Copyright 1998-2001, University of Notre Dame.
 * Authors: Jeffrey M. Squyres, Arun Rodrigues, and Brian Barrett with
 *          Kinis L. Meyer, M. D. McNally, and Andrew Lumsdaine
 * 
 * This file is part of the Notre Dame LAM implementation of MPI.
 * 
 * You should have received a copy of the License Agreement for the Notre
 * Dame LAM implementation of MPI along with the software; see the file
 * LICENSE.  If not, contact Office of Research, University of Notre
 * Dame, Notre Dame, IN 46556.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted subject to the conditions specified in the
 * LICENSE file.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 * 
 * Additional copyrights may follow.
 * 
 *	Ohio Trollius
 *	Copyright 1997 The Ohio	State University
 *	NJN/RBD
 *
 *	$Id: tstruct_f.c,v 6.4 1999/09/02 01:34:36 prijks Exp $
 *
 *	Function:	- MPI_Type_struct F77 wrapper
 */

#include <lam_config.h>

#include <errno.h>
#include <stdlib.h>

#include <blktype.h>
#include <mpi.h>
#include <MPISYSF.h>
#include <mpisys.h>

void
mpi_type_struct_(c, b, d, t, nt, ierr)

int			*c, *b,	*d, *t,	*nt, *ierr;

{
	MPI_Datatype	dtype;
	MPI_Datatype	*tp;
	MPI_Aint	*dp;
	int		i;

	if (*c > 0) {
		tp = (MPI_Datatype *) malloc((*c) * sizeof(MPI_Datatype));
		if (tp == 0) {
			lam_setfunc_m(BLKMPITSTRUCT);
			*ierr =	lam_errfunc(MPI_COMM_WORLD, BLKMPITSTRUCT,
					lam_mkerr(MPI_ERR_OTHER, errno));
			return;
		}

		dp = (MPI_Aint *) malloc((*c) * sizeof(MPI_Aint));
		if (dp == 0) {
			free((char *) tp);
			lam_setfunc_m(BLKMPITSTRUCT);
			*ierr =	lam_errfunc(MPI_COMM_WORLD, BLKMPITSTRUCT,
					lam_mkerr(MPI_ERR_OTHER, errno));
			return;
		}
	} else {
		tp = 0;
		dp = 0;
	}

	for (i = 0; i <	*c; ++i) {
		tp[i] =	GETHDL(t[i]);
		dp[i] =	(MPI_Aint) d[i];
	}

	*ierr =	MPI_Type_struct(*c, b, dp, tp, &dtype);

	if (lam_F_make_hdl(nt, ierr, dtype, BLKMPITSTRUCT)) {
		dtype->dt_f77handle = *nt;
		dtype->dt_flags |= LAM_LANGF77;
	}

	free((char *) tp);
	free((char *) dp);
}
