/*
 * Copyright 1998-2001, University of Notre Dame.
 * Authors: Jeffrey M. Squyres, Arun Rodrigues, and Brian Barrett with
 *          Kinis L. Meyer, M. D. McNally, and Andrew Lumsdaine
 * 
 * This file is part of the Notre Dame LAM implementation of MPI.
 * 
 * You should have received a copy of the License Agreement for the Notre
 * Dame LAM implementation of MPI along with the software; see the file
 * LICENSE.  If not, contact Office of Research, University of Notre
 * Dame, Notre Dame, IN 46556.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted subject to the conditions specified in the
 * LICENSE file.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 * 
 * Additional copyrights may follow.
 * 
 *	Ohio Trollius
 *	Copyright 1997 The Ohio State University
 *	NJN
 *
 *	$Id: spawn_f.c,v 6.6 1999/09/02 01:34:29 prijks Exp $
 *
 *	Function:	- MPI_Comm_spawn F77 wrapper
 */

#include <lam_config.h>

#include <errno.h>
#include <stdlib.h>

#include <args.h>
#include <blktype.h>
#include <mpi.h>
#include <MPISYSF.h>
#include <mpisys.h>

void
mpi_comm_spawn_(cmd, av, maxp, info, root, comm, icomm, ec, ierr, nc, na)

char			*cmd, *av;
int			*maxp, *info, *root, *comm, *icomm, *ec, *ierr;
int			nc, na;

{
	MPI_Comm	intercomm;		/* parent-child intercomm */
	char		**argv = 0;		/* C argument vector */
	char		*command;		/* C program name */
	int		*errs;			/* C errcode array */
/*
 * Check for special argument values.
 */
	if ((void *) ec == lam_F_errorcodes_ignore) {
		errs = 0;
	} else {
		errs = ec;
	}

	if ((void *) av == lam_F_argvnull) {
		argv = 0;
	} else {
/*
 * Convert F77 argument array to C argument vector.
 */
		if (lam_F2C_argv(av, na, &argv)) {
			lam_setfunc(BLKMPICOMMSPAWN);
			*ierr = lam_errfunc(GETHDL(*comm), BLKMPICOMMSPAWN,
					    lam_mkerr(MPI_ERR_SPAWN, errno));
			return;
		}

		if (argv == 0) {
			argv = 0;
		}
	}
/*
 * Convert F77 command string to C string.
 */
	command = lam_F2C_string(cmd, nc);
	if (command == 0) {
		argvfree(argv);
		lam_setfunc(BLKMPICOMMSPAWN);
		*ierr = lam_errfunc(GETHDL(*comm), BLKMPICOMMSPAWN,
					lam_mkerr(MPI_ERR_SPAWN, errno));
		return;
	}

	*ierr = MPI_Comm_spawn(command, argv, *maxp, GETHDL(*info), 
				*root, GETHDL(*comm), &intercomm, errs);

	if (lam_F_make_hdl(icomm, ierr, intercomm, BLKMPICOMMSPAWN)) {
		intercomm->c_f77handle = *icomm;
	}
	
	argvfree(argv);
	free(command);
}
