/*
 * Copyright 1998-2001, University of Notre Dame.
 * Authors: Jeffrey M. Squyres, Arun Rodrigues, and Brian Barrett with
 *          Kinis L. Meyer, M. D. McNally, and Andrew Lumsdaine
 * 
 * This file is part of the Notre Dame LAM implementation of MPI.
 * 
 * You should have received a copy of the License Agreement for the Notre
 * Dame LAM implementation of MPI along with the software; see the file
 * LICENSE.  If not, contact Office of Research, University of Notre
 * Dame, Notre Dame, IN 46556.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted subject to the conditions specified in the
 * LICENSE file.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 * 
 * Additional copyrights may follow.
 * 
 *	Ohio Trollius
 *	Copyright 1997 The Ohio	State University
 *	NJN
 *
 *	$Id: mpil_spawn_f.c,v 6.4.2.1 2001/11/09 20:57:51 brbarret Exp $
 *
 *	Function:	- MPIL_Spawn, MPIL_Comm_parent,	MPIL_Universe_size
 *			  F77 wrappers
 */

#include <lam_config.h>

#include <blktype.h>
#include <mpi.h>
#include <MPISYSF.h>
#include <mpisys.h>


void
mpil_spawn_(c, a, r, ic, ierr)

int	*c, *r,	*ic, *ierr;
char	*a;

{
	MPI_Comm comm;

	*ierr =	MPIL_Spawn(GETHDL(*c), a, *r, &comm);
	
	if (lam_F_make_hdl(ic, ierr, comm, BLKMPILSPAWN)) {
		comm->c_f77handle = *ic;
	}
}


void
mpil_comm_parent_(c, ierr)

int	*c, *ierr;

{
	MPI_Comm	parent;

	*c = -1;
	*ierr = MPIL_Comm_parent(&parent);

	if (*ierr == MPI_SUCCESS && parent != LAM_MPI_C_COMM_NULL) {
		if (parent->c_f77handle < 0) {
			lam_F_make_hdl(c, ierr, parent, BLKMPILCOMMPARENT);
			parent->c_f77handle = *c;
		} else {
			*c = parent->c_f77handle;
		}
	}
}


void 
mpil_universe_size_(s, ierr)

int	*s, *ierr;

{
	*ierr =	MPIL_Universe_size(s);
}
