/*
 * Copyright 1998-2001, University of Notre Dame.
 * Authors: Jeffrey M. Squyres, Arun Rodrigues, and Brian Barrett with
 *          Kinis L. Meyer, M. D. McNally, and Andrew Lumsdaine
 * 
 * This file is part of the Notre Dame LAM implementation of MPI.
 * 
 * You should have received a copy of the License Agreement for the Notre
 * Dame LAM implementation of MPI along with the software; see the file
 * LICENSE.  If not, contact Office of Research, University of Notre
 * Dame, Notre Dame, IN 46556.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted subject to the conditions specified in the
 * LICENSE file.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 * 
 * Additional copyrights may follow.
 * 
 *
 *	Revision 6.1  1996/11/23 21:55:44  nevin
 *	Ohio Release
 *	
 * Revision 6.0  96/02/29  13:54:09  gdburns
 * Ohio Release
 * 
 * Revision 5.2  94/08/22  14:00:50  gdburns
 * Ohio Release
 * 
 * Revision 5.1  94/05/18  12:44:46  gdburns
 * Ohio Release
 * 
 * Revision 2.3  94/04/22  12:49:11  gdburns
 * Ohio Release
 * 
 * Revision 2.2  93/10/14  18:28:53  raja
 * pre-release to 2.3
 * 
 *	Function:	- virtual circuits templates and constants
 */

#ifndef _VCTABLE
#define _VCTABLE

#include <portable.h>

/*
 * constants
 */
#define VCMAX		67		/* VC table size (prime #) */

/*
 * hashing macro
 */
#define _vchash(n,e,t)	(abs((n) + (e) + (t)) % VCMAX)

/*
 * templates
 */
struct vcdesc {
	int4		vc_node;	/* node identifier */
	int4		vc_event;	/* message event */
	int4		vc_type;	/* event type */
	int4		vc_path;	/* VC path */
};

#endif
