/*
 * Copyright 1998-2001, University of Notre Dame.
 * Authors: Jeffrey M. Squyres, Arun Rodrigues, and Brian Barrett with
 *          Kinis L. Meyer, M. D. McNally, and Andrew Lumsdaine
 * 
 * This file is part of the Notre Dame LAM implementation of MPI.
 * 
 * You should have received a copy of the License Agreement for the Notre
 * Dame LAM implementation of MPI along with the software; see the file
 * LICENSE.  If not, contact Office of Research, University of Notre
 * Dame, Notre Dame, IN 46556.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted subject to the conditions specified in the
 * LICENSE file.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 * 
 * Additional copyrights may follow.
 * 
 *
 *	$Id: rpi_lamd.h,v 6.1 2001/01/10 19:59:08 jsquyres Exp $
 *
 *	Function:	- RPI implementation for LAM daemon
 *			- constants and templates
 */

#ifndef _RPI_LAMD_H
#define _RPI_LAMD_H

#include <net.h>

/*
 * lamd request
 */
struct lamd_req {
	struct nmsg	lmq_msg_data;		/* data LAM message */
	struct nmsg	lmq_msg_ack;		/* ack LAM message */
	struct nmsg	lmq_msg_ger;		/* GER LAM message */
	int		lmq_state;		/* progress state */
	int		lmq_flags;		/* misc. flags */
	int		lmq_ndata;		/* #bytes to ship */
	int		lmq_ndata_moved;	/* #bytes shipped */
};

/*
 * lamd request states
 */
#define LAMD_START	0			/* no communication yet */
#define LAMD_ACK	1			/* ship ack next */
#define LAMD_TAIL	2			/* shipping data tail */
#define LAMD_GER	4			/* GER protocol */
#define LAMD_DONE	3			/* completed */

/*
 * lamd request flags
 */
#define LAMD_RECVMODE	1			/* recv or probe */
#define LAMD_SSEND	2			/* msg is synchronous */

/*
 * polling defaults
 */
#ifndef MPIL_LPD_BASE
#define MPIL_LPD_BASE	50000
#endif

#ifndef MPIL_LPD_MAX
#define MPIL_LPD_MAX	1000000
#endif

/*
 * public functions
 */
int			_rpi_lamd_init(void);
int			_rpi_lamd_addprocs(void);
int			_rpi_lamd_build(MPI_Request req);
int			_rpi_lamd_start(MPI_Request req_top,
					MPI_Request req);
int			_rpi_lamd_destroy(MPI_Request req);
int			_rpi_lamd_advance(MPI_Request req_top,
					  int flag_block);
int			_rpi_lamd_iprobe(MPI_Request req);
int			_rpi_lamd_finalize(struct _proc	*p);


#endif	/* _RPI_LAMD_H */
