/*
 * Copyright 1998-2001, University of Notre Dame.
 * Authors: Jeffrey M. Squyres, Arun Rodrigues, and Brian Barrett with
 *          Kinis L. Meyer, M. D. McNally, and Andrew Lumsdaine
 * 
 * This file is part of the Notre Dame LAM implementation of MPI.
 * 
 * You should have received a copy of the License Agreement for the Notre
 * Dame LAM implementation of MPI along with the software; see the file
 * LICENSE.  If not, contact Office of Research, University of Notre
 * Dame, Notre Dame, IN 46556.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted subject to the conditions specified in the
 * LICENSE file.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 * 
 * Additional copyrights may follow.
 * 
 *	Ohio Trollius
 *	Copyright 1995 The Ohio State University
 *	GDB
 *
 *	$Log: proc_schema.h,v $
 *	Revision 1.1  2000/02/12 00:14:19  jsquyres
 *	Moved share/boot/proc_schema.a to share/include/proc_schema.h 'cause
 *	multiple places include it.
 *	
 *	Revision 6.2  1999/05/23 19:28:25  kmeyer1
 *	added copyrights
 *	
 *	Revision 6.1  1996/11/24 00:44:59  nevin
 *	Ohio Release
 *	
 * Revision 6.0  96/02/29  13:41:36  gdburns
 * Ohio Release
 * 
 *	Function:	- internal representation of a process schema
 */

#ifndef _PROC_SCHEMA
#define _PROC_SCHEMA

#include <portable.h>

#define PSC_MAXLINE	256
#define PSC_DELAY	1

/*
 * process schema list entry
 */
struct psc {
	char		**psc_argv;	/* argv */
	int4		psc_argc;	/* argc */
	int4		psc_delay;	/* delay (in seconds) after startup */
	int4		psc_flags;	/* info bits */
};

#endif
