/*
 * Copyright 1998-2001, University of Notre Dame.
 * Authors: Jeffrey M. Squyres, Arun Rodrigues, and Brian Barrett with
 *          Kinis L. Meyer, M. D. McNally, and Andrew Lumsdaine
 * 
 * This file is part of the Notre Dame LAM implementation of MPI.
 * 
 * You should have received a copy of the License Agreement for the Notre
 * Dame LAM implementation of MPI along with the software; see the file
 * LICENSE.  If not, contact Office of Research, University of Notre
 * Dame, Notre Dame, IN 46556.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted subject to the conditions specified in the
 * LICENSE file.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 * 
 * Additional copyrights may follow.
 * 
 *
 *	$Id: ndi.h,v 6.4 1999/04/01 21:38:52 kmeyer1 Exp $
 * 
 *	Function:	- node identifier parsing
 */

#ifndef _NDI_H
#define _NDI_H

#include <lam_config.h>
#include "all_list.h"
#include "lam.h"

/*
 * node identifier list entry
 */
struct ndi {
	int4		ndi_node;	/* ID itself */
	int4		ndi_flags;	/* descriptive flags */
	int4		ndi_count;	/* # IDs actually represented */
	int4		ndi_index;	/* position in list (legacy) */
};

#ifdef __cplusplus
extern "C" {
#endif

extern LIST *	ndi_parse __ARGS((int argc, char ** argv, char *** othersv));
extern LIST *	ndi_resolve __ARGS((LIST * nodelist));
extern void	ndi_fmt __ARGS((int4 node, char * fmt_str));
extern int4	ndi_parse1 __ARGS((char * s));
extern void	ndi_usage __ARGS((void));

#ifdef __cplusplus
}
#endif

#endif	/* _NDI_H */
