/*
 * Copyright 1998-2001, University of Notre Dame.
 * Authors: Jeffrey M. Squyres, Arun Rodrigues, and Brian Barrett with
 *          Kinis L. Meyer, M. D. McNally, and Andrew Lumsdaine
 * 
 * This file is part of the Notre Dame LAM implementation of MPI.
 * 
 * You should have received a copy of the License Agreement for the Notre
 * Dame LAM implementation of MPI along with the software; see the file
 * LICENSE.  If not, contact Office of Research, University of Notre
 * Dame, Notre Dame, IN 46556.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted subject to the conditions specified in the
 * LICENSE file.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 * 
 * Additional copyrights may follow.
 * 
 *	Ohio Trollius
 *	Copyright 1994 The Ohio State University
 *	RBD
 *
 *	$Log: f2cstring.c,v $
 *	Revision 6.2  1999/05/24 16:56:48  kmeyer1
 *	added $copyright$
 *	
 *	Revision 6.1  1996/11/23 19:57:55  nevin
 *	Ohio Release
 *	
 * Revision 6.0  96/02/29  13:46:30  gdburns
 * Ohio Release
 * 
 * Revision 5.2  94/08/22  13:57:00  gdburns
 * Ohio Release
 * 
 * Revision 5.1  94/05/18  10:56:43  gdburns
 * Ohio Release
 * 
 * Revision 2.3  94/04/22  12:34:58  gdburns
 * Ohio Release
 * 
 * Revision 2.2  94/02/15  18:06:16  raja
 * pre-release to 2.3
 * 
 *	Function:	- create a C string from a F77 string
 *	Accepts:	- F77 string
 *			- string length
 *	Returns:	- C string or NULL
 */

#include <stdlib.h>
#include <string.h>

char *
f2cstring(str, len)

char			*str;
unsigned int		len;

{
	char		*cstr;
	int		i;
/*
 * Allocate space for the C string.
 */
	if ((cstr = malloc(len + 1)) == 0) {
		return((char *) 0);
	}

	if (len > 0) {
		strncpy(cstr, str, (int) len);
	}
/*
 * Bypass trailing spaces and null-terminate the string.
 * If all characters are spaces, leave the first one in.
 */
	for (i = len - 1; i > 0; --i) {
		if (cstr[i] != ' ') {
			break;
		}
	}

	if ((i >= 0) || (len == 0)) {
		cstr[i + 1] = '\0';
	}

	return(cstr);
}
