/*
 * Copyright 1998-2001, University of Notre Dame.
 * Authors: Jeffrey M. Squyres, Arun Rodrigues, and Brian Barrett with
 *          Kinis L. Meyer, M. D. McNally, and Andrew Lumsdaine
 * 
 * This file is part of the Notre Dame LAM implementation of MPI.
 * 
 * You should have received a copy of the License Agreement for the Notre
 * Dame LAM implementation of MPI along with the software; see the file
 * LICENSE.  If not, contact Office of Research, University of Notre
 * Dame, Notre Dame, IN 46556.
 * 
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted subject to the conditions specified in the
 * LICENSE file.
 * 
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR ``AS IS'' AND ANY EXPRESS OR
 * IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL THE AUTHOR BE LIABLE FOR ANY DIRECT,
 * INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR
 * SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT,
 * STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING
 * IN ANY WAY OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE
 * POSSIBILITY OF SUCH DAMAGE.
 * 
 * Additional copyrights may follow.
 * 
 *	Ohio Trollius
 *	Copyright 1994 The Ohio State University
 *	GDB
 *
 *	$Id: nrecv.c,v 6.3 1999/09/10 05:19:28 jsquyres Exp $
 * 
 *	Function:	- receives a buffered network message
 *	Accepts:	- ptr to network message descriptor
 *	Returns:	- 0 or ERROR
 */

#include <lam_config.h>

#include <bfreq.h>
#include <events.h>
#include <net.h>

int
nrecv(nhead)

struct nmsg		*nhead;

{
	struct bfreq	*req;		/* bufferd request */
	struct nmsg	bfhead;		/* bufferd message */

	if (!(nhead->nh_flags & NOBUF)) {
		LAM_ZERO_ME(bfhead);
		req = (struct bfreq *) bfhead.nh_data;
		req->bfq_req = BFQRECV;
		req->bfq_event = nhead->nh_event;
		req->bfq_type = nhead->nh_type;
		bfhead.nh_dl_event = EVBUFFERD;
		bfhead.nh_node = LOCAL;
		bfhead.nh_event = EVBUFFERD;
		bfhead.nh_type = DLCTL;
		bfhead.nh_flags = 0;
		bfhead.nh_length = 0;
		bfhead.nh_msg = 0;

		return(dsfr(&bfhead, nhead));
	} else {
		return(frecv(nhead));
	}
}
